package org.seasar.quartz;

import junit.framework.TestCase;
import org.quartz.JobDetail;

public class SimpleTriggerTest extends TestCase {

    public void testConstructor() {
	SimpleTrigger simpleTrigger = new SimpleTrigger();
	assertEquals("DEFAULT", simpleTrigger.getGroup());
	assertNotNull(simpleTrigger.getStartTime());
    }

    public void testSetMisfireInstruction() {
	SimpleTrigger simpleTrigger = new SimpleTrigger();

	simpleTrigger.setMisfireInstruction("MISFIRE_INSTRUCTION_SMART_POLICY");
	assertEquals(SimpleTrigger.MISFIRE_INSTRUCTION_SMART_POLICY, simpleTrigger.getMisfireInstruction());

	simpleTrigger.setMisfireInstruction("MISFIRE_INSTRUCTION_FIRE_NOW");
	assertEquals(SimpleTrigger.MISFIRE_INSTRUCTION_FIRE_NOW, simpleTrigger.getMisfireInstruction());

	simpleTrigger.setMisfireInstruction("MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT");
	assertEquals(SimpleTrigger.MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT, simpleTrigger.getMisfireInstruction());

	simpleTrigger.setMisfireInstruction("MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT");
	assertEquals(SimpleTrigger.MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT, simpleTrigger.getMisfireInstruction());

	simpleTrigger.setMisfireInstruction("MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT");
	assertEquals(SimpleTrigger.MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT, simpleTrigger.getMisfireInstruction());

	simpleTrigger.setMisfireInstruction("MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT");
	assertEquals(SimpleTrigger.MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT, simpleTrigger.getMisfireInstruction());

	try {
	    simpleTrigger.setMisfireInstruction("MISFIRE_INSTRUCTION_UNKNOWN");
	    fail();
	} catch (IllegalArgumentException expected) {
	}
    }

    public void testSetJobDetail() {
	SimpleTrigger simpleTrigger = new SimpleTrigger();
	JobDetail jobDetail = new JobDetail();
	jobDetail.setName("testName");
	jobDetail.setGroup("testGroup");
	simpleTrigger.setJobDetail(jobDetail);
	assertEquals("testName", simpleTrigger.getJobName());
	assertEquals("testGroup", simpleTrigger.getJobGroup());
    }
}
