package org.seasar.quartz;

import junit.framework.TestCase;

public class MethodInvokerJobDetailTest extends TestCase {

    public void testConstructor() {
	MethodInvokerJobDetail methodInvokerJobDetail = new MethodInvokerJobDetail();
	assertEquals("DEFAULT", methodInvokerJobDetail.getGroup());
	assertEquals(MethodInvokerJob.class, methodInvokerJobDetail.getJobClass());
	assertTrue(methodInvokerJobDetail.isVolatile());
    }

    public void testSetComponent() {
	Object component = new Object();
	MethodInvokerJobDetail methodInvokerJobDetail = new MethodInvokerJobDetail();
	methodInvokerJobDetail.setComponent(component);
	assertEquals(component, methodInvokerJobDetail.getJobDataMap().get("component"));
    }

    public void testSetMethod() {
	MethodInvokerJobDetail methodInvokerJobDetail = new MethodInvokerJobDetail();
	methodInvokerJobDetail.setMethod("testMethod");
	assertEquals("testMethod", methodInvokerJobDetail.getJobDataMap().getString("method"));
    }

    public void testSetStateful() {
	MethodInvokerJobDetail methodInvokerJobDetail = new MethodInvokerJobDetail();
	methodInvokerJobDetail.setStateful(true);
	assertEquals(StatefulMethodInvokerJob.class, methodInvokerJobDetail.getJobClass());

	methodInvokerJobDetail.setStateful(false);
	assertEquals(MethodInvokerJob.class, methodInvokerJobDetail.getJobClass());
    }
}
