package org.seasar.quartz;

import junit.framework.TestCase;
import org.quartz.JobDetail;

public class CronTriggerTest extends TestCase {

    public void testConstructor() {
	CronTrigger cronTrigger = new CronTrigger();
	assertEquals("DEFAULT", cronTrigger.getGroup());
	assertNotNull(cronTrigger.getStartTime());
    }

    public void testSetMisfireInstruction() {
	CronTrigger cronTrigger = new CronTrigger();

	cronTrigger.setMisfireInstruction("MISFIRE_INSTRUCTION_SMART_POLICY");
	assertEquals(CronTrigger.MISFIRE_INSTRUCTION_SMART_POLICY, cronTrigger.getMisfireInstruction());

	cronTrigger.setMisfireInstruction("MISFIRE_INSTRUCTION_DO_NOTHING");
	assertEquals(CronTrigger.MISFIRE_INSTRUCTION_DO_NOTHING, cronTrigger.getMisfireInstruction());

	cronTrigger.setMisfireInstruction("MISFIRE_INSTRUCTION_FIRE_ONCE_NOW");
	assertEquals(CronTrigger.MISFIRE_INSTRUCTION_FIRE_ONCE_NOW, cronTrigger.getMisfireInstruction());

	try {
	    cronTrigger.setMisfireInstruction("MISFIRE_INSTRUCTION_UNKNOWN");
	    fail();
	} catch (IllegalArgumentException expected) {
	}
    }

    public void testSetJobDetail() {
	CronTrigger cronTrigger = new CronTrigger();
	JobDetail jobDetail = new JobDetail();
	jobDetail.setName("testName");
	jobDetail.setGroup("testGroup");
	cronTrigger.setJobDetail(jobDetail);
	assertEquals("testName", cronTrigger.getJobName());
	assertEquals("testGroup", cronTrigger.getJobGroup());
    }
}
