package org.seasar.quartz;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.quartz.JobDetail;
import org.quartz.Scheduler;

public class SimpleTrigger extends org.quartz.SimpleTrigger {

    private final static List MISFIRE_INSTRUCTIONS = Arrays.asList(new String[] {
	"MISFIRE_INSTRUCTION_SMART_POLICY",
	"MISFIRE_INSTRUCTION_FIRE_NOW",
	"MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT",
	"MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT",
	"MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT",
	"MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT"
    });

    public SimpleTrigger() {
	setGroup(Scheduler.DEFAULT_GROUP);
	setStartTime(new Date());
    }

    public void setMisfireInstruction(String misfireInstruction) {
	setMisfireInstruction(MISFIRE_INSTRUCTIONS.indexOf(misfireInstruction));
    }

    public void setJobDetail(JobDetail jobDetail) {
	setJobName(jobDetail.getName());
	setJobGroup(jobDetail.getGroup());
    }
}
