package org.seasar.quartz;

import java.lang.reflect.Method;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;

public class MethodInvokerJob implements Job {
    public static final String COMPONENT = "component";
    public static final String METHOD = "method";

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
	JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
	Object component = jobDataMap.get(COMPONENT);
	String methodName = jobDataMap.getString(METHOD);
	Method method = ClassUtil.getMethod(component.getClass(), methodName, null);
	MethodUtil.invoke(method, component, null);
    }
}
