package org.seasar.quartz;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.quartz.JobDetail;
import org.quartz.Scheduler;

public class CronTrigger extends org.quartz.CronTrigger {

    private final static List MISFIRE_INSTRUCTIONS = Arrays.asList(new String[] {
	"MISFIRE_INSTRUCTION_SMART_POLICY",
	"MISFIRE_INSTRUCTION_FIRE_ONCE_NOW",
	"MISFIRE_INSTRUCTION_DO_NOTHING"
    });

    public CronTrigger() {
	setGroup(Scheduler.DEFAULT_GROUP);
	setStartTime(new Date());
    }

    public void setMisfireInstruction(String misfireInstruction) {
	setMisfireInstruction(MISFIRE_INSTRUCTIONS.indexOf(misfireInstruction));
    }

    public void setJobDetail(JobDetail jobDetail) {
	setJobName(jobDetail.getName());
	setJobGroup(jobDetail.getGroup());
    }
}
