package org.seasar.quartz;

import junit.framework.TestCase;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.impl.StdScheduler;
import org.quartz.spi.TriggerFiredBundle;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.S2ContainerImpl;

public class ProxyJobTest extends TestCase {

    public void testExecute() throws JobExecutionException {
	S2Container container = new S2ContainerImpl();
	container.register(TestJob.class);

	final SchedulerContext schedulerContext = new SchedulerContext();
	schedulerContext.put("container", container);
	Scheduler scheduler = new StdScheduler(null, null) {
		public SchedulerContext getContext() throws SchedulerException {
		    return schedulerContext;
		}
	    };

	JobExecutionContext jobExecutionContext = new JobExecutionContext(scheduler, new TriggerFiredBundle(new JobDetail(), null, null, false, null, null, null, null), null);
	jobExecutionContext.getJobDetail().getJobDataMap().put("componentKey", TestJob.class);

	Job job = new ProxyJob();
	job.execute(jobExecutionContext);

	TestJob testJob = (TestJob) container.getComponent(TestJob.class);
	assertEquals("<execute>", testJob.toString());
    }

    public static class TestJob implements Job {
	private StringBuffer stringBuffer = new StringBuffer();

	public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
	    stringBuffer.append("<execute>");
	}

	public String toString() {
	    return stringBuffer.toString();
	}
    }
}
