package org.seasar.quartz;

import junit.framework.TestCase;

public class ProxyJobDetailTest extends TestCase {

    public void testConstructor() {
	ProxyJobDetail proxyJobDetail = new ProxyJobDetail();
	assertEquals("DEFAULT", proxyJobDetail.getGroup());
	assertEquals(ProxyJob.class, proxyJobDetail.getJobClass());
    }

    public void testSetComponentKey() {
	ProxyJobDetail proxyJobDetail = new ProxyJobDetail();
	proxyJobDetail.setComponentKey("testComponentKey");
	assertEquals("testComponentKey", proxyJobDetail.getJobDataMap().get("componentKey"));
    }

    public void testSetStateful() {
	ProxyJobDetail proxyJobDetail = new ProxyJobDetail();
	proxyJobDetail.setStateful(true);
	assertEquals(StatefulProxyJob.class, proxyJobDetail.getJobClass());

	proxyJobDetail.setStateful(false);
	assertEquals(ProxyJob.class, proxyJobDetail.getJobClass());
    }
}
