package org.seasar.quartz;

import junit.framework.TestCase;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.spi.TriggerFiredBundle;

public class MethodInvokerJobTest extends TestCase {

    public void testExecute() throws JobExecutionException {
	TestComponent testComponent = new TestComponent();

	JobExecutionContext jobExecutionContext = new JobExecutionContext(null, new TriggerFiredBundle(new JobDetail(), null, null, false, null, null, null, null), null);
	jobExecutionContext.getJobDetail().getJobDataMap().put("component", testComponent);
	jobExecutionContext.getJobDetail().getJobDataMap().put("method", "execute");

	Job job = new MethodInvokerJob();
	job.execute(jobExecutionContext);

	assertEquals("<execute>", testComponent.toString());
    }

    public static class TestComponent {
	private StringBuffer stringBuffer = new StringBuffer();

	public void execute() {
	    stringBuffer.append("<execute>");
	}

	public String toString() {
	    return stringBuffer.toString();
	}
    }
}
