package org.seasar.quartz;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SchedulerListener;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;
import org.seasar.framework.container.S2Container;

public class SchedulerImpl implements Scheduler {
    public static final String CONTAINER = "container";
    private final Scheduler scheduler;

    public SchedulerImpl(SchedulerFactory schedulerFactory, S2Container container) throws SchedulerException {
	scheduler = schedulerFactory.getScheduler();
	getContext().put(CONTAINER, container.getRoot());
    }

    public String getSchedulerName() throws SchedulerException {
	return scheduler.getSchedulerName();
    }

    public String getSchedulerInstanceId() throws SchedulerException {
	return scheduler.getSchedulerInstanceId();
    }

    public SchedulerContext getContext() throws SchedulerException {
	return scheduler.getContext();
    }

    public void start() throws SchedulerException {
	scheduler.start();
    }

    public void pause() throws SchedulerException {
	scheduler.pause();
    }

    public boolean isPaused() throws SchedulerException {
	return scheduler.isPaused();
    }

    public void shutdown() throws SchedulerException {
	scheduler.shutdown();
    }

    public void shutdown(boolean waitForJobsToComplete) throws SchedulerException {
	scheduler.shutdown(waitForJobsToComplete);
    }

    public boolean isShutdown() throws SchedulerException {
	return scheduler.isShutdown();
    }

    public SchedulerMetaData getMetaData() throws SchedulerException {
	return scheduler.getMetaData();
    }

    public List getCurrentlyExecutingJobs() throws SchedulerException {
	return scheduler.getCurrentlyExecutingJobs();
    }

    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
	return scheduler.scheduleJob(jobDetail, trigger);
    }

    public Date scheduleJob(Trigger trigger) throws SchedulerException {
	return scheduler.scheduleJob(trigger);
    }

    public boolean unscheduleJob(String triggerName, String groupName) throws SchedulerException {
	return scheduler.unscheduleJob(triggerName, groupName);
    }

    public Date rescheduleJob(String triggerName, String groupName, Trigger newTrigger) throws SchedulerException {
	return scheduler.rescheduleJob(triggerName, groupName, newTrigger);
    }

    public void addJob(JobDetail jobDetail, boolean replace) throws SchedulerException {
	scheduler.addJob(jobDetail, replace);
    }

    public boolean deleteJob(String jobName, String groupName) throws SchedulerException {
	return scheduler.deleteJob(jobName, groupName);
    }

    public void triggerJob(String jobName, String groupName) throws SchedulerException {
	scheduler.triggerJob(jobName, groupName);
    }

    public void triggerJobWithVolatileTrigger(String jobName, String groupName) throws SchedulerException {
	scheduler.triggerJobWithVolatileTrigger(jobName, groupName);
    }

    public void pauseJob(String jobName, String groupName) throws SchedulerException {
	scheduler.pauseJob(jobName, groupName);
    }

    public void pauseJobGroup(String groupName) throws SchedulerException {
	scheduler.pauseJobGroup(groupName);
    }

    public void pauseTrigger(String triggerName, String groupName) throws SchedulerException {
	scheduler.pauseTrigger(triggerName, groupName);
    }

    public void pauseTriggerGroup(String groupName) throws SchedulerException {
	scheduler.pauseTriggerGroup(groupName);
    }

    public void resumeJob(String jobName, String groupName) throws SchedulerException {
	scheduler.resumeJob(jobName, groupName);
    }

    public void resumeJobGroup(String groupName) throws SchedulerException {
	scheduler.resumeJobGroup(groupName);
    }

    public void resumeTrigger(String triggerName, String groupName) throws SchedulerException {
	scheduler.resumeTrigger(triggerName, groupName);
    }

    public void resumeTriggerGroup(String groupName) throws SchedulerException {
	scheduler.resumeTriggerGroup(groupName);
    }

    public void pauseAll() throws SchedulerException {
	scheduler.pauseAll();
    }

    public void resumeAll() throws SchedulerException {
	scheduler.resumeAll();
    }

    public String[] getJobGroupNames() throws SchedulerException {
	return scheduler.getJobGroupNames();
    }

    public String[] getJobNames(String groupName) throws SchedulerException {
	return scheduler.getJobNames(groupName);
    }

    public Trigger[] getTriggersOfJob(String jobName, String groupName) throws SchedulerException {
	return scheduler.getTriggersOfJob(jobName, groupName);
    }

    public String[] getTriggerGroupNames() throws SchedulerException {
	return scheduler.getTriggerGroupNames();
    }

    public String[] getTriggerNames(String groupName) throws SchedulerException {
	return scheduler.getTriggerNames(groupName);
    }

    public Set getPausedTriggerGroups() throws SchedulerException {
	return scheduler.getPausedTriggerGroups();
    }

    public JobDetail getJobDetail(String jobName, String jobGroup) throws SchedulerException {
	return scheduler.getJobDetail(jobName, jobGroup);
    }

    public Trigger getTrigger(String triggerName, String triggerGroup) throws SchedulerException {
	return scheduler.getTrigger(triggerName, triggerGroup);
    }

    public int getTriggerState(String triggerName, String triggerGroup) throws SchedulerException {
	return scheduler.getTriggerState(triggerName, triggerGroup);
    }

    public void addCalendar(String calendarName, Calendar calendar, boolean replace, boolean updateTriggers) throws SchedulerException {
	scheduler.addCalendar(calendarName, calendar, replace, updateTriggers);
    }

    public boolean deleteCalendar(String calendarName) throws SchedulerException {
	return scheduler.deleteCalendar(calendarName);
    }

    public Calendar getCalendar(String calendarName) throws SchedulerException {
	return scheduler.getCalendar(calendarName);
    }

    public String[] getCalendarNames() throws SchedulerException {
	return scheduler.getCalendarNames();
    }

    public void addGlobalJobListener(JobListener jobListener) throws SchedulerException {
	scheduler.addGlobalJobListener(jobListener);
    }

    public void addJobListener(JobListener jobListener) throws SchedulerException {
	scheduler.addJobListener(jobListener);
    }

    public boolean removeGlobalJobListener(JobListener jobListener) throws SchedulerException {
	return scheduler.removeGlobalJobListener(jobListener);
    }

    public boolean removeJobListener(String name) throws SchedulerException {
	return scheduler.removeJobListener(name);
    }

    public List getGlobalJobListeners() throws SchedulerException {
	return scheduler.getGlobalJobListeners();
    }

    public Set getJobListenerNames() throws SchedulerException {
	return scheduler.getJobListenerNames();
    }

    public JobListener getJobListener(String name) throws SchedulerException {
	return scheduler.getJobListener(name);
    }

    public void addGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
	scheduler.addGlobalTriggerListener(triggerListener);
    }

    public void addTriggerListener(TriggerListener triggerListener) throws SchedulerException {
	scheduler.addTriggerListener(triggerListener);
    }

    public boolean removeGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
	return scheduler.removeGlobalTriggerListener(triggerListener);
    }

    public boolean removeTriggerListener(String name) throws SchedulerException {
	return scheduler.removeTriggerListener(name);
    }

    public List getGlobalTriggerListeners() throws SchedulerException {
	return scheduler.getGlobalTriggerListeners();
    }

    public Set getTriggerListenerNames() throws SchedulerException {
	return scheduler.getTriggerListenerNames();
    }

    public TriggerListener getTriggerListener(String name) throws SchedulerException {
	return scheduler.getTriggerListener(name);
    }

    public void addSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
	scheduler.addSchedulerListener(schedulerListener);
    }

    public boolean removeSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
	return scheduler.removeSchedulerListener(schedulerListener);
    }

    public List getSchedulerListeners() throws SchedulerException {
	return scheduler.getSchedulerListeners();
    }

    public boolean interrupt(String jobName, String groupName) throws UnableToInterruptJobException {
	return scheduler.interrupt(jobName, groupName);
    }
}
