package org.seasar.quartz;

import org.quartz.JobDetail;
import org.quartz.Scheduler;

public class ProxyJobDetail extends JobDetail {

    public ProxyJobDetail() {
	setGroup(Scheduler.DEFAULT_GROUP);
	setJobClass(ProxyJob.class);
    }

    public void setComponentKey(Object componentKey) {
	getJobDataMap().put(ProxyJob.COMPONENT_KEY, componentKey);
    }

    public void setStateful(boolean stateful) {
	if (stateful) {
	    setJobClass(StatefulProxyJob.class);
	} else {
	    setJobClass(ProxyJob.class);
	}
    }
}
