package org.seasar.quartz;

import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.seasar.framework.container.S2Container;

public class ProxyJob implements Job {
    public static final String COMPONENT_KEY = "componentKey";

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
	SchedulerContext schedulerContext;
	try {
	    schedulerContext = jobExecutionContext.getScheduler().getContext();
	} catch (SchedulerException e) {
	    throw new JobExecutionException(e);
	}

	S2Container container = (S2Container) schedulerContext.get(SchedulerImpl.CONTAINER);
	JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
	Object componentKey = jobDataMap.get(COMPONENT_KEY);
	Job job = (Job) container.getComponent(componentKey);
	job.execute(jobExecutionContext);
    }
}
