package org.seasar.quartz;

import org.quartz.JobDetail;
import org.quartz.Scheduler;

public class MethodInvokerJobDetail extends JobDetail {

    public MethodInvokerJobDetail() {
	setGroup(Scheduler.DEFAULT_GROUP);
	setJobClass(MethodInvokerJob.class);
	setVolatility(true);
    }

    public void setComponent(Object component) {
	getJobDataMap().put(MethodInvokerJob.COMPONENT, component);
    }

    public void setMethod(String methodName) {
	getJobDataMap().put(MethodInvokerJob.METHOD, methodName);
    }

    public void setStateful(boolean stateful) {
	if (stateful) {
	    setJobClass(StatefulMethodInvokerJob.class);
	} else {
	    setJobClass(MethodInvokerJob.class);
	}
    }
}
