package org.seasar.webwork.nazo;

import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.RuntimeConfiguration;
import com.opensymphony.xwork.config.entities.PackageConfig;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.container.S2Container;

public class ConfigurationImpl implements Configuration {
    private final Configuration configuration;
    private final S2Container container;

    public ConfigurationImpl(Configuration configuration, S2Container container) {
	this.configuration = configuration;
	this.container = container;
    }

    public void rebuildRuntimeConfiguration() {
	configuration.rebuildRuntimeConfiguration();
    }

    public PackageConfig getPackageConfig(String name) {
	return configuration.getPackageConfig(name);
    }

    public Set getPackageConfigNames() {
	return configuration.getPackageConfigNames();
    }

    public Map getPackageConfigs() {
	return configuration.getPackageConfigs();
    }

    public RuntimeConfiguration getRuntimeConfiguration() {
	return new RuntimeConfigurationImpl(configuration.getRuntimeConfiguration(), container);
    }

    public void addPackageConfig(String name, PackageConfig packageConfig) {
	configuration.addPackageConfig(name, packageConfig);
    }

    public void destroy() {
	configuration.destroy();
    }

    public void reload() throws ConfigurationException {
	configuration.reload();
    }

    public void removePackageConfig(String name) {
	configuration.removePackageConfig(name);
    }
}
