package org.seasar.webwork.nazo;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.xwork.ObjectFactory;
import groovy.lang.GroovyObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.seasar.extension.mock.servlet.MockServletContext;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.S2ContainerImpl;

public class S2NazoObjectFactoryTest extends TestCase {
    private S2Container container;
    private ObjectFactory objectFactory;

    public void setUp() {
	container = new S2ContainerImpl();
	objectFactory = new S2NazoObjectFactory(container);
    }

    public void testGetJavaClassInstance() throws ClassNotFoundException {
	Class clazz = objectFactory.getClassInstance("java.lang.String");
	assertEquals(String.class, clazz);
    }

    public void testGetGroovyClassInstance() throws ClassNotFoundException {
	final String testScript = "import com.opensymphony.xwork.Action\n"
	    + "\n"
	    + "class test implements Action {\n"
	    + "    String execute() {\n"
	    + "        return 'success'\n"
	    + "    }\n"
	    + "}";

	container.setServletContext(new MockServletContext("/s2-nazo-webwork") {
		public InputStream getResourceAsStream(String path) {
		    assertEquals("/WEB-INF/nazo/test.groovy", path);
		    return new ByteArrayInputStream(testScript.getBytes());
		}
	    });

	Class clazz = objectFactory.getClassInstance("/WEB-INF/nazo/test.groovy");
	assertEquals("test", clazz.getName());
    }

    public void testI18N() throws Exception {
	final String testScript = "import com.opensymphony.xwork.Action\n"
	    + "\n"
	    + "class hello implements Action {\n"
	    + "    String world = ''\n"
	    + "    String execute() {\n"
	    + "        return 'success'\n"
	    + "    }\n"
	    + "}";

	container.setServletContext(new MockServletContext("/s2-nazo-webwork") {
		public InputStream getResourceAsStream(String path) {
		    return new ByteArrayInputStream(testScript.getBytes());
		}
	    });

	Configuration.set("webwork.i18n.encoding", "EUC-JP");

 	String fileEncoding = System.getProperty("file.encoding");
 	try {
	    System.setProperty("file.encoding", "US-ASCII");
	    Class clazz = objectFactory.getClassInstance("/WEB-INF/nazo/test.groovy");
	    GroovyObject groovyObject = (GroovyObject) objectFactory.buildBean(clazz);
	    String world = (String) groovyObject.getProperty("world");
	    assertEquals("", world);
 	} finally {
 	    System.setProperty("file.encoding", fileEncoding);
 	}
    }
}
