package org.seasar.webwork.nazo;

import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class ResultConfigMapTest extends TestCase {

    public void testGet() {
	Configuration configuration = ConfigurationManager.getConfiguration();
	PackageConfig defaultPackageConfig = configuration.getPackageConfig("webwork-default");
	List parents = Collections.singletonList(defaultPackageConfig);
	PackageConfig nazoPackageConfig = new PackageConfig("nazo", "", true, null, parents);
	configuration.addPackageConfig(nazoPackageConfig.getName(), nazoPackageConfig);

	Map nazoMap = new ResultConfigMap("testActionName");
	Object result = nazoMap.get("testResultCode");
	assertTrue(result instanceof ResultConfig);

	ResultConfig resultConfig = (ResultConfig) result;
	assertEquals("com.opensymphony.webwork.dispatcher.VelocityResult", resultConfig.getClassName());
	assertEquals("testResultCode", resultConfig.getName());
	assertEquals("/WEB-INF/nazo/testActionName_testResultCode.vm", resultConfig.getParams().get("location"));
    }
}
