package org.seasar.webwork;

import com.opensymphony.xwork.ObjectFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.servlet.S2ContainerServlet;

public class S2ObjectFactoryServlet extends HttpServlet {

    protected ObjectFactory createObjectFactory() {
	S2Container container = S2ContainerServlet.getContainer();
	return new S2ObjectFactory(container);
    }

    public void init() throws ServletException {
	ObjectFactory objectFactory = createObjectFactory();
	ObjectFactory.setObjectFactory(objectFactory);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
	httpServletResponse.getWriter().write("S2ObjectFactoryServlet is running.");
    }
}
