package org.seasar.webwork.nazo;

import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.RuntimeConfiguration;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.config.providers.InterceptorBuilder;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.seasar.framework.container.S2Container;

public class RuntimeConfigurationImpl implements RuntimeConfiguration {
    private final RuntimeConfiguration runtimeConfiguration;
    private final S2Container container;

    public RuntimeConfigurationImpl(RuntimeConfiguration runtimeConfiguration, S2Container container) {
	this.runtimeConfiguration = runtimeConfiguration;
	this.container = container;
    }

    public ActionConfig getActionConfig(String namespace, String name) {
	ActionConfig actionConfig = runtimeConfiguration.getActionConfig(namespace, name);
	if (actionConfig == null) {
	    PackageConfig packageConfig = ConfigurationManager.getConfiguration().getPackageConfig("nazo");
	    if (packageConfig != null && packageConfig.getNamespace().equals(namespace) && packageConfig.isAbstract()) {
		String scriptPath = "/WEB-INF/nazo/" + name + ".groovy";
		ServletContext servletContext = container.getServletContext();
		InputStream inputStream = servletContext.getResourceAsStream(scriptPath);
		if (inputStream != null) {
		    Map results = new ResultConfigMap(name);
		    List interceptors = InterceptorBuilder.constructInterceptorReference(packageConfig, packageConfig.getFullDefaultInterceptorRef(), null);
		    actionConfig = new ActionConfig(null, scriptPath, null, results, interceptors, null, packageConfig.getName());
		}
	    }
	}
	return actionConfig;
    }

    public Map getActionConfigs() {
	return runtimeConfiguration.getActionConfigs();
    }
}
