package org.seasar.webwork.nazo;

import com.opensymphony.xwork.ObjectFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.servlet.S2ContainerServlet;
import org.seasar.webwork.S2ObjectFactoryServlet;

public class S2NazoObjectFactoryServlet extends S2ObjectFactoryServlet {

    public ObjectFactory createObjectFactory () {
	S2Container container = S2ContainerServlet.getContainer();
	return new S2NazoObjectFactory(container);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.getWriter().write("S2NazoObjectFactoryServlet is running.");
    }
}
