package org.seasar.webwork.nazo;

import com.opensymphony.webwork.config.Configuration;
import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.seasar.framework.container.S2Container;
import org.seasar.webwork.S2ObjectFactory;

public class S2NazoObjectFactory extends S2ObjectFactory {

    protected S2NazoObjectFactory(S2Container container) {
	super(container);
    }

    public Class getClassInstance(String className) throws ClassNotFoundException {
	Class clazz;
	if (className.startsWith("/WEB-INF/nazo/") && className.endsWith(".groovy")) {
	    try {
		ServletContext servletContext = container.getServletContext();
		InputStream inputStream = servletContext.getResourceAsStream(className);

		CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
		try {
		    String encoding = Configuration.getString("webwork.i18n.encoding");
		    compilerConfiguration.setSourceEncoding(encoding);
		} catch (IllegalArgumentException e) {
		}

		ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
		GroovyClassLoader groovyClassLoader = new GroovyClassLoader(classLoader, compilerConfiguration);
		clazz = groovyClassLoader.parseClass(inputStream, className);
	    } catch (CompilationFailedException e) {
		throw new ClassNotFoundException("Script not found: " + className, e);
	    } catch (IOException e) {
		throw new ClassNotFoundException("Script not found: " + className, e);
	    }
	} else {
	    clazz = super.getClassInstance(className);
	}
	return clazz;
    }
}
