package org.seasar.webwork.nazo;

import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationManager;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.servlet.S2ContainerServlet;

public class S2NazoConfigurationServlet extends HttpServlet {

    public void init() throws ServletException {
	S2Container container = S2ContainerServlet.getContainer();
	Configuration configuration = ConfigurationManager.getConfiguration();
	Configuration nazoConfiguration = new ConfigurationImpl(configuration, container);
	ConfigurationManager.setConfiguration(nazoConfiguration);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.getWriter().write("S2NazoConfigurationServlet is running.");
    }
}
