/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.zpt;

import java.lang.reflect.InvocationTargetException;
import net.skirnir.freyja.EvaluationRuntimeException;
import net.skirnir.freyja.TemplateContext;
import net.skirnir.freyja.VariableResolver;
import net.skirnir.freyja.zpt.tales.PathResolver;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.ymir.zpt.annotation.IgnoreException;
import org.seasar.ymir.zpt.util.YmirUtils;

public class YmirBeanPathResolver
implements PathResolver {
    private static final Log log_ = LogFactory.getLog(YmirBeanPathResolver.class);

    public boolean accept(TemplateContext context, VariableResolver varResolver, Object obj, String child) {
        return obj != null;
    }

    public Object resolve(TemplateContext context, VariableResolver varResolver, Object obj, String child) {
        YmirUtils.preserveTypeConversionHint(context, obj, child);
        try {
            return PropertyUtils.getProperty((Object)obj, (String)child);
        }
        catch (InvocationTargetException ex) {
            if (this.shouldIgnore(obj, ex)) {
                return null;
            }
            throw new EvaluationRuntimeException("Can't get property (" + obj.getClass().getName() + "/" + child + ")", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            if (!this.shouldIgnore(obj, ex) && log_.isDebugEnabled()) {
                log_.debug((Object)("No Such property (" + obj.getClass().getName() + "/" + child + "): treated as null"), (Throwable)ex);
            }
            return null;
        }
        catch (NestedNullException ex) {
            if (!this.shouldIgnore(obj, ex) && log_.isDebugEnabled()) {
                log_.debug((Object)("Certain property is null (" + obj.getClass().getName() + "/" + child + "): treated as null"), (Throwable)ex);
            }
            return null;
        }
        catch (IllegalAccessException ex) {
            if (this.shouldIgnore(obj, ex)) {
                return null;
            }
            throw new EvaluationRuntimeException("Can't get property (" + obj.getClass().getName() + "/" + child + ")", (Throwable)ex);
        }
        catch (RuntimeException ex) {
            if (this.shouldIgnore(obj, ex)) {
                return null;
            }
            throw ex;
        }
    }

    boolean shouldIgnore(Object obj, Throwable t) {
        IgnoreException annotation = obj.getClass().getAnnotation(IgnoreException.class);
        if (annotation == null) {
            return false;
        }
        if (annotation.value().length == 0) {
            return true;
        }
        for (Class<? extends Throwable> ignored : annotation.value()) {
            if (!ignored.isAssignableFrom(t.getClass())) continue;
            return true;
        }
        return false;
    }
}

