/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata;

import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.exception.PluginValueTypeNotFoundException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.beans.DfBeanDesc;
import org.seasar.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnPropertyTypeFactory;
import org.seasar.dbflute.s2dao.metadata.impl.TnPropertyTypeImpl;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnAbstractPropertyTypeFactory
implements TnPropertyTypeFactory {
    protected final Class<?> _beanClass;
    protected final TnBeanAnnotationReader _beanAnnotationReader;

    public TnAbstractPropertyTypeFactory(Class<?> beanClass, TnBeanAnnotationReader beanAnnotationReader) {
        this._beanClass = beanClass;
        this._beanAnnotationReader = beanAnnotationReader;
    }

    protected DfBeanDesc getBeanDesc() {
        return DfBeanDescFactory.getBeanDesc(this._beanClass);
    }

    protected TnPropertyType createPropertyType(DfPropertyDesc propertyDesc) {
        ValueType valueType = this.getValueType(propertyDesc);
        String columnDbName = this.getColumnDbName(propertyDesc);
        ColumnSqlName columnSqlName = this.getColumnSqlName(columnDbName);
        return new TnPropertyTypeImpl(propertyDesc, valueType, columnDbName, columnSqlName);
    }

    protected ValueType getValueType(DfPropertyDesc propertyDesc) {
        String propertyName = propertyDesc.getPropertyName();
        Class<?> propertyType = propertyDesc.getPropertyType();
        String keyName = this._beanAnnotationReader.getValueType(propertyDesc);
        if (keyName != null) {
            return this.findValueTypeByName(propertyName, propertyType, keyName);
        }
        return TnValueTypes.getValueType(propertyType);
    }

    protected String getColumnDbName(DfPropertyDesc propertyDesc) {
        String propertyName = propertyDesc.getPropertyName();
        String name = this._beanAnnotationReader.getColumnAnnotation(propertyDesc);
        return name != null ? name : propertyName;
    }

    protected abstract ColumnSqlName getColumnSqlName(String var1);

    protected ValueType findValueTypeByName(String propertyName, Class<?> propertyType, String keyName) {
        ValueType valueType = TnValueTypes.getPluginValueType(keyName);
        if (valueType != null) {
            return valueType;
        }
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found a plug-in value type by the name.");
        br.addItem("Bean Type");
        br.addElement(this._beanClass.getName());
        br.addItem("Property");
        br.addElement(propertyName);
        br.addElement(propertyType.getName());
        br.addItem("Key Name");
        br.addElement(keyName);
        String msg = br.buildExceptionMessage();
        throw new PluginValueTypeNotFoundException(msg);
    }
}

