/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.sequence;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSequenceMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.sequence.DfSequenceExtractorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSequenceExtractorOracle
extends DfSequenceExtractorBase {
    private static final Log _log = LogFactory.getLog(DfSequenceExtractorOracle.class);

    public DfSequenceExtractorOracle(DataSource dataSource, List<UnifiedSchema> unifiedSchemaList) {
        super(dataSource, unifiedSchemaList);
    }

    @Override
    protected Map<String, DfSequenceMetaInfo> doGetSequenceMap() {
        _log.info((Object)"...Loading sequence informations");
        StringKeyMap resultMap = StringKeyMap.createAsFlexibleOrdered();
        StringBuilder logSb = new StringBuilder();
        this.setupPureSequence((Map<String, DfSequenceMetaInfo>)resultMap, logSb);
        this.setupSequenceSynonym((Map<String, DfSequenceMetaInfo>)resultMap, logSb);
        _log.info((Object)logSb.toString());
        return resultMap;
    }

    protected void setupPureSequence(Map<String, DfSequenceMetaInfo> resultMap, StringBuilder logSb) {
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        String sql = this.buildMetaSelectSql();
        if (sql == null) {
            return;
        }
        _log.info((Object)sql);
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("SEQUENCE_OWNER");
        columnList.add("SEQUENCE_NAME");
        columnList.add("MIN_VALUE");
        columnList.add("MAX_VALUE");
        columnList.add("INCREMENT_BY");
        List<Map<String, String>> resultList = facade.selectStringList(sql, columnList);
        logSb.append(this.ln()).append("[SEQUENCE]");
        for (Map<String, String> recordMap : resultList) {
            DfSequenceMetaInfo info = new DfSequenceMetaInfo();
            String sequenceSchema = recordMap.get("SEQUENCE_OWNER");
            info.setSequenceSchema(sequenceSchema);
            String sequenceName = recordMap.get("SEQUENCE_NAME");
            info.setSequenceName(sequenceName);
            String minValue = recordMap.get("MIN_VALUE");
            info.setMinimumValue(minValue != null ? new BigDecimal(minValue) : null);
            String maxValue = recordMap.get("MAX_VALUE");
            info.setMaximumValue(maxValue != null ? new BigDecimal(maxValue) : null);
            String incrementSize = recordMap.get("INCREMENT_BY");
            info.setIncrementSize(incrementSize != null ? Integer.valueOf(incrementSize) : null);
            String key = this.buildSequenceMapKey(null, sequenceSchema, sequenceName);
            resultMap.put(key, info);
            logSb.append(this.ln()).append(" ").append(key).append(" = ").append(info.toString());
        }
    }

    protected String buildMetaSelectSql() {
        StringBuilder sb;
        if (!this._unifiedSchemaList.isEmpty()) {
            sb = new StringBuilder();
            for (UnifiedSchema unifiedSchema : this._unifiedSchemaList) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(unifiedSchema.getPureSchema()).append("'");
            }
        } else {
            return null;
        }
        String schemaCondition = sb.toString();
        return "select * from ALL_SEQUENCES where SEQUENCE_OWNER in (" + schemaCondition + ")";
    }

    protected void setupSequenceSynonym(Map<String, DfSequenceMetaInfo> resultMap, StringBuilder logSb) {
        DfJdbcFacade facade = new DfJdbcFacade(this._dataSource);
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("SYNONYM_OWNER");
        columnList.add("SYNONYM_NAME");
        columnList.add("SEQUENCE_OWNER");
        columnList.add("SEQUENCE_NAME");
        columnList.add("MIN_VALUE");
        columnList.add("MAX_VALUE");
        columnList.add("INCREMENT_BY");
        String sql = this.buildSequenceSynonymSelectSql();
        if (sql == null) {
            return;
        }
        _log.info((Object)sql);
        List<Map<String, String>> synonymList = facade.selectStringList(sql, columnList);
        for (Map<String, String> recordMap : synonymList) {
            DfSequenceMetaInfo info = new DfSequenceMetaInfo();
            String sequenceSchema = recordMap.get("SYNONYM_OWNER");
            info.setSequenceSchema(sequenceSchema);
            String sequenceName = recordMap.get("SYNONYM_NAME");
            info.setSequenceName(sequenceName);
            String minValue = recordMap.get("MIN_VALUE");
            info.setMinimumValue(minValue != null ? new BigDecimal(minValue) : null);
            String maxValue = recordMap.get("MAX_VALUE");
            info.setMaximumValue(maxValue != null ? new BigDecimal(maxValue) : null);
            String incrementSize = recordMap.get("INCREMENT_BY");
            info.setIncrementSize(incrementSize != null ? Integer.valueOf(incrementSize) : null);
            String key = this.buildSequenceMapKey(null, sequenceSchema, sequenceName);
            resultMap.put(key, info);
            logSb.append(this.ln()).append(" ").append(key).append(" = ").append(info.toString());
        }
    }

    protected String buildSequenceSynonymSelectSql() {
        StringBuilder sb;
        if (!this._unifiedSchemaList.isEmpty()) {
            sb = new StringBuilder();
            for (UnifiedSchema unifiedSchema : this._unifiedSchemaList) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(unifiedSchema.getPureSchema()).append("'");
            }
        } else {
            return null;
        }
        String schemaCondition = sb.toString();
        sb = new StringBuilder();
        sb.append("select OWNER as SYNONYM_OWNER, SYNONYM_NAME, SEQUENCE_OWNER");
        sb.append(", SEQUENCE_NAME, MIN_VALUE, MAX_VALUE, INCREMENT_BY");
        sb.append(" from ALL_SYNONYMS syn inner join ALL_SEQUENCES seq");
        sb.append(" on syn.TABLE_OWNER = seq.SEQUENCE_OWNER and syn.TABLE_NAME = seq.SEQUENCE_NAME");
        sb.append(" where syn.OWNER in (" + schemaCondition + ")");
        return sb.toString();
    }
}

