/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.exception.DfIllegalPropertySettingException;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfPrimaryKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.util.DfCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfUniqueKeyHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfUniqueKeyHandler.class);

    public DfPrimaryKeyMetaInfo getPrimaryKey(DatabaseMetaData metaData, DfTableMetaInfo tableInfo) throws SQLException {
        UnifiedSchema unifiedSchema = tableInfo.getUnifiedSchema();
        String tableName = tableInfo.getTableName();
        return this.getPrimaryKey(metaData, unifiedSchema, tableName);
    }

    public DfPrimaryKeyMetaInfo getPrimaryKey(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName) throws SQLException {
        DfPrimaryKeyMetaInfo info = this.doGetPrimaryKey(metaData, unifiedSchema, tableName);
        if (!info.hasPrimaryKey()) {
            info = this.doGetPrimaryKey(metaData, unifiedSchema, tableName.toLowerCase());
        }
        if (!info.hasPrimaryKey()) {
            info = this.doGetPrimaryKey(metaData, unifiedSchema, tableName.toUpperCase());
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DfPrimaryKeyMetaInfo doGetPrimaryKey(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName) throws SQLException {
        ResultSet rs;
        DfPrimaryKeyMetaInfo info;
        block5: {
            info = new DfPrimaryKeyMetaInfo();
            if (this.isPrimaryKeyExtractingUnsupported()) {
                if (!this.isDatabaseMsAccess()) return info;
                return this.processMSAccess(metaData, unifiedSchema, tableName, info);
            }
            rs = null;
            rs = this.getPrimaryKeyResultSetFromDBMeta(metaData, unifiedSchema, tableName);
            if (rs != null) break block5;
            DfPrimaryKeyMetaInfo dfPrimaryKeyMetaInfo = info;
            Object var10_8 = null;
            if (rs == null) return dfPrimaryKeyMetaInfo;
            rs.close();
            return dfPrimaryKeyMetaInfo;
        }
        try {
            while (rs.next()) {
                String metaTableName = rs.getString(3);
                if (this.checkMetaTableDiffIfNeeds(tableName, metaTableName)) continue;
                String columnName = rs.getString(4);
                String pkName = rs.getString(6);
                info.addPrimaryKey(columnName, pkName);
            }
            Object var10_9 = null;
            if (rs == null) return info;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
        return info;
    }

    protected ResultSet getPrimaryKeyResultSetFromDBMeta(DatabaseMetaData dbMeta, UnifiedSchema unifiedSchema, String tableName) {
        try {
            String catalogName = unifiedSchema.getPureCatalog();
            String schemaName = unifiedSchema.getPureSchema();
            return dbMeta.getPrimaryKeys(catalogName, schemaName, tableName);
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    protected void assertPrimaryKeyNotExcepted(DfPrimaryKeyMetaInfo info, UnifiedSchema unifiedSchema, String tableName) {
        List<String> primaryKeyList = info.getPrimaryKeyList();
        for (String primaryKey : primaryKeyList) {
            if (!this.isColumnExcept(unifiedSchema, tableName, primaryKey)) continue;
            String msg = "PK columns are unsupported on 'columnExcept' property:";
            msg = msg + " unifiedSchema=" + unifiedSchema + " tableName=" + tableName;
            msg = msg + " primaryKey=" + primaryKey;
            throw new DfIllegalPropertySettingException(msg);
        }
    }

    protected DfPrimaryKeyMetaInfo processMSAccess(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName, DfPrimaryKeyMetaInfo info) throws SQLException {
        List emptyList = DfCollectionUtil.emptyList();
        Map<String, Map<Integer, String>> uqMap = this.getUniqueKeyMap(metaData, unifiedSchema, tableName, emptyList);
        String pkName = "PrimaryKey";
        Map<Integer, String> pkMap = uqMap.get("PrimaryKey");
        if (pkMap == null) {
            return info;
        }
        Set<Map.Entry<Integer, String>> entrySet = pkMap.entrySet();
        for (Map.Entry<Integer, String> entry : entrySet) {
            info.addPrimaryKey(entry.getValue(), "PrimaryKey");
        }
        return info;
    }

    public Map<String, Map<Integer, String>> getUniqueKeyMap(DatabaseMetaData metaData, DfTableMetaInfo tableInfo) throws SQLException {
        UnifiedSchema unifiedSchema = tableInfo.getUnifiedSchema();
        String tableName = tableInfo.getTableName();
        if (tableInfo.isTableTypeView()) {
            return this.newLinkedHashMap();
        }
        DfPrimaryKeyMetaInfo pkInfo = this.getPrimaryKey(metaData, tableInfo);
        return this.getUniqueKeyMap(metaData, unifiedSchema, tableName, pkInfo.getPrimaryKeyList());
    }

    public Map<String, Map<Integer, String>> getUniqueKeyMap(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName, List<String> pkList) throws SQLException {
        Map<String, Map<Integer, String>> resultMap = this.doGetUniqueKeyMap(metaData, unifiedSchema, tableName, pkList);
        if (resultMap.isEmpty()) {
            resultMap = this.doGetUniqueKeyMap(metaData, unifiedSchema, tableName.toLowerCase(), pkList);
        }
        if (resultMap.isEmpty()) {
            resultMap = this.doGetUniqueKeyMap(metaData, unifiedSchema, tableName.toUpperCase(), pkList);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Map<String, Map<Integer, String>> doGetUniqueKeyMap(DatabaseMetaData metaData, UnifiedSchema unifiedSchema, String tableName, List<String> pkList) throws SQLException {
        StringSet pkSet = StringSet.createAsFlexible();
        pkSet.addAll(pkList);
        LinkedHashMap<String, Map<Integer, String>> uniqueKeyMap = this.newLinkedHashMap();
        ResultSet rs = null;
        try {
            boolean uniqueKeyOnly = true;
            String catalogName = unifiedSchema.getPureCatalog();
            String schemaName = unifiedSchema.getPureSchema();
            rs = metaData.getIndexInfo(catalogName, schemaName, tableName, true, true);
            while (rs.next()) {
                Map<Integer, String> uniqueElementMap;
                Integer ordinalPosition;
                boolean isNonUnique;
                String metaTableName = rs.getString(3);
                if (this.checkMetaTableDiffIfNeeds(tableName, metaTableName)) continue;
                Boolean nonUnique = rs.getBoolean(4);
                boolean bl = isNonUnique = nonUnique != null && nonUnique != false;
                if (isNonUnique) continue;
                String indexType = rs.getString(7);
                String columnName = rs.getString(9);
                if (columnName == null || columnName.trim().length() == 0 || pkSet.contains((Object)columnName)) continue;
                if (this.isColumnExcept(unifiedSchema, tableName, columnName)) {
                    this.assertUQColumnNotExcepted(unifiedSchema, tableName, columnName);
                }
                String indexName = rs.getString(6);
                String ordinalPositionString = rs.getString(8);
                if (ordinalPositionString == null) {
                    String msg = "The unique columnName should have ordinal-position but null: ";
                    msg = msg + " columnName=" + columnName + " indexType=" + indexType;
                    _log.warn((Object)msg);
                    continue;
                }
                try {
                    ordinalPosition = Integer.parseInt(ordinalPositionString);
                }
                catch (NumberFormatException e) {
                    String msg = "The unique column should have ordinal-position as number but: ";
                    msg = msg + ordinalPositionString + " columnName=" + columnName + " indexType=" + indexType;
                    _log.warn((Object)msg);
                    continue;
                }
                if (uniqueKeyMap.containsKey(indexName)) {
                    uniqueElementMap = (Map)uniqueKeyMap.get(indexName);
                    uniqueElementMap.put(ordinalPosition, columnName);
                    continue;
                }
                uniqueElementMap = new LinkedHashMap();
                uniqueElementMap.put(ordinalPosition, columnName);
                uniqueKeyMap.put(indexName, uniqueElementMap);
            }
            Object var21_21 = null;
            if (rs == null) return uniqueKeyMap;
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
        return uniqueKeyMap;
    }

    protected void assertUQColumnNotExcepted(UnifiedSchema unifiedSchema, String tableName, String columnName) {
        if (this.isColumnExcept(unifiedSchema, tableName, columnName)) {
            String msg = "UQ columns are unsupported on 'columnExcept' property:";
            msg = msg + " unifiedSchema=" + unifiedSchema;
            msg = msg + " tableName=" + tableName;
            msg = msg + " columnName=" + columnName;
            throw new DfIllegalPropertySettingException(msg);
        }
    }
}

