/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.TypeMap;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.seasar.dbflute.exception.DfTableNotFoundException;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.factory.DfDbCommentExtractorFactory;
import org.seasar.dbflute.logic.factory.DfIdentityExtractorFactory;
import org.seasar.dbflute.logic.factory.DfSynonymExtractorFactory;
import org.seasar.dbflute.logic.jdbc.handler.DfAutoIncrementHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfColumnHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfForeignKeyHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfIndexHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfTableHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfUniqueKeyHandler;
import org.seasar.dbflute.logic.jdbc.metadata.comment.DfDbCommentExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.identity.DfIdentityExtractor;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfForeignKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfPrimaryKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSynonymMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.synonym.DfSynonymExtractor;
import org.seasar.dbflute.properties.DfAdditionalTableProperties;
import org.seasar.dbflute.properties.assistant.DfAdditionalSchemaInfo;
import org.seasar.dbflute.task.bs.DfAbstractTask;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorqueJDBCTransformTask
extends DfAbstractTask {
    private static final Log _log = LogFactory.getLog(TorqueJDBCTransformTask.class);
    protected DocumentImpl _doc;
    protected Element _databaseNode;
    protected DfTableHandler _tableHandler = new DfTableHandler();
    protected DfColumnHandler _columnHandler = new DfColumnHandler();
    protected DfUniqueKeyHandler _uniqueKeyHandler = new DfUniqueKeyHandler();
    protected DfIndexHandler _indexHandler = new DfIndexHandler();
    protected DfForeignKeyHandler _foreignKeyHandler = new DfForeignKeyHandler();
    protected DfAutoIncrementHandler _autoIncrementHandler = new DfAutoIncrementHandler();
    protected Map<String, Map<String, DfDbCommentExtractor.UserColComments>> _columnCommentAllMap;
    protected Map<String, String> _identityMap;
    protected Map<String, DfSynonymMetaInfo> _supplementarySynonymInfoMap;
    protected StringSet _refTableCheckSet;

    @Override
    protected boolean isUseDataSource() {
        return true;
    }

    @Override
    protected void doExecute() {
        _log.info((Object)"");
        _log.info((Object)"...Starting to process JDBC to SchemaXML");
        _log.info((Object)"Your DB settings are:");
        _log.info((Object)("  driver : " + this._driver));
        _log.info((Object)("  URL    : " + this._url));
        _log.info((Object)("  user   : " + this._userId));
        _log.info((Object)("  schema : " + this._schema));
        _log.info((Object)("  props  : " + this._connectionProperties));
        DocumentTypeImpl docType = new DocumentTypeImpl(null, "database", null, "http://dbflute.sandbox.seasar.org/dtd/database.dtd");
        this._doc = new DocumentImpl((DocumentType)docType);
        this._doc.appendChild((Node)this._doc.createComment(" Auto-generated by JDBC task! "));
        try {
            this.initializeIdentityMapIfNeeds();
            this.generateXML();
            String filePath = this.getBasicProperties().getProejctSchemaXMLFilePath();
            String encoding = this.getBasicProperties().getProejctSchemaXMLEncoding();
            _log.info((Object)"$ ");
            _log.info((Object)"$ ");
            _log.info((Object)"$ /* * * * * * * * * * * * * * * * * * * * * * * *");
            _log.info((Object)("$ ...Serializing XML: " + filePath + "(" + encoding + ")"));
            FileOutputStream fis = new FileOutputStream(filePath);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fis, encoding);
            OutputFormat outputFormar = new OutputFormat("xml", encoding, true);
            XMLSerializer xmlSerializer = new XMLSerializer((Writer)writer, outputFormar);
            xmlSerializer.serialize((Document)this._doc);
            _log.info((Object)"$ * * * * * * * * * */");
            _log.info((Object)"$ ");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        _log.info((Object)"------------------------------------------------------- [Torque - JDBCToXMLSchema] Finish!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateXML() throws Exception {
        _log.info((Object)"...Instantiate DB-driver");
        Class.forName(this._driver);
        _log.info((Object)"...Getting DB-connection");
        Connection conn = this.getDataSource().getConnection();
        _log.info((Object)"...Getting DB-meta-data");
        DatabaseMetaData dbMetaData = conn.getMetaData();
        _log.info((Object)"$ /**************************************************************************");
        _log.info((Object)"$ ");
        _log.info((Object)("$ dbMetaData.toString(): " + dbMetaData.toString()));
        _log.info((Object)("$ dbMetaData.getMaxRowSize(): " + dbMetaData.getMaxRowSize()));
        _log.info((Object)"$ ");
        List<DfTableMetaInfo> tableList = this.getTableNames(dbMetaData);
        _log.info((Object)("$ Table Count: " + tableList.size()));
        _log.info((Object)"$ *************************************/");
        _log.info((Object)"$ ");
        this._refTableCheckSet = StringSet.createAsFlexible();
        for (DfTableMetaInfo tableMetaInfo : tableList) {
            this._refTableCheckSet.add(tableMetaInfo.getTableName());
        }
        this._foreignKeyHandler.setRefTableCheckSet((Set<String>)this._refTableCheckSet);
        this.loadSupplementarySynonymInfoIfNeeds();
        this.processSynonymTable(tableList);
        this._databaseNode = this._doc.createElement("database");
        this._databaseNode.setAttribute("name", this._schema);
        _log.info((Object)"$ /= = = = = = = = = = = = = = = = = = = = = = = = = = = = =");
        for (int i = 0; i < tableList.size(); ++i) {
            Object var24_28;
            Element uniqueColumnElement;
            String columnName;
            Set<Integer> uniqueElementKeySet;
            Element uniqueKeyElement;
            String msg;
            Object var22_27;
            DfTableMetaInfo tableMataInfo = tableList.get(i);
            if (tableMataInfo.isOutOfGenerateTarget()) {
                _log.info((Object)("$ " + tableMataInfo.buildTableNameWithSchema() + " is out of generate target!"));
                continue;
            }
            _log.info((Object)("$ " + tableMataInfo));
            Element tableElement = this._doc.createElement("table");
            tableElement.setAttribute("name", tableMataInfo.getTableName());
            tableElement.setAttribute("type", tableMataInfo.getTableType());
            if (tableMataInfo.getTableSchema() != null && tableMataInfo.getTableSchema().trim().length() != 0) {
                tableElement.setAttribute("schema", tableMataInfo.getTableSchema());
            }
            if (tableMataInfo.getTableComment() != null && tableMataInfo.getTableComment().trim().length() != 0) {
                tableElement.setAttribute("comment", tableMataInfo.getTableComment());
            }
            DfPrimaryKeyMetaInfo pkInfo = this.getPrimaryColumnMetaInfo(dbMetaData, tableMataInfo);
            List<DfColumnMetaInfo> columns = this.getColumns(dbMetaData, tableMataInfo);
            for (int j = 0; j < columns.size(); ++j) {
                String defaultValue;
                String columnComment;
                DfColumnMetaInfo columnMetaInfo = columns.get(j);
                String columnName2 = columnMetaInfo.getColumnName();
                Element columnElement = this._doc.createElement("column");
                columnElement.setAttribute("name", columnName2);
                this.setupColumnType(columnMetaInfo, columnElement);
                this.setupColumnDbType(columnMetaInfo, columnElement);
                this.setupColumnJavaType(columnMetaInfo, columnElement);
                this.setupColumnSize(columnMetaInfo, columnElement);
                if (columnMetaInfo.isRequired()) {
                    columnElement.setAttribute("required", "true");
                }
                if (pkInfo.containsColumn(columnName2)) {
                    columnElement.setAttribute("primaryKey", "true");
                    String pkName = pkInfo.getPrimaryKeyName(columnName2);
                    if (pkName != null && pkName.trim().length() > 0) {
                        columnElement.setAttribute("pkName", pkInfo.getPrimaryKeyName(columnName2));
                    }
                }
                if ((columnComment = columnMetaInfo.getColumnComment()) != null) {
                    columnElement.setAttribute("comment", columnComment);
                }
                if ((defaultValue = columnMetaInfo.getDefaultValue()) != null) {
                    if (defaultValue.startsWith("(") && defaultValue.endsWith(")")) {
                        defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                    }
                    if (defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                        defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                    }
                    columnElement.setAttribute("default", defaultValue);
                }
                if (pkInfo.containsColumn(columnName2) && this.isAutoIncrementColumn(conn, tableMataInfo, columnName2)) {
                    columnElement.setAttribute("autoIncrement", "true");
                }
                tableElement.appendChild(columnElement);
            }
            Map<String, DfForeignKeyMetaInfo> foreignKeyMetaInfoMap = this.getForeignKeys(dbMetaData, tableMataInfo);
            Set<String> foreignKeyMetaInfoKeySet = foreignKeyMetaInfoMap.keySet();
            for (String foreignKeyName : foreignKeyMetaInfoKeySet) {
                DfForeignKeyMetaInfo foreignKeyMetaInfo = foreignKeyMetaInfoMap.get(foreignKeyName);
                Element foreignKeyElement = this._doc.createElement("foreign-key");
                foreignKeyElement.setAttribute("foreignTable", foreignKeyMetaInfo.getForeignTableName());
                foreignKeyElement.setAttribute("name", foreignKeyMetaInfo.getForeignKeyName());
                Map<String, String> columnNameMap = foreignKeyMetaInfo.getColumnNameMap();
                Set<String> columnNameKeySet = columnNameMap.keySet();
                for (String localColumnName : columnNameKeySet) {
                    String foreignColumnName = columnNameMap.get(localColumnName);
                    Element referenceElement = this._doc.createElement("reference");
                    referenceElement.setAttribute("local", localColumnName);
                    referenceElement.setAttribute("foreign", foreignColumnName);
                    foreignKeyElement.appendChild(referenceElement);
                }
                tableElement.appendChild(foreignKeyElement);
            }
            Map<String, Map<Integer, String>> uniqueMapForGettingIndex = null;
            Map<String, Map<Integer, String>> uniqueMap = null;
            try {
                try {
                    uniqueMap = this.getUniqueKeyMap(dbMetaData, tableMataInfo);
                }
                catch (SQLException e) {
                    _log.warn((Object)"Failed to get unique column information! But continue...", (Throwable)e);
                    var22_27 = null;
                    if (uniqueMap == null) {
                        uniqueMap = new LinkedHashMap<String, Map<Integer, String>>();
                    }
                }
                var22_27 = null;
                if (uniqueMap == null) {
                    uniqueMap = new LinkedHashMap<String, Map<Integer, String>>();
                }
            }
            catch (Throwable throwable) {
                var22_27 = null;
                if (uniqueMap == null) {
                    uniqueMap = new LinkedHashMap<String, Map<Integer, String>>();
                }
                throw throwable;
            }
            uniqueMapForGettingIndex = uniqueMap;
            Set<String> uniqueKeySet = uniqueMap.keySet();
            for (String uniqueIndexName : uniqueKeySet) {
                Map<Integer, String> uniqueElementMap = uniqueMap.get(uniqueIndexName);
                if (uniqueElementMap.isEmpty()) {
                    msg = "The uniqueKey has no elements: " + uniqueIndexName + " : " + uniqueMap;
                    throw new IllegalStateException(msg);
                }
                uniqueKeyElement = this._doc.createElement("unique");
                uniqueKeyElement.setAttribute("name", uniqueIndexName);
                uniqueElementKeySet = uniqueElementMap.keySet();
                for (Integer ordinalPosition : uniqueElementKeySet) {
                    columnName = uniqueElementMap.get(ordinalPosition);
                    uniqueColumnElement = this._doc.createElement("unique-column");
                    uniqueColumnElement.setAttribute("name", columnName);
                    uniqueColumnElement.setAttribute("position", ordinalPosition.toString());
                    uniqueKeyElement.appendChild(uniqueColumnElement);
                }
                tableElement.appendChild(uniqueKeyElement);
            }
            Map<String, Map<Integer, String>> indexMap = null;
            try {
                try {
                    indexMap = this.getIndexMap(dbMetaData, tableMataInfo, uniqueMapForGettingIndex);
                }
                catch (SQLException e) {
                    _log.warn((Object)"Failed to get unique column information! But continue...", (Throwable)e);
                    var24_28 = null;
                    if (indexMap == null) {
                        indexMap = new LinkedHashMap<String, Map<Integer, String>>();
                    }
                }
                var24_28 = null;
                if (indexMap == null) {
                    indexMap = new LinkedHashMap<String, Map<Integer, String>>();
                }
            }
            catch (Throwable throwable) {
                var24_28 = null;
                if (indexMap == null) {
                    indexMap = new LinkedHashMap<String, Map<Integer, String>>();
                }
                throw throwable;
            }
            Set<String> indexKeySet = indexMap.keySet();
            for (String indexName : indexKeySet) {
                Map<Integer, String> indexElementMap = indexMap.get(indexName);
                if (indexElementMap.isEmpty()) {
                    msg = "The index has no elements: " + indexName + " : " + indexMap;
                    throw new IllegalStateException(msg);
                }
                uniqueKeyElement = this._doc.createElement("index");
                uniqueKeyElement.setAttribute("name", indexName);
                uniqueElementKeySet = indexElementMap.keySet();
                for (Integer ordinalPosition : uniqueElementKeySet) {
                    columnName = indexElementMap.get(ordinalPosition);
                    uniqueColumnElement = this._doc.createElement("index-column");
                    uniqueColumnElement.setAttribute("name", columnName);
                    uniqueColumnElement.setAttribute("position", ordinalPosition.toString());
                    uniqueKeyElement.appendChild(uniqueColumnElement);
                }
                tableElement.appendChild(uniqueKeyElement);
            }
            this._databaseNode.appendChild(tableElement);
        }
        _log.info((Object)"$ = = = = = = = = = =/");
        boolean exists = this.setupAddtionalTableIfNeeds();
        if (tableList.isEmpty() && !exists) {
            this.throwTableNotFoundException();
        }
        this._doc.appendChild((Node)this._databaseNode);
    }

    protected void throwTableNotFoundException() {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "A table was NOT FOUND in the schema!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm the database connection settings." + this.ln();
        msg = msg + "If you've not created the schema yet, please create it." + this.ln();
        msg = msg + "You can create easily by using replace-schema." + this.ln();
        msg = msg + "Set up ./playsql/replace-schema.sql and execute ReplaceSchema task." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Connection Settings]" + this.ln();
        msg = msg + " driver = " + this._driver + this.ln();
        msg = msg + " url    = " + this._url + this.ln();
        msg = msg + " schema = " + this._schema + this.ln();
        msg = msg + " user   = " + this._userId + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfTableNotFoundException(msg);
    }

    protected void setupColumnType(DfColumnMetaInfo columnMetaInfo, Element columnElement) {
        columnElement.setAttribute("type", this.getColumnJdbcType(columnMetaInfo));
    }

    protected String getColumnJdbcType(DfColumnMetaInfo columnMetaInfo) {
        return this._columnHandler.getColumnJdbcType(columnMetaInfo);
    }

    protected void setupColumnJavaType(DfColumnMetaInfo columnMetaInfo, Element columnElement) {
        String jdbcType = this.getColumnJdbcType(columnMetaInfo);
        int columnSize = columnMetaInfo.getColumnSize();
        int decimalDigits = columnMetaInfo.getDecimalDigits();
        String javaNative = TypeMap.findJavaNativeByJdbcType(jdbcType, columnSize > 0 ? Integer.valueOf(columnSize) : null, decimalDigits > 0 ? Integer.valueOf(decimalDigits) : null);
        columnElement.setAttribute("javaType", javaNative);
    }

    protected void setupColumnDbType(DfColumnMetaInfo columnMetaInfo, Element columnElement) {
        columnElement.setAttribute("dbType", columnMetaInfo.getDbTypeName());
    }

    protected void setupColumnSize(DfColumnMetaInfo columnMetaInfo, Element columnElement) {
        int columnSize = columnMetaInfo.getColumnSize();
        int decimalDigits = columnMetaInfo.getDecimalDigits();
        if (DfColumnHandler.isColumnSizeValid(columnSize)) {
            if (DfColumnHandler.isDecimalDigitsValid(decimalDigits)) {
                columnElement.setAttribute("size", columnSize + ", " + decimalDigits);
            } else {
                columnElement.setAttribute("size", String.valueOf(columnSize));
            }
        }
    }

    public List<DfTableMetaInfo> getTableNames(DatabaseMetaData dbMeta) throws SQLException {
        List<DfTableMetaInfo> tableList = this._tableHandler.getTableList(dbMeta, this._schema);
        this.helpTableComments(tableList, this._url, this._schema);
        this.resolveAdditionalSchema(dbMeta, tableList);
        return tableList;
    }

    protected void resolveAdditionalSchema(DatabaseMetaData dbMeta, List<DfTableMetaInfo> tableList) throws SQLException {
        Map<String, DfAdditionalSchemaInfo> schemaMap = this.getDatabaseProperties().getAdditionalSchemaMap();
        Set<String> schemaSet = schemaMap.keySet();
        for (String additionalSchema : schemaSet) {
            List<DfTableMetaInfo> additionalTableList = this._tableHandler.getTableList(dbMeta, additionalSchema);
            for (DfTableMetaInfo metaInfo : additionalTableList) {
                String metaDataSchema = metaInfo.getTableSchema();
                if (metaDataSchema != null && metaDataSchema.trim().length() != 0) continue;
                metaInfo.setTableSchema(additionalSchema);
            }
            this.helpTableComments(additionalTableList, null, additionalSchema);
            tableList.addAll(additionalTableList);
        }
    }

    protected void helpTableComments(List<DfTableMetaInfo> tableList, String url, String schema) {
        DfDbCommentExtractor extractor = this.createDbCommentExtractor(url, schema);
        if (extractor != null) {
            HashSet<String> tableSet = new HashSet<String>();
            for (DfTableMetaInfo table : tableList) {
                tableSet.add(table.getTableName());
            }
            try {
                Map<String, DfDbCommentExtractor.UserTabComments> tableCommentMap = extractor.extractTableComment(tableSet);
                for (DfTableMetaInfo table : tableList) {
                    table.acceptTableComment(tableCommentMap);
                }
            }
            catch (RuntimeException ignored) {
                _log.info((Object)("Failed to extract table comments: extractor=" + extractor), (Throwable)ignored);
            }
            try {
                if (this._columnCommentAllMap == null) {
                    this._columnCommentAllMap = extractor.extractColumnComment(tableSet);
                } else {
                    this._columnCommentAllMap.putAll(extractor.extractColumnComment(tableSet));
                }
            }
            catch (RuntimeException ignored) {
                _log.info((Object)("Failed to extract column comments: extractor=" + extractor), (Throwable)ignored);
            }
        }
    }

    protected void processSynonymTable(List<DfTableMetaInfo> tableList) {
        this.judgeOutOfTargetSynonym(tableList);
        this.helpSynonymTableComments(tableList);
    }

    protected void judgeOutOfTargetSynonym(List<DfTableMetaInfo> tableList) {
        for (DfTableMetaInfo table : tableList) {
            DfSynonymMetaInfo synonym;
            if (!this.canHandleSynonym(table) || (synonym = this.getSynonymMetaInfo(table)) == null || synonym.isSelectable()) continue;
            table.setOutOfGenerateTarget(true);
        }
    }

    protected void helpSynonymTableComments(List<DfTableMetaInfo> tableList) {
        for (DfTableMetaInfo table : tableList) {
            DfSynonymMetaInfo synonym;
            if (!this.canHandleSynonym(table) || table.hasTableComment() || (synonym = this.getSynonymMetaInfo(table)) == null || !synonym.hasTableComment()) continue;
            table.setTableComment(synonym.getTableComment());
        }
    }

    public List<DfColumnMetaInfo> getColumns(DatabaseMetaData dbMeta, DfTableMetaInfo table) throws SQLException {
        DfSynonymMetaInfo synonym;
        String schema = this.getHandlerUseSchema(table);
        List<DfColumnMetaInfo> columnList = this._columnHandler.getColumnList(dbMeta, schema, table);
        if (this.canHandleSynonym(table) && columnList.isEmpty() && (synonym = this.getSynonymMetaInfo(table)) != null && synonym.isDBLink()) {
            columnList = synonym.getColumnMetaInfoList4DBLink();
        }
        this.helpColumnComments(table, columnList);
        return columnList;
    }

    protected void helpColumnComments(DfTableMetaInfo table, List<DfColumnMetaInfo> columnList) {
        if (this._columnCommentAllMap != null) {
            String tableName = table.getTableName();
            Map<String, DfDbCommentExtractor.UserColComments> columnCommentMap = this._columnCommentAllMap.get(tableName);
            for (DfColumnMetaInfo column : columnList) {
                column.acceptColumnComment(columnCommentMap);
            }
        }
        this.helpSynonymColumnComments(table, columnList);
    }

    protected void helpSynonymColumnComments(DfTableMetaInfo table, List<DfColumnMetaInfo> columnList) {
        for (DfColumnMetaInfo column : columnList) {
            DfDbCommentExtractor.UserColComments userColComments;
            DfSynonymMetaInfo synonym;
            if (!this.canHandleSynonym(table) || column.hasColumnComment() || (synonym = this.getSynonymMetaInfo(table)) == null || !synonym.hasColumnCommentMap() || (userColComments = synonym.getColumnCommentMap().get(column.getColumnName())) == null || !userColComments.hasComments()) continue;
            column.setColumnComment(userColComments.getComments());
        }
    }

    protected DfPrimaryKeyMetaInfo getPrimaryColumnMetaInfo(DatabaseMetaData dbMeta, DfTableMetaInfo table) throws SQLException {
        String schema = this.getHandlerUseSchema(table);
        DfPrimaryKeyMetaInfo pkInfo = this._uniqueKeyHandler.getPrimaryKey(dbMeta, schema, table);
        List<String> pkList = pkInfo.getPrimaryKeyList();
        if (!this.canHandleSynonym(table) || !pkList.isEmpty()) {
            return pkInfo;
        }
        DfSynonymMetaInfo synonym = this.getSynonymMetaInfo(table);
        if (synonym != null) {
            return synonym.getPrimaryKeyMetaInfo();
        }
        return pkInfo;
    }

    protected Map<String, Map<Integer, String>> getUniqueKeyMap(DatabaseMetaData dbMeta, DfTableMetaInfo table) throws SQLException {
        String schema = this.getHandlerUseSchema(table);
        Map<String, Map<Integer, String>> uniqueKeyMap = this._uniqueKeyHandler.getUniqueKeyMap(dbMeta, schema, table);
        if (!this.canHandleSynonym(table) || !uniqueKeyMap.isEmpty()) {
            return uniqueKeyMap;
        }
        DfSynonymMetaInfo synonym = this.getSynonymMetaInfo(table);
        return synonym != null ? synonym.getUniqueKeyMap() : uniqueKeyMap;
    }

    protected boolean isAutoIncrementColumn(Connection conn, DfTableMetaInfo tableMetaInfo, String primaryKeyColumnName) throws SQLException {
        DfSynonymMetaInfo synonym;
        if (this._autoIncrementHandler.isAutoIncrementColumn(conn, tableMetaInfo, primaryKeyColumnName)) {
            return true;
        }
        if (this.canHandleSynonym(tableMetaInfo) && (synonym = this.getSynonymMetaInfo(tableMetaInfo)) != null && synonym.isAutoIncrement()) {
            return true;
        }
        if (this._identityMap == null) {
            return false;
        }
        String columnName = this._identityMap.get(tableMetaInfo.getTableName());
        return primaryKeyColumnName.equals(columnName);
    }

    protected void initializeIdentityMapIfNeeds() {
        DfIdentityExtractor extractor = this.createIdentityExtractor();
        if (extractor == null) {
            return;
        }
        try {
            _log.info((Object)"...Initializing identity map");
            this._identityMap = extractor.extractIdentityMap();
            _log.info((Object)("  -> size=" + this._identityMap.size()));
        }
        catch (Exception ignored) {
            _log.info((Object)"DfIdentityExtractor.extractIdentityMap() threw the exception!", (Throwable)ignored);
        }
    }

    protected Map<String, DfForeignKeyMetaInfo> getForeignKeys(DatabaseMetaData dbMeta, DfTableMetaInfo table) throws SQLException {
        String schema = this.getHandlerUseSchema(table);
        Map<String, DfForeignKeyMetaInfo> foreignKeyMetaInfo = this._foreignKeyHandler.getForeignKeyMetaInfo(dbMeta, schema, table);
        if (!this.canHandleSynonym(table) || !foreignKeyMetaInfo.isEmpty()) {
            return foreignKeyMetaInfo;
        }
        DfSynonymMetaInfo synonym = this.getSynonymMetaInfo(table);
        return synonym != null ? synonym.getForeignKeyMetaInfoMap() : foreignKeyMetaInfo;
    }

    protected String getHandlerUseSchema(DfTableMetaInfo tableMetaInfo) {
        return this.isAdditionalSchemaTable(tableMetaInfo) ? tableMetaInfo.getTableSchema() : this._schema;
    }

    protected boolean isAdditionalSchemaTable(DfTableMetaInfo tableMetaInfo) {
        String schema = tableMetaInfo.getTableSchema();
        if (schema == null || schema.trim().length() == 0) {
            return false;
        }
        return this.getDatabaseProperties().isAdditionalSchema(schema);
    }

    protected Map<String, Map<Integer, String>> getIndexMap(DatabaseMetaData dbMeta, DfTableMetaInfo table, Map<String, Map<Integer, String>> uniqueKeyMap) throws SQLException {
        String schema = this.getHandlerUseSchema(table);
        Map<String, Map<Integer, String>> indexMap = this._indexHandler.getIndexMap(dbMeta, schema, table, uniqueKeyMap);
        if (!this.canHandleSynonym(table) || !indexMap.isEmpty()) {
            return indexMap;
        }
        DfSynonymMetaInfo synonym = this.getSynonymMetaInfo(table);
        return synonym != null ? synonym.getIndexMap() : indexMap;
    }

    protected void loadSupplementarySynonymInfoIfNeeds() {
        DfSynonymExtractor extractor = this.createSynonymExtractor();
        if (extractor == null) {
            return;
        }
        try {
            _log.info((Object)"...Loading supplementary synonym informations");
            this._supplementarySynonymInfoMap = extractor.extractSynonymMap();
            StringBuilder sb = new StringBuilder();
            sb.append("Finished loading synonyms:").append(this.ln()).append("[Supplementary Synonyms]");
            Set<Map.Entry<String, DfSynonymMetaInfo>> entrySet = this._supplementarySynonymInfoMap.entrySet();
            for (Map.Entry<String, DfSynonymMetaInfo> entry : entrySet) {
                sb.append(this.ln()).append(" ").append(entry.getValue().toString());
            }
            _log.info((Object)sb.toString());
        }
        catch (RuntimeException ignored) {
            _log.info((Object)"DfSynonymExtractor.extractSynonymMap() threw the exception!", (Throwable)ignored);
        }
    }

    protected boolean canHandleSynonym(DfTableMetaInfo table) {
        return this._supplementarySynonymInfoMap != null && table.canHandleSynonym();
    }

    protected DfSynonymMetaInfo getSynonymMetaInfo(DfTableMetaInfo table) {
        if (!this.canHandleSynonym(table)) {
            String msg = "The table meta information should be for synonym: " + table;
            throw new IllegalStateException(msg);
        }
        String key = table.buildTableNameWithSchema();
        return this._supplementarySynonymInfoMap.get(key);
    }

    protected boolean setupAddtionalTableIfNeeds() {
        boolean exists = false;
        String tableType = "TABLE";
        DfAdditionalTableProperties prop = this.getProperties().getAdditionalTableProperties();
        Map<String, Object> tableMap = prop.getAdditionalTableMap();
        Set<String> tableNameKey = tableMap.keySet();
        for (String tableName : tableNameKey) {
            _log.info((Object)("...Processing additional table: " + tableName + "(" + "TABLE" + ")"));
            Element tableElement = this._doc.createElement("table");
            tableElement.setAttribute("name", tableName);
            tableElement.setAttribute("type", "TABLE");
            Map<String, Map<String, String>> columnMap = prop.findColumnMap(tableName);
            String tableComment = prop.findTableComment(tableName);
            if (tableComment != null && tableComment.trim().length() > 0) {
                tableElement.setAttribute("comment", tableComment);
            }
            Set<String> columnNameKey = columnMap.keySet();
            for (String columnName : columnNameKey) {
                Element columnElement = this._doc.createElement("column");
                columnElement.setAttribute("name", columnName);
                String columnType = prop.findColumnType(tableName, columnName);
                String columnDbType = prop.findColumnDbType(tableName, columnName);
                String columnSize = prop.findColumnSize(tableName, columnName);
                boolean required = prop.isColumnRequired(tableName, columnName);
                boolean primaryKey = prop.isColumnPrimaryKey(tableName, columnName);
                String pkName = prop.findColumnPKName(tableName, columnName);
                boolean autoIncrement = prop.isColumnAutoIncrement(tableName, columnName);
                String columnDefault = prop.findColumnDefault(tableName, columnName);
                String columnComment = prop.findColumnComment(tableName, columnName);
                this.setupAdditionalTableColumnAttribute(columnElement, "type", columnType);
                this.setupAdditionalTableColumnAttribute(columnElement, "dbType", columnDbType);
                this.setupAdditionalTableColumnAttribute(columnElement, "size", columnSize);
                this.setupAdditionalTableColumnAttribute(columnElement, "required", String.valueOf(required));
                this.setupAdditionalTableColumnAttribute(columnElement, "primaryKey", String.valueOf(primaryKey));
                this.setupAdditionalTableColumnAttribute(columnElement, "pkName", pkName);
                this.setupAdditionalTableColumnAttribute(columnElement, "autoIncrement", String.valueOf(autoIncrement));
                this.setupAdditionalTableColumnAttribute(columnElement, "default", columnDefault);
                this.setupAdditionalTableColumnAttribute(columnElement, "comment", columnComment);
                tableElement.appendChild(columnElement);
            }
            exists = true;
            this._databaseNode.appendChild(tableElement);
        }
        return exists;
    }

    protected void setupAdditionalTableColumnAttribute(Element columnElement, String key, String value) {
        if (value != null && value.trim().length() > 0) {
            columnElement.setAttribute(key, value);
        }
    }

    protected DfDbCommentExtractor createDbCommentExtractor(String url, String schema) {
        DfDbCommentExtractorFactory factory = this.createDbCommentExtractorFactory(url, schema);
        return factory.createDbCommentExtractor();
    }

    protected DfDbCommentExtractorFactory createDbCommentExtractorFactory(String url, String schema) {
        return new DfDbCommentExtractorFactory(this.getBasicProperties(), this.getDataSource(), url, schema);
    }

    protected DfIdentityExtractor createIdentityExtractor() {
        DfIdentityExtractorFactory factory = this.createIdentityExtractorFactory();
        return factory.createIdentityExtractor();
    }

    protected DfIdentityExtractorFactory createIdentityExtractorFactory() {
        return new DfIdentityExtractorFactory(this.getBasicProperties(), this.getDataSource());
    }

    protected DfSynonymExtractor createSynonymExtractor() {
        DfSynonymExtractorFactory factory = this.createSynonymExtractorFactory();
        return factory.createSynonymExtractor();
    }

    protected DfSynonymExtractorFactory createSynonymExtractorFactory() {
        return new DfSynonymExtractorFactory(this.getDataSource(), this.getBasicProperties(), this.getDatabaseProperties(), this._refTableCheckSet);
    }
}

