/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.scmconn;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileGetter;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfo;
import org.seasar.dbflute.helper.language.DfLanguageDependencyInfoJava;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfCurrentSchemaConnector {
    private static final Log _log = LogFactory.getLog(DfCurrentSchemaConnector.class);
    protected String _schema;
    protected DfBasicProperties _basicProperties;

    public DfCurrentSchemaConnector(String schema, DfBasicProperties basicProperties) {
        this._schema = schema;
        this._basicProperties = basicProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connectSchema(DataSource dataSource) throws SQLException {
        Connection conn;
        block5: {
            conn = null;
            try {
                conn = dataSource.getConnection();
                Object var4_3 = null;
                if (conn == null) break block5;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (conn == null) throw throwable;
                try {
                    conn.close();
                    throw throwable;
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignored) {}
            conn.close();
        }
        this.connectSchema(conn);
    }

    public void connectSchema(Connection conn) throws SQLException {
        if (this._basicProperties.isDatabaseDB2() && this._schema != null) {
            String sql = "SET CURRENT SCHEMA = " + this._schema.trim();
            this.executeCurrentSchemaSql(conn, sql);
        } else if (this._basicProperties.isDatabaseOracle() && this._schema != null) {
            String sql = "ALTER SESSION SET CURRENT_SCHEMA = " + this._schema.trim();
            this.executeCurrentSchemaSql(conn, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeCurrentSchemaSql(Connection conn, String sql) throws SQLException {
        Statement st = conn.createStatement();
        _log.info((Object)("...Connecting the schema: " + this._schema + this.ln() + sql));
        st.execute(sql);
        Object var7_4 = null;
        if (st == null) return;
        try {
            st.close();
            return;
        }
        catch (SQLException ignored) {}
        return;
        {
            catch (SQLException continued) {
                String msg = "Failed to execute the SQL:" + this.ln() + sql + this.ln() + continued.getMessage();
                _log.warn((Object)msg);
                Object var7_5 = null;
                if (st == null) return;
                try {
                    st.close();
                    return;
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (st == null) throw throwable;
            try {
                st.close();
                throw throwable;
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected List<File> collectSqlFile(String sqlDirectory) {
        return this.createSqlFileGetter().getSqlFileList(sqlDirectory);
    }

    protected DfSqlFileGetter createSqlFileGetter() {
        final DfLanguageDependencyInfo dependencyInfo = this._basicProperties.getLanguageDependencyInfo();
        return new DfSqlFileGetter(){

            protected boolean acceptSqlFile(File file) {
                if (!dependencyInfo.isCompileTargetFile(file)) {
                    return false;
                }
                return super.acceptSqlFile(file);
            }
        };
    }

    protected boolean containsSrcMainJava(String sqlDirectory) {
        return DfLanguageDependencyInfoJava.containsSrcMainJava(sqlDirectory);
    }

    protected String replaceSrcMainJavaToSrcMainResources(String sqlDirectory) {
        return DfLanguageDependencyInfoJava.replaceSrcMainJavaToSrcMainResources(sqlDirectory);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

