/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.metadata.info;

import java.util.List;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfSynonymMetaInfo;

public class DfProcedureSynonymMetaInfo {
    protected DfSynonymMetaInfo _synonymMetaInfo;
    protected DfProcedureMetaInfo _procedureMetaInfo;

    public DfProcedureMetaInfo createMergedProcedure(String mainSchemaName) {
        if (this._procedureMetaInfo == null) {
            String msg = "The procedureMetaInfo should not be null!";
            throw new IllegalStateException(msg);
        }
        if (this._synonymMetaInfo == null) {
            String msg = "The synonymMetaInfo should not be null!";
            throw new IllegalStateException(msg);
        }
        DfProcedureMetaInfo metaInfo = new DfProcedureMetaInfo();
        String synonymOwner = this._synonymMetaInfo.getSynonymOwner();
        String synonymName = this._synonymMetaInfo.getSynonymName();
        String synonymFullName = synonymOwner + "." + synonymName;
        String synonymSqlName = mainSchemaName != null && mainSchemaName.equalsIgnoreCase(synonymOwner) ? synonymName : synonymOwner + "." + synonymName;
        String synonymUniqueName = synonymName;
        metaInfo.setProcedureCatalog(null);
        metaInfo.setProcedureSchema(synonymOwner);
        metaInfo.setProcedureName(synonymName);
        metaInfo.setProcedureFullName(synonymFullName);
        metaInfo.setProcedureSqlName(synonymSqlName);
        metaInfo.setProcedureUniqueName(synonymUniqueName);
        metaInfo.setProcedureSynonym(this._procedureMetaInfo.isProcedureSynonym());
        metaInfo.setProcedureType(this._procedureMetaInfo.getProcedureType());
        metaInfo.setProcedureComment(this._procedureMetaInfo.getProcedureComment());
        List<DfProcedureColumnMetaInfo> columnMetaInfoList = this._procedureMetaInfo.getProcedureColumnMetaInfoList();
        for (DfProcedureColumnMetaInfo columnMetaInfo : columnMetaInfoList) {
            metaInfo.addProcedureColumnMetaInfo(columnMetaInfo);
        }
        return metaInfo;
    }

    public DfSynonymMetaInfo getSynonymMetaInfo() {
        return this._synonymMetaInfo;
    }

    public void setSynonymMetaInfo(DfSynonymMetaInfo synonymMetaInfo) {
        this._synonymMetaInfo = synonymMetaInfo;
    }

    public DfProcedureMetaInfo getProcedureMetaInfo() {
        return this._procedureMetaInfo;
    }

    public void setProcedureMetaInfo(DfProcedureMetaInfo procedureMetaInfo) {
        this._procedureMetaInfo = procedureMetaInfo;
    }
}

