/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.StringSet;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.mapping.DfJdbcTypeMapper;
import org.seasar.dbflute.properties.DfTypeMappingProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfColumnHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfColumnHandler.class);
    protected DfJdbcTypeMapper _jdbcTypeMapper;

    public Map<String, DfColumnMetaInfo> getColumnMetaInfo(DatabaseMetaData metaData, String schemaName, String tableName) {
        List<DfColumnMetaInfo> columns = this.getColumnList(metaData, schemaName, tableName);
        LinkedHashMap<String, DfColumnMetaInfo> map = new LinkedHashMap<String, DfColumnMetaInfo>();
        for (DfColumnMetaInfo metaInfo : columns) {
            map.put(metaInfo.getColumnName(), metaInfo);
        }
        return map;
    }

    public List<DfColumnMetaInfo> getColumnList(DatabaseMetaData metaData, String schemaName, DfTableMetaInfo tableMetaInfo) {
        schemaName = this.filterSchemaName(schemaName);
        schemaName = tableMetaInfo.selectMetaExtractingSchemaName(schemaName);
        String tableName = tableMetaInfo.getTableName();
        return this.getColumnList(metaData, schemaName, tableName);
    }

    public List<DfColumnMetaInfo> getColumnList(DatabaseMetaData metaData, String schemaName, String tableName) {
        schemaName = this.filterSchemaName(schemaName);
        ArrayList<DfColumnMetaInfo> columns = new ArrayList<DfColumnMetaInfo>();
        ResultSet columnResultSet = null;
        ResultSet lowerSpare = null;
        ResultSet upperSpare = null;
        try {
            String realSchemaName = schemaName;
            columnResultSet = metaData.getColumns(null, realSchemaName, tableName, null);
            this.setupColumnMetaInfo(columns, columnResultSet, schemaName, tableName);
            if (columns.isEmpty()) {
                lowerSpare = metaData.getColumns(null, realSchemaName, tableName.toLowerCase(), null);
                this.setupColumnMetaInfo(columns, lowerSpare, schemaName, tableName);
            }
            if (columns.isEmpty()) {
                upperSpare = metaData.getColumns(null, realSchemaName, tableName.toUpperCase(), null);
                this.setupColumnMetaInfo(columns, upperSpare, schemaName, tableName);
            }
        }
        catch (SQLException e) {
            String msg = "SQLException occured: schemaName=" + schemaName + " tableName=" + tableName;
            throw new IllegalStateException(msg);
        }
        finally {
            if (columnResultSet != null) {
                try {
                    columnResultSet.close();
                }
                catch (SQLException ignored) {}
            }
            if (lowerSpare != null) {
                try {
                    lowerSpare.close();
                }
                catch (SQLException ignored) {}
            }
            if (upperSpare != null) {
                try {
                    upperSpare.close();
                }
                catch (SQLException ignored) {}
            }
        }
        return columns;
    }

    protected void setupColumnMetaInfo(List<DfColumnMetaInfo> columns, ResultSet columnResultSet, String schemaName, String tableName) throws SQLException {
        StringSet columnNameSet = StringSet.createAsFlexible();
        StringSet duplicateTableNameSet = StringSet.createAsFlexible();
        StringSet duplicateColumnNameSet = StringSet.createAsFlexible();
        while (columnResultSet.next()) {
            String columnName = columnResultSet.getString(4);
            if (this.isColumnExcept(schemaName, tableName, columnName)) continue;
            if (columnNameSet.contains((Object)columnName)) {
                duplicateTableNameSet.add(columnResultSet.getString(3));
                duplicateColumnNameSet.add(columnName);
                continue;
            }
            columnNameSet.add(columnName);
            Integer jdbcTypeCode = Integer.valueOf(columnResultSet.getString(5));
            String dbTypeName = columnResultSet.getString(6);
            Integer columnSize = columnResultSet.getInt(7);
            Integer decimalDigits = columnResultSet.getInt(9);
            Integer nullType = columnResultSet.getInt(11);
            String columnComment = columnResultSet.getString(12);
            String defaultValue = columnResultSet.getString(13);
            DfColumnMetaInfo columnMetaInfo = new DfColumnMetaInfo();
            columnMetaInfo.setColumnName(columnName);
            columnMetaInfo.setJdbcDefValue(jdbcTypeCode);
            columnMetaInfo.setDbTypeName(dbTypeName);
            columnMetaInfo.setColumnSize(columnSize);
            columnMetaInfo.setDecimalDigits(decimalDigits);
            columnMetaInfo.setRequired(nullType == 0);
            columnMetaInfo.setColumnComment(columnComment);
            columnMetaInfo.setDefaultValue(defaultValue);
            columns.add(columnMetaInfo);
        }
        if (!duplicateColumnNameSet.isEmpty()) {
            String msg = "*Duplicate meta data was found:";
            msg = msg + "\n[" + tableName + "]";
            msg = msg + "\n  duplicate tables = " + duplicateTableNameSet;
            msg = msg + "\n  duplicate columns = " + duplicateColumnNameSet;
            _log.info((Object)msg);
        }
    }

    public String getColumnJdbcType(DfColumnMetaInfo columnMetaInfo) {
        return this.getColumnJdbcType(columnMetaInfo.getJdbcDefValue(), columnMetaInfo.getDbTypeName());
    }

    public String getColumnJdbcType(int jdbcDefValue, String dbTypeName) {
        return this.getJdbcTypeMapper().getColumnJdbcType(jdbcDefValue, dbTypeName);
    }

    protected DfJdbcTypeMapper getJdbcTypeMapper() {
        if (this._jdbcTypeMapper == null) {
            this._jdbcTypeMapper = this.newJdbcTypeMapper();
        }
        return this._jdbcTypeMapper;
    }

    protected DfJdbcTypeMapper newJdbcTypeMapper() {
        DfTypeMappingProperties typeMappingProperties = this.getProperties().getTypeMappingProperties();
        Map<String, String> nameToJdbcTypeMap = typeMappingProperties.getNameToJdbcTypeMap();
        DfJdbcTypeMapper mapper = new DfJdbcTypeMapper(nameToJdbcTypeMap, new DfJdbcTypeMapper.Resource(){

            public boolean isTargetLanguageJava() {
                return DfColumnHandler.this.getBasicProperties().isTargetLanguageJava();
            }

            public boolean isDatabaseOracle() {
                return DfColumnHandler.this.isOracle();
            }

            public boolean isDatabasePostgreSQL() {
                return DfColumnHandler.this.isPostgreSQL();
            }

            public String toString() {
                return "{" + this.isTargetLanguageJava() + ", " + this.isDatabaseOracle() + ", " + this.isDatabasePostgreSQL() + "}";
            }
        });
        return mapper;
    }

    public boolean isOracleStringClob(String dbTypeName) {
        return this.getJdbcTypeMapper().isOracle_Clob(dbTypeName);
    }

    public boolean isPostgreSQLBytesOid(String dbTypeName) {
        return this.getJdbcTypeMapper().isPostgreSQL_Oid(dbTypeName);
    }

    public boolean isUUID(String dbTypeName) {
        return this.getJdbcTypeMapper().isUUID(dbTypeName);
    }

    public static boolean isColumnSizeValid(Integer columnSize) {
        return columnSize != null && columnSize > 0;
    }

    public static boolean isDecimalDigitsValid(Integer decimalDigits) {
        return decimalDigits != null && decimalDigits > 0;
    }
}

