/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.schemadiff;

import java.util.List;
import java.util.Map;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfAbstractDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfDiffType;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfNestDiff;
import org.seasar.dbflute.logic.jdbc.schemadiff.DfNextPreviousDiff;
import org.seasar.dbflute.util.DfCollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfColumnDiff
extends DfAbstractDiff
implements DfNestDiff {
    protected final String _columnName;
    protected final DfDiffType _diffType;
    protected DfNextPreviousDiff _dbTypeDiff;
    protected DfNextPreviousDiff _columnSizeDiff;
    protected DfNextPreviousDiff _defaultValueDiff;
    protected DfNextPreviousDiff _notNullDiff;
    protected DfNextPreviousDiff _autoIncrementDiff;
    protected List<DfAbstractDiff.NextPreviousHandler> _nextPreviousItemList = DfCollectionUtil.newArrayList();

    protected DfColumnDiff(String columnName, DfDiffType diffType) {
        this._nextPreviousItemList.add(new DfAbstractDiff.NextPreviousHandler(){

            @Override
            public String titleName() {
                return "Type";
            }

            @Override
            public String propertyName() {
                return "dbTypeDiff";
            }

            @Override
            public DfNextPreviousDiff provide() {
                return DfColumnDiff.this._dbTypeDiff;
            }

            @Override
            public void restore(Map<String, Object> columnDiffMap) {
                DfColumnDiff.this._dbTypeDiff = DfColumnDiff.this.restoreNextPreviousDiff(columnDiffMap, this.propertyName());
            }
        });
        this._nextPreviousItemList.add(new DfAbstractDiff.NextPreviousHandler(){

            @Override
            public String titleName() {
                return "Size";
            }

            @Override
            public String propertyName() {
                return "columnSizeDiff";
            }

            @Override
            public DfNextPreviousDiff provide() {
                return DfColumnDiff.this._columnSizeDiff;
            }

            @Override
            public void restore(Map<String, Object> columnDiffMap) {
                DfColumnDiff.this._columnSizeDiff = DfColumnDiff.this.restoreNextPreviousDiff(columnDiffMap, this.propertyName());
            }
        });
        this._nextPreviousItemList.add(new DfAbstractDiff.NextPreviousHandler(){

            @Override
            public String titleName() {
                return "Default";
            }

            @Override
            public DfNextPreviousDiff provide() {
                return DfColumnDiff.this._defaultValueDiff;
            }

            @Override
            public String propertyName() {
                return "defaultValueDiff";
            }

            @Override
            public void restore(Map<String, Object> columnDiffMap) {
                DfColumnDiff.this._defaultValueDiff = DfColumnDiff.this.restoreNextPreviousDiff(columnDiffMap, this.propertyName());
            }
        });
        this._nextPreviousItemList.add(new DfAbstractDiff.NextPreviousHandler(){

            @Override
            public String titleName() {
                return "Not Null";
            }

            @Override
            public String propertyName() {
                return "notNullDiff";
            }

            @Override
            public DfNextPreviousDiff provide() {
                return DfColumnDiff.this._notNullDiff;
            }

            @Override
            public void restore(Map<String, Object> columnDiffMap) {
                DfColumnDiff.this._notNullDiff = DfColumnDiff.this.restoreNextPreviousDiff(columnDiffMap, this.propertyName());
            }
        });
        this._nextPreviousItemList.add(new DfAbstractDiff.NextPreviousHandler(){

            @Override
            public String titleName() {
                return "Identity";
            }

            @Override
            public String propertyName() {
                return "autoIncrementDiff";
            }

            @Override
            public DfNextPreviousDiff provide() {
                return DfColumnDiff.this._autoIncrementDiff;
            }

            @Override
            public void restore(Map<String, Object> columnDiffMap) {
                DfColumnDiff.this._autoIncrementDiff = DfColumnDiff.this.restoreNextPreviousDiff(columnDiffMap, this.propertyName());
            }
        });
        this._columnName = columnName;
        this._diffType = diffType;
    }

    protected DfColumnDiff(Map<String, Object> columnDiffMap) {
        this._nextPreviousItemList.add(new /* invalid duplicate definition of identical inner class */);
        this._nextPreviousItemList.add(new /* invalid duplicate definition of identical inner class */);
        this._nextPreviousItemList.add(new /* invalid duplicate definition of identical inner class */);
        this._nextPreviousItemList.add(new /* invalid duplicate definition of identical inner class */);
        this._nextPreviousItemList.add(new /* invalid duplicate definition of identical inner class */);
        this._columnName = (String)columnDiffMap.get("columnName");
        this.assertColumnNameExists(this._columnName, columnDiffMap);
        this._diffType = DfDiffType.valueOf((String)columnDiffMap.get("diffType"));
        this.acceptDiffMap(columnDiffMap);
    }

    protected void assertColumnNameExists(String columnName, Map<String, Object> columnDiffMap) {
        if (columnName == null) {
            String msg = "The columnName is required in column diff-map:";
            msg = msg + " columnDiffMap=" + columnDiffMap;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertDiffTypeExists(String columnName, Map<String, Object> columnDiffMap, DfDiffType diffType) {
        if (diffType == null) {
            String msg = "The diffType is required in column diff-map:";
            msg = msg + " column=" + columnName + " columnDiffMap=" + columnDiffMap;
            throw new IllegalStateException(msg);
        }
    }

    public static DfColumnDiff createAdded(String columnName) {
        return new DfColumnDiff(columnName, DfDiffType.ADD);
    }

    public static DfColumnDiff createChanged(String columnName) {
        return new DfColumnDiff(columnName, DfDiffType.CHANGE);
    }

    public static DfColumnDiff createDeleted(String columnName) {
        return new DfColumnDiff(columnName, DfDiffType.DELETE);
    }

    public static DfColumnDiff createFromDiffMap(Map<String, Object> columnDiffMap) {
        return new DfColumnDiff(columnDiffMap);
    }

    @Override
    public Map<String, Object> createDiffMap() {
        Map map = DfCollectionUtil.newLinkedHashMap();
        map.put("columnName", this._columnName);
        map.put("diffType", this._diffType.toString());
        List<DfAbstractDiff.NextPreviousHandler> nextPreviousItemList = this._nextPreviousItemList;
        for (DfAbstractDiff.NextPreviousHandler provider : nextPreviousItemList) {
            DfNextPreviousDiff nextPreviousDiff = provider.provide();
            if (nextPreviousDiff == null) continue;
            map.put(provider.propertyName(), nextPreviousDiff.createNextPreviousDiffMap());
        }
        return map;
    }

    @Override
    public void acceptDiffMap(Map<String, Object> diffMap) {
        List<DfAbstractDiff.NextPreviousHandler> nextPreviousItemList = this._nextPreviousItemList;
        for (DfAbstractDiff.NextPreviousHandler provider : nextPreviousItemList) {
            provider.restore(diffMap);
        }
    }

    @Override
    public boolean hasDiff() {
        if (!DfDiffType.CHANGE.equals((Object)this._diffType)) {
            return true;
        }
        List<DfAbstractDiff.NextPreviousHandler> nextPreviousItemList = this._nextPreviousItemList;
        for (DfAbstractDiff.NextPreviousHandler provider : nextPreviousItemList) {
            if (provider.provide() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getKeyName() {
        return this.getColumnName();
    }

    public String getColumnName() {
        return this._columnName;
    }

    @Override
    public DfDiffType getDiffType() {
        return this._diffType;
    }

    public boolean isAdded() {
        return DfDiffType.ADD.equals((Object)this._diffType);
    }

    public boolean isChanged() {
        return DfDiffType.CHANGE.equals((Object)this._diffType);
    }

    public boolean isDeleted() {
        return DfDiffType.DELETE.equals((Object)this._diffType);
    }

    @Override
    public List<DfAbstractDiff.NextPreviousHandler> getNextPreviousValidList() {
        List<DfAbstractDiff.NextPreviousHandler> previousItemList = this._nextPreviousItemList;
        List validHandlerList = DfCollectionUtil.newArrayList();
        for (DfAbstractDiff.NextPreviousHandler handler : previousItemList) {
            DfNextPreviousDiff nextPreviousDiff = handler.provide();
            if (nextPreviousDiff == null || !nextPreviousDiff.hasDiff()) continue;
            validHandlerList.add(handler);
        }
        return validHandlerList;
    }

    public boolean hasDbTypeDiff() {
        return this._dbTypeDiff != null;
    }

    public DfNextPreviousDiff getDbTypeDiff() {
        return this._dbTypeDiff;
    }

    public void setDbTypeDiff(DfNextPreviousDiff dbTypeDiff) {
        this._dbTypeDiff = dbTypeDiff;
    }

    public boolean hasColumnSizeDiff() {
        return this._columnSizeDiff != null;
    }

    public DfNextPreviousDiff getColumnSizeDiff() {
        return this._columnSizeDiff;
    }

    public void setColumnSizeDiff(DfNextPreviousDiff columnSizeDiff) {
        this._columnSizeDiff = columnSizeDiff;
    }

    public boolean hasDefaultValueDiff() {
        return this._defaultValueDiff != null;
    }

    public DfNextPreviousDiff getDefaultValueDiff() {
        return this._defaultValueDiff;
    }

    public void setDefaultValueDiff(DfNextPreviousDiff defaultValueDiff) {
        this._defaultValueDiff = defaultValueDiff;
    }

    public boolean hasNotNullDiff() {
        return this._notNullDiff != null;
    }

    public DfNextPreviousDiff getNotNullDiff() {
        return this._notNullDiff;
    }

    public void setNotNullDiff(DfNextPreviousDiff notNullDiff) {
        this._notNullDiff = notNullDiff;
    }

    public boolean hasAutoIncrementDiff() {
        return this._autoIncrementDiff != null;
    }

    public DfNextPreviousDiff getAutoIncrementDiff() {
        return this._autoIncrementDiff;
    }

    public void setAutoIncrementDiff(DfNextPreviousDiff autoIncrementDiff) {
        this._autoIncrementDiff = autoIncrementDiff;
    }
}

