/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.transform;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTDResolver
implements EntityResolver {
    private static Log log = LogFactory.getLog(DTDResolver.class);
    public static final String WEB_SITE_DTD = "http://dbflute.sandbox.seasar.org/meta/database.dtd";
    private InputSource databaseDTD = null;

    public DTDResolver() throws SAXException {
        try {
            InputStream dtdStream = this.getClass().getResourceAsStream("database.dtd");
            if (dtdStream != null) {
                this.databaseDTD = new InputSource(dtdStream);
            } else {
                log.warn((Object)"Could not locate the database.dtd");
            }
        }
        catch (Exception ex) {
            throw new SAXException("Could not get stream for database.dtd", ex);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        if (this.databaseDTD != null && WEB_SITE_DTD.equals(systemId)) {
            log.info((Object)"...Resolving XML by database.dtd in same package");
            return this.databaseDTD;
        }
        if (systemId == null || "".equals(systemId.trim())) {
            log.info((Object)"...Resolving XML by 'http://dbflute.sandbox.seasar.org/meta/database.dtd'");
            return this.getInputSource(WEB_SITE_DTD);
        }
        log.info((Object)("...Resolving XML by '" + systemId + '\''));
        return this.getInputSource(systemId);
    }

    private InputSource getInputSource(String urlString) throws IOException {
        URL url = new URL(urlString);
        return new InputSource(url.openStream());
    }
}

