/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause.subquery;

import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

public class SubQueryClause {
    protected final SubQueryPath _subQueryPath;
    protected final String _selectClause;
    protected final SqlClause _subQuerySqlClause;
    protected final String _localAliasName;

    public SubQueryClause(SubQueryPath subQueryPath, String selectClause, SqlClause subQuerySqlClause, String localAliasName) {
        this._subQueryPath = subQueryPath;
        this._selectClause = selectClause;
        this._subQuerySqlClause = subQuerySqlClause;
        this._localAliasName = localAliasName;
    }

    public String buildPlainSubQueryFromWhereClause() {
        String fromWhereClause = this._subQuerySqlClause.getClauseFromWhereWithUnionTemplate();
        fromWhereClause = this.replaceString(fromWhereClause, ".conditionQuery.", "." + this._subQueryPath + ".");
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionSelectClauseMark(), this._selectClause);
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionWhereClauseMark(), "");
        fromWhereClause = this.replaceString(fromWhereClause, this.getUnionWhereFirstConditionMark(), "");
        return fromWhereClause;
    }

    public String buildCorrelationSubQueryFromWhereClause(ColumnRealName correlatedColumnRealName, ColumnSqlName relatedColumnSqlName) {
        String clause = this.xprepareCorrelationSubQueryFromWhereClause();
        String joinCondition = this._localAliasName + "." + relatedColumnSqlName + " = " + correlatedColumnRealName;
        clause = this.xreplaceCorrelationSubQueryFromWhereClause(clause, joinCondition);
        return clause;
    }

    public String buildCorrelationSubQueryFromWhereClause(ColumnRealName[] correlatedColumnRealNames, ColumnSqlName[] relatedColumnSqlNames) {
        String clause = this.xprepareCorrelationSubQueryFromWhereClause();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < relatedColumnSqlNames.length; ++i) {
            if (sb.length() > 0) {
                sb.append(this.ln()).append("   and ");
            }
            sb.append(this._localAliasName).append(".").append(relatedColumnSqlNames[i]);
            sb.append(" = ").append(correlatedColumnRealNames[i]);
        }
        String joinCondition = sb.toString();
        clause = this.xreplaceCorrelationSubQueryFromWhereClause(clause, joinCondition);
        return clause;
    }

    protected String xprepareCorrelationSubQueryFromWhereClause() {
        String clause = this._subQuerySqlClause.getClauseFromWhereWithWhereUnionTemplate();
        clause = this.replaceString(clause, ".conditionQuery.", "." + this._subQueryPath + ".");
        return clause;
    }

    protected String xreplaceCorrelationSubQueryFromWhereClause(String clause, String joinCondition) {
        String firstConditionAfter = this.ln() + "   and ";
        clause = this.replaceString(clause, this.getWhereClauseMark(), this.ln() + " where " + joinCondition);
        clause = this.replaceString(clause, this.getWhereFirstConditionMark(), joinCondition + firstConditionAfter);
        clause = this.replaceString(clause, this.getUnionSelectClauseMark(), this._selectClause);
        clause = this.replaceString(clause, this.getUnionWhereClauseMark(), this.ln() + " where " + joinCondition);
        clause = this.replaceString(clause, this.getUnionWhereFirstConditionMark(), joinCondition + firstConditionAfter);
        return clause;
    }

    protected String getBasePointAliasName() {
        return this._subQuerySqlClause.getBasePointAliasName();
    }

    protected String getWhereClauseMark() {
        return this._subQuerySqlClause.getWhereClauseMark();
    }

    protected String getWhereFirstConditionMark() {
        return this._subQuerySqlClause.getWhereFirstConditionMark();
    }

    protected String getUnionSelectClauseMark() {
        return this._subQuerySqlClause.getUnionSelectClauseMark();
    }

    protected String getUnionWhereClauseMark() {
        return this._subQuerySqlClause.getUnionWhereClauseMark();
    }

    protected String getUnionWhereFirstConditionMark() {
        return this._subQuerySqlClause.getUnionWhereFirstConditionMark();
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String initCap(String str) {
        return Srl.initCap(str);
    }

    protected String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

