/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.schemainitializer;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.helper.jdbc.facade.DfJdbcFacade;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureColumnMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfProcedureMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.schemainitializer.DfSchemaInitializerJdbc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfSchemaInitializerPostgreSQL
extends DfSchemaInitializerJdbc {
    private static final Log _log = LogFactory.getLog(DfSchemaInitializerPostgreSQL.class);

    @Override
    protected void dropSequence(Connection conn, List<DfTableMetaInfo> tableMetaInfoList) {
        String schema = this._schema != null && this._schema.trim().length() > 0 ? this._schema : "public";
        ArrayList<String> sequenceNameList = new ArrayList<String>();
        DfJdbcFacade jdbcFacade = new DfJdbcFacade(conn);
        String sequenceColumnName = "sequence_name";
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append("sequence_name").append(" from information_schema.sequences");
        sb.append(" where sequence_schema = '").append(schema).append("'");
        List<Map<String, String>> resultList = jdbcFacade.selectStringList(sb.toString(), Arrays.asList("sequence_name"));
        for (Map<String, String> recordMap : resultList) {
            sequenceNameList.add(recordMap.get("sequence_name"));
        }
        for (String sequenceName : sequenceNameList) {
            String dropSequenceSql = "drop sequence " + schema + "." + sequenceName;
            _log.info((Object)dropSequenceSql);
            jdbcFacade.execute(dropSequenceSql);
        }
    }

    @Override
    protected String buildProcedureSqlName(DfProcedureMetaInfo metaInfo) {
        String expression = "(" + this.buildProcedureArgExpression(metaInfo) + ")";
        return metaInfo.getProcedureSqlName() + expression;
    }

    protected String buildProcedureArgExpression(DfProcedureMetaInfo metaInfo) {
        List<DfProcedureColumnMetaInfo> metaInfoList = metaInfo.getProcedureColumnMetaInfoList();
        StringBuilder sb = new StringBuilder();
        for (DfProcedureColumnMetaInfo columnMetaInfo : metaInfoList) {
            String dbTypeName = columnMetaInfo.getDbTypeName();
            String columnName = columnMetaInfo.getColumnName();
            DfProcedureColumnMetaInfo.DfProcedureColumnType columnType = columnMetaInfo.getProcedureColumnType();
            if (DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnReturn.equals((Object)columnType)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(columnName);
            if (DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnIn.equals((Object)columnType)) {
                sb.append(" in ");
            } else if (DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnOut.equals((Object)columnType)) {
                sb.append(" out ");
            } else if (DfProcedureColumnMetaInfo.DfProcedureColumnType.procedureColumnInOut.equals((Object)columnType)) {
                sb.append(" inout ");
            } else {
                sb.append(" ");
            }
            sb.append(dbTypeName);
        }
        return sb.toString();
    }
}

