/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.seasar.ymir.extension.creator.Template;

public class FileTemplate
implements Template {
    private String path_;
    private File file_;
    private String encoding_;

    public FileTemplate(String path, File file, String encoding) {
        this.path_ = path;
        this.file_ = file;
        this.encoding_ = encoding;
    }

    public boolean exists() {
        return this.file_.exists() && !this.file_.isDirectory();
    }

    public InputStream getInputStream() throws IOException {
        if (this.file_.exists() && this.file_.isDirectory()) {
            throw new FileNotFoundException("Can't open inputStream: is directory: " + this.file_);
        }
        return new FileInputStream(this.file_);
    }

    public String getPath() {
        return this.path_;
    }

    public long lastModified() {
        return this.file_.lastModified();
    }

    public String getName() {
        return this.file_.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.file_.exists() && this.file_.isDirectory()) {
            throw new FileNotFoundException("Can't open outputStream: is directory: " + this.file_);
        }
        this.file_.getParentFile().mkdirs();
        return new FileOutputStream(this.file_);
    }

    public String getEncoding() {
        return this.encoding_;
    }

    public boolean isDirectory() {
        return this.file_.isDirectory();
    }

    public boolean mkdirs() {
        return this.file_.mkdirs();
    }
}

