/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties.initializer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Table;
import org.seasar.dbflute.properties.DfIncludeQueryProperties;
import org.seasar.dbflute.properties.assistant.DfTableFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfIncludeQueryInitializer {
    private static final Log _log = LogFactory.getLog(DfIncludeQueryInitializer.class);
    protected DfIncludeQueryProperties includeQueryProperties;
    protected DfTableFinder tableFinder;

    public void initializeIncludeQuery() {
        _log.info((Object)"/=============================");
        _log.info((Object)"...Initializing include query.");
        Map<String, Map<String, Map<String, List<String>>>> map = this.includeQueryProperties.getIncludeQueryMap();
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            _log.info((Object)key);
            Map<String, Map<String, List<String>>> queryElementMap = map.get(key);
            Set<String> queryElementKeySet = queryElementMap.keySet();
            for (String queryElementKey : queryElementKeySet) {
                _log.info((Object)("    " + queryElementKey));
                Map<String, List<String>> tableElementMap = queryElementMap.get(queryElementKey);
                Set<String> tableElementKeySet = tableElementMap.keySet();
                for (String tableName : tableElementKeySet) {
                    _log.info((Object)("        " + tableName));
                    Table targetTable = this.tableFinder.findTable(tableName);
                    if (targetTable == null) {
                        this.throwIncludeQueryTableNotFoundException(queryElementKey, tableName, map);
                    }
                    List<String> columnNameList = null;
                    try {
                        columnNameList = tableElementMap.get(tableName);
                    }
                    catch (ClassCastException e) {
                        this.throwIncludeQueryNotListColumnSpecificationException(queryElementKey, tableName, map, e);
                    }
                    for (String columnName : columnNameList) {
                        _log.info((Object)("            " + columnName));
                        Column targetColumn = targetTable.getColumn(columnName);
                        if (targetColumn != null) continue;
                        this.throwIncludeQueryColumnNotFoundException(queryElementKey, tableName, columnName, map);
                    }
                }
            }
        }
        _log.info((Object)"========/");
    }

    protected void throwIncludeQueryTableNotFoundException(String queryElementKey, String tableName, Map<String, Map<String, Map<String, List<String>>>> map) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The table was Not Found in includeQueryMap!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Query Type]" + this.ln() + queryElementKey + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Table Name]" + this.ln() + tableName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Include Query Map]" + this.ln() + map + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfIncludeQueryTableNotFoundException(msg);
    }

    protected void throwIncludeQueryNotListColumnSpecificationException(String queryElementKey, String tableName, Map<String, Map<String, Map<String, List<String>>>> map, RuntimeException e) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The column specification of the table was Not List Type in includeQueryMap!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "You shuold specify them this way:" + this.ln();
        msg = msg + "    --------------------------------------------" + this.ln();
        msg = msg + "    " + tableName + " = list:{XXX_ID ; XXX_NAME}" + this.ln();
        msg = msg + "    --------------------------------------------" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Query Type]" + this.ln() + queryElementKey + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Table Name]" + this.ln() + tableName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Include Query Map]" + this.ln() + map + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfIncludeQueryNotListColumnSpecificationException(msg, e);
    }

    protected void throwIncludeQueryColumnNotFoundException(String queryElementKey, String tableName, String columnName, Map<String, Map<String, Map<String, List<String>>>> map) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The column was Not Found in includeQueryMap!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Query Type]" + this.ln() + queryElementKey + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Table Name]" + this.ln() + tableName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Column Name]" + this.ln() + columnName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Include Query Map]" + this.ln() + map + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new DfIncludeQueryColumnNotFoundException(msg);
    }

    public String ln() {
        return "\n";
    }

    public DfIncludeQueryProperties getIncludeQueryProperties() {
        return this.includeQueryProperties;
    }

    public void setIncludeQueryProperties(DfIncludeQueryProperties includeQueryProperties) {
        this.includeQueryProperties = includeQueryProperties;
    }

    public DfTableFinder getTableFinder() {
        return this.tableFinder;
    }

    public void setTableFinder(DfTableFinder tableFinder) {
        this.tableFinder = tableFinder;
    }

    protected static class DfIncludeQueryColumnNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DfIncludeQueryColumnNotFoundException(String msg) {
            super(msg);
        }
    }

    protected static class DfIncludeQueryNotListColumnSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DfIncludeQueryNotListColumnSpecificationException(String msg, RuntimeException e) {
            super(msg, e);
        }
    }

    protected static class DfIncludeQueryTableNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DfIncludeQueryTableNotFoundException(String msg) {
            super(msg);
        }
    }
}

