/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.replaceschema.takefinally.sequence;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.exception.DfPropertySettingTableNotFoundException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.logic.jdbc.handler.DfTableHandler;
import org.seasar.dbflute.logic.jdbc.handler.DfUniqueKeyHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfPrimaryKeyMetaInfo;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;
import org.seasar.dbflute.logic.replaceschema.takefinally.sequence.DfSequenceHandler;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfSequenceHandlerJdbc
implements DfSequenceHandler {
    private static final Log _log = LogFactory.getLog(DfSequenceHandlerJdbc.class);
    protected DataSource _dataSource;
    protected List<UnifiedSchema> _unifiedSchemaList;
    protected final DfUniqueKeyHandler _uniqueKeyHandler = new DfUniqueKeyHandler();
    protected Map<String, DfTableMetaInfo> _tableMap;

    protected void initializeTableInfo(Connection conn) throws SQLException {
        if (this._tableMap != null) {
            return;
        }
        this._tableMap = StringKeyMap.createAsFlexible();
        DfTableHandler tableHandler = new DfTableHandler();
        DatabaseMetaData metaData = conn.getMetaData();
        List<UnifiedSchema> unifiedSchemaList = this._unifiedSchemaList;
        for (UnifiedSchema unifiedSchema : unifiedSchemaList) {
            this._tableMap.putAll(tableHandler.getTableMap(metaData, unifiedSchema));
        }
    }

    public DfSequenceHandlerJdbc(DataSource dataSource, List<UnifiedSchema> unifiedSchemaList) {
        this._dataSource = dataSource;
        this._unifiedSchemaList = unifiedSchemaList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public void incrementSequenceToDataMax(Map<String, String> tableSequenceMap) {
        Map skippedMap;
        block23: {
            SQLException ignored22222;
            Object var18_18;
            Statement st;
            Connection conn;
            Integer actualValue;
            String tableSqlName;
            DfPrimaryKeyMetaInfo pkInfo;
            DfTableMetaInfo tableInfo;
            String sequenceName;
            String tableName;
            block21: {
                skippedMap = DfCollectionUtil.newLinkedHashMap();
                _log.info((Object)"...Incrementing sequences to max value of table data");
                tableName = null;
                sequenceName = null;
                tableInfo = null;
                pkInfo = null;
                tableSqlName = null;
                actualValue = null;
                conn = null;
                st = null;
                conn = this._dataSource.getConnection();
                this.initializeTableInfo(conn);
                st = conn.createStatement();
                Set<Map.Entry<String, String>> entrySet = tableSequenceMap.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    tableName = null;
                    sequenceName = null;
                    tableInfo = null;
                    pkInfo = null;
                    tableSqlName = null;
                    actualValue = null;
                    tableName = entry.getKey();
                    sequenceName = entry.getValue();
                    this.assertValidSequence(sequenceName, tableName);
                    tableInfo = this.findTableInfo(conn, tableName);
                    pkInfo = this.findPrimaryKeyInfo(conn, tableInfo);
                    List<String> pkList = pkInfo.getPrimaryKeyList();
                    if (pkList.size() != 1) {
                        skippedMap.put(tableName, pkList);
                        continue;
                    }
                    String primaryKeyColumnName = pkList.get(0);
                    tableSqlName = tableInfo.buildTableSqlName();
                    Integer count = this.selectCount(st, tableSqlName);
                    if (count == null || count == 0 || (actualValue = this.selectDataMax(st, tableInfo, primaryKeyColumnName)) == null) continue;
                    this.callSequenceLoop(st, sequenceName, actualValue);
                }
                var18_18 = null;
                if (st == null) break block21;
                try {
                    st.close();
                }
                catch (SQLException ignored22222) {
                    _log.info((Object)"Statement.close() threw the exception!", (Throwable)ignored22222);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ignored22222) {
                    _log.info((Object)"Connection.close() threw the exception!", (Throwable)ignored22222);
                }
            }
            break block23;
            {
                catch (SQLException e) {
                    this.throwIncrementSequenceToDataMaxFailureException(tableName, sequenceName, tableInfo, pkInfo, tableSqlName, actualValue, e);
                    var18_18 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException ignored22222) {
                            _log.info((Object)"Statement.close() threw the exception!", (Throwable)ignored22222);
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException ignored22222) {
                            _log.info((Object)"Connection.close() threw the exception!", (Throwable)ignored22222);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException ignored22222;
                Object var18_19 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException ignored22222) {
                        _log.info((Object)"Statement.close() threw the exception!", (Throwable)ignored22222);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored22222) {
                        _log.info((Object)"Connection.close() threw the exception!", (Throwable)ignored22222);
                    }
                }
                throw throwable;
            }
        }
        if (!skippedMap.isEmpty()) {
            _log.info((Object)"*Unsupported incrementing sequences(multiple-PK):");
            Set skippedEntrySet = skippedMap.entrySet();
            for (Map.Entry<String, String> skippedEntry : skippedEntrySet) {
                String skippedTableName = skippedEntry.getKey();
                List pkList = (List)((Object)skippedEntry.getValue());
                _log.info((Object)("    " + skippedTableName + ": pk=" + pkList));
            }
        }
    }

    protected void assertValidSequence(String sequenceName, String tableName) {
        if (Srl.is_Null_or_TrimmedEmpty((String)sequenceName)) {
            String msg = "Not found the sequence name of the table:";
            msg = msg + " tableName=" + tableName;
            throw new IllegalStateException(msg);
        }
    }

    protected DfTableMetaInfo findTableInfo(Connection conn, String tableName) throws SQLException {
        DfTableMetaInfo table = this._tableMap.get(tableName);
        if (table == null) {
            String msg = "Failed to find the table in generated target tables:";
            msg = msg + " table=" + tableName + " target=" + this._tableMap.keySet();
            throw new DfPropertySettingTableNotFoundException(msg);
        }
        return table;
    }

    protected DfPrimaryKeyMetaInfo findPrimaryKeyInfo(Connection conn, DfTableMetaInfo tableInfo) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        return this._uniqueKeyHandler.getPrimaryKey(metaData, tableInfo);
    }

    protected void callSequenceLoop(Statement st, String sequenceName, Integer actualValue) throws SQLException {
        Integer sequenceValue;
        Integer startPoint = sequenceValue = this.selectNextVal(st, sequenceName);
        boolean decrementChecked = false;
        while (actualValue > sequenceValue) {
            sequenceValue = this.selectNextVal(st, sequenceName);
            if (decrementChecked) continue;
            if (startPoint >= sequenceValue) {
                String msg = "    " + sequenceName + ": " + startPoint + " to " + sequenceValue;
                msg = msg + " (unsupported for decrement)";
                _log.info((Object)msg);
                return;
            }
            decrementChecked = true;
        }
        _log.info((Object)("    " + sequenceName + ": " + startPoint + " to " + sequenceValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer selectCount(Statement statement, String tableName) throws SQLException {
        Integer n;
        block9: {
            ResultSet rs;
            block7: {
                Integer n2;
                block8: {
                    rs = null;
                    try {
                        rs = statement.executeQuery("select count(*) from " + tableName);
                        if (rs.next()) break block7;
                        n2 = null;
                        Object var6_6 = null;
                        if (rs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var6_8 = null;
                            if (rs == null) break block10;
                            try {
                                rs.close();
                            }
                            catch (SQLException ignored) {
                                _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored) {
                        _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
                    }
                }
                return n2;
            }
            n = rs.getInt(1);
            Object var6_7 = null;
            if (rs == null) break block9;
            try {
                rs.close();
            }
            catch (SQLException ignored) {
                _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer selectDataMax(Statement statement, DfTableMetaInfo tableInfo, String primaryKeyColumnName) throws SQLException {
        Integer n;
        block15: {
            Integer actualValue;
            String value;
            ResultSet rs;
            String tableSqlName;
            block13: {
                Integer n2;
                block14: {
                    block11: {
                        Integer n3;
                        block12: {
                            tableSqlName = tableInfo.buildTableSqlName();
                            String sql = "select max(" + primaryKeyColumnName + ") as MAX_VALUE from " + tableSqlName;
                            rs = null;
                            try {
                                rs = statement.executeQuery(sql);
                                if (rs.next()) break block11;
                                n3 = null;
                                Object var12_9 = null;
                                if (rs == null) break block12;
                            }
                            catch (Throwable throwable) {
                                block16: {
                                    Object var12_12 = null;
                                    if (rs == null) break block16;
                                    try {
                                        rs.close();
                                    }
                                    catch (SQLException ignored) {
                                        _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                rs.close();
                            }
                            catch (SQLException ignored) {
                                _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
                            }
                        }
                        return n3;
                    }
                    value = rs.getString(1);
                    if (value != null) break block13;
                    n2 = null;
                    Object var12_10 = null;
                    if (rs == null) break block14;
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored) {
                        _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
                    }
                }
                return n2;
            }
            try {
                actualValue = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                String msg = "The type of primary key related to sequece should be Number:";
                msg = msg + " table=" + tableSqlName + " primaryKey=" + primaryKeyColumnName;
                msg = msg + " value=" + value;
                throw new IllegalStateException(msg);
            }
            n = actualValue;
            Object var12_11 = null;
            if (rs == null) break block15;
            try {
                rs.close();
            }
            catch (SQLException ignored) {
                _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
            }
        }
        return n;
    }

    protected abstract Integer selectNextVal(Statement var1, String var2) throws SQLException;

    protected void throwIncrementSequenceToDataMaxFailureException(String tableName, String sequenceName, DfTableMetaInfo tableInfo, DfPrimaryKeyMetaInfo pkInfo, String tableSqlName, Integer actualValue, SQLException e) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "Failed to handle serial type sequence!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Table Name]" + this.ln() + tableName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Sequence Name]" + this.ln() + sequenceName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Table Info]" + this.ln() + tableInfo + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Primary Key Info]" + this.ln() + pkInfo + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Table SQL Name]" + this.ln() + tableSqlName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Table Data Max]" + this.ln() + actualValue + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IllegalStateException(msg);
    }

    protected String ln() {
        return "\n";
    }
}

