/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Table;
import org.apache.velocity.anakia.Escape;
import org.apache.velocity.context.Context;
import org.seasar.dbflute.helper.token.file.FileMakingCallback;
import org.seasar.dbflute.helper.token.file.FileMakingOption;
import org.seasar.dbflute.helper.token.file.FileMakingRowResource;
import org.seasar.dbflute.helper.token.file.impl.FileTokenImpl;
import org.seasar.dbflute.logic.dataxls.DfDataXlsTemplateHandler;
import org.seasar.dbflute.properties.DfAdditionalTableProperties;
import org.seasar.dbflute.properties.DfCommonColumnProperties;
import org.seasar.dbflute.properties.DfDocumentProperties;
import org.seasar.dbflute.task.bs.DfAbstractDbMetaTexenTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorqueDocumentationTask
extends DfAbstractDbMetaTexenTask {
    private static final Log _log = LogFactory.getLog(TorqueDocumentationTask.class);
    private String _outputFormat;

    @Override
    protected void doExecute() {
        this.processSchemaHtml();
        if (this.isDataXlsTemplateRecordLimitValid()) {
            this.processDataXlsTemplate();
        }
    }

    protected void processSchemaHtml() {
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * * * *");
        _log.info((Object)"*                   *");
        _log.info((Object)"*    Schema HTML    *");
        _log.info((Object)"*                   *");
        _log.info((Object)"* * * * * * * * * * *");
        super.doExecute();
        _log.info((Object)"");
    }

    protected void processDataXlsTemplate() {
        _log.info((Object)"* * * * * * * * * * *");
        _log.info((Object)"*                   *");
        _log.info((Object)"* Data Xls Template *");
        _log.info((Object)"*                   *");
        _log.info((Object)"* * * * * * * * * * *");
        LinkedHashMap<String, List<Column>> tableColumnMap = new LinkedHashMap<String, List<Column>>();
        DfAdditionalTableProperties tableProperties = this.getProperties().getAdditionalTableProperties();
        Map<String, Object> additionalTableMap = tableProperties.getAdditionalTableMap();
        boolean containsCommonColumn = this.isDataXlsTemplateContainsCommonColumn();
        Map<String, String> commonColumnMap = this.getCommonColumnMap();
        try {
            Database database = this._schemaData.getDatabase();
            List<Table> tableList = database.getTableList();
            for (Table table : tableList) {
                if (additionalTableMap.containsKey(table.getName())) continue;
                Column[] columns = table.getColumns();
                ArrayList<Column> columnNameList = new ArrayList<Column>();
                for (Column column : columns) {
                    if (!containsCommonColumn && commonColumnMap.containsKey(column.getName())) continue;
                    columnNameList.add(column);
                }
                tableColumnMap.put(table.getTableSqlNameDirectUse(), columnNameList);
            }
        }
        catch (EngineException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        _log.info((Object)("...Outputting data xls template: tables=" + tableColumnMap.size()));
        this.outputDataXlsTemplate(tableColumnMap);
        _log.info((Object)"");
    }

    protected void outputDataXlsTemplate(Map<String, List<Column>> tableColumnMap) {
        DfDataXlsTemplateHandler xlsHandler = new DfDataXlsTemplateHandler(this.getDataSource());
        Integer limit = this.getDataXlsTemplateRecordLimit();
        File xlsFile = this.getDataXlsTemplateFile();
        DfDataXlsTemplateHandler.TemplateDataResult outputResult = xlsHandler.outputData(tableColumnMap, limit, xlsFile);
        this.outputDataCsvTemplate(outputResult);
    }

    protected void outputDataCsvTemplate(DfDataXlsTemplateHandler.TemplateDataResult outputResult) {
        Map<String, List<Column>> overTableColumnMap = outputResult.getOverTableColumnMap();
        if (overTableColumnMap.isEmpty()) {
            return;
        }
        _log.info((Object)("...Outputting data csv template(over 65000): tables=" + overTableColumnMap.size()));
        Map<String, List<Map<String, String>>> overDumpDataMap = outputResult.getOverTemplateDataMap();
        FileMakingOption option = new FileMakingOption().delimitateByComma().encodeAsUTF8().separateLf();
        File csvDir = this.getDataCsvTemplateDir();
        if (!csvDir.exists()) {
            csvDir.mkdirs();
        }
        FileTokenImpl fileToken = new FileTokenImpl();
        Set<String> tableNameSet = overTableColumnMap.keySet();
        for (String tableName : tableNameSet) {
            String csvFilePath = csvDir.getPath() + "/" + tableName + ".csv";
            List<Column> columnList = overTableColumnMap.get(tableName);
            ArrayList<String> columnNameList = new ArrayList<String>();
            for (Column column : columnList) {
                columnNameList.add(column.getName());
            }
            List<Map<String, String>> recordList = overDumpDataMap.get(tableName);
            _log.info((Object)("    " + tableName + "(" + recordList.size() + ")"));
            try {
                option.headerInfo(columnNameList);
                final Iterator<Map<String, String>> recordListIterator = recordList.iterator();
                fileToken.make(csvFilePath, new FileMakingCallback(){

                    public FileMakingRowResource getRowResource() {
                        if (!recordListIterator.hasNext()) {
                            return null;
                        }
                        Map recordMap = (Map)recordListIterator.next();
                        FileMakingRowResource resource = new FileMakingRowResource();
                        LinkedHashMap nameValueMap = new LinkedHashMap();
                        nameValueMap.putAll(recordMap);
                        resource.setNameValueMap(nameValueMap);
                        return resource;
                    }
                }, option);
            }
            catch (FileNotFoundException e) {
                String msg = "Failed to output CSV file: table=" + tableName + " csv=" + csvFilePath;
                throw new IllegalStateException(msg, e);
            }
            catch (IOException e) {
                String msg = "Failed to output CSV file: table=" + tableName + " csv=" + csvFilePath;
                throw new IllegalStateException(msg, e);
            }
        }
    }

    @Override
    protected boolean isUseDataSource() {
        return true;
    }

    protected DfDocumentProperties getDocumentProperties() {
        return this.getProperties().getDocumentProperties();
    }

    protected boolean isDataXlsTemplateRecordLimitValid() {
        return this.getDocumentProperties().isDataXlsTemplateRecordLimitValid();
    }

    protected Integer getDataXlsTemplateRecordLimit() {
        return this.getDocumentProperties().getDataXlsTemplateRecordLimit();
    }

    protected boolean isDataXlsTemplateContainsCommonColumn() {
        return this.getDocumentProperties().isDataXlsTemplateContainsCommonColumn();
    }

    protected File getDataXlsTemplateFile() {
        return this.getDocumentProperties().getDataXlsTemplateFile();
    }

    protected File getDataCsvTemplateDir() {
        return this.getDocumentProperties().getDataCsvTemplateDir();
    }

    protected Map<String, String> getCommonColumnMap() {
        DfCommonColumnProperties commonColumnProperties = this.getProperties().getCommonColumnProperties();
        Map<String, String> commonColumnMap = commonColumnProperties.getCommonColumnMap();
        return commonColumnMap;
    }

    public boolean isGenerateProcedureParameterBean() {
        return this.getProperties().getOutsideSqlProperties().isGenerateProcedureParameterBean();
    }

    @Override
    public Context initControlContext() throws Exception {
        super.initControlContext();
        this._context.put("outputFormat", (Object)this._outputFormat);
        this._context.put("escape", (Object)new Escape());
        return this._context;
    }

    public String getOutputFormat() {
        return this._outputFormat;
    }

    public void setOutputFormat(String v) {
        this._outputFormat = v;
    }
}

