/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.model.WorkbookRecordList;
import org.apache.poi.hssf.record.CRNCountRecord;
import org.apache.poi.hssf.record.CRNRecord;
import org.apache.poi.hssf.record.ExternSheetRecord;
import org.apache.poi.hssf.record.ExternalNameRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SupBookRecord;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.formula.NameXPtg;

final class LinkTable {
    private final ExternalBookBlock[] _externalBookBlocks;
    private final ExternSheetRecord _externSheetRecord;
    private final List _definedNames;
    private final int _recordCount;
    private final WorkbookRecordList _workbookRecordList;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExternalNameRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CRNCountRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SupBookRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$NameRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExternSheetRecord;

    public LinkTable(List inputList, int startIndex, WorkbookRecordList workbookRecordList) {
        this._workbookRecordList = workbookRecordList;
        RecordStream rs = new RecordStream(inputList, startIndex);
        ArrayList<ExternalBookBlock> temp = new ArrayList<ExternalBookBlock>();
        while (rs.peekNextClass() == (class$org$apache$poi$hssf$record$SupBookRecord == null ? LinkTable.class$("org.apache.poi.hssf.record.SupBookRecord") : class$org$apache$poi$hssf$record$SupBookRecord)) {
            temp.add(new ExternalBookBlock(rs));
        }
        this._externalBookBlocks = new ExternalBookBlock[temp.size()];
        temp.toArray(this._externalBookBlocks);
        temp.clear();
        this._externSheetRecord = this._externalBookBlocks.length > 0 ? LinkTable.readExtSheetRecord(rs) : null;
        this._definedNames = new ArrayList();
        while (rs.peekNextClass() == (class$org$apache$poi$hssf$record$NameRecord == null ? LinkTable.class$("org.apache.poi.hssf.record.NameRecord") : class$org$apache$poi$hssf$record$NameRecord)) {
            NameRecord nr = (NameRecord)rs.getNext();
            this._definedNames.add(nr);
        }
        this._recordCount = rs.getCountRead();
        this._workbookRecordList.getRecords().addAll(inputList.subList(startIndex, startIndex + this._recordCount));
    }

    private static ExternSheetRecord readExtSheetRecord(RecordStream rs) {
        ArrayList<Record> temp = new ArrayList<Record>(2);
        while (rs.peekNextClass() == (class$org$apache$poi$hssf$record$ExternSheetRecord == null ? LinkTable.class$("org.apache.poi.hssf.record.ExternSheetRecord") : class$org$apache$poi$hssf$record$ExternSheetRecord)) {
            temp.add(rs.getNext());
        }
        int nItems = temp.size();
        if (nItems < 1) {
            throw new RuntimeException("Expected an EXTERNSHEET record but got (" + rs.peekNextClass().getName() + ")");
        }
        if (nItems == 1) {
            return (ExternSheetRecord)temp.get(0);
        }
        ExternSheetRecord[] esrs = new ExternSheetRecord[nItems];
        temp.toArray(esrs);
        return ExternSheetRecord.combine(esrs);
    }

    public LinkTable(int numberOfSheets, WorkbookRecordList workbookRecordList) {
        this._workbookRecordList = workbookRecordList;
        this._definedNames = new ArrayList();
        this._externalBookBlocks = new ExternalBookBlock[]{new ExternalBookBlock(numberOfSheets)};
        this._externSheetRecord = new ExternSheetRecord();
        this._recordCount = 2;
        SupBookRecord supbook = this._externalBookBlocks[0].getExternalBookRecord();
        int idx = this.findFirstRecordLocBySid((short)140);
        if (idx < 0) {
            throw new RuntimeException("CountryRecord not found");
        }
        this._workbookRecordList.add(idx + 1, this._externSheetRecord);
        this._workbookRecordList.add(idx + 1, supbook);
    }

    public int getRecordCount() {
        return this._recordCount;
    }

    public NameRecord getSpecificBuiltinRecord(byte builtInCode, int sheetNumber) {
        Iterator iterator = this._definedNames.iterator();
        while (iterator.hasNext()) {
            NameRecord record = (NameRecord)iterator.next();
            if (record.getBuiltInName() != builtInCode || record.getSheetNumber() != sheetNumber) continue;
            return record;
        }
        return null;
    }

    public void removeBuiltinRecord(byte name, int sheetIndex) {
        NameRecord record = this.getSpecificBuiltinRecord(name, sheetIndex);
        if (record != null) {
            this._definedNames.remove(record);
        }
    }

    public int getNumNames() {
        return this._definedNames.size();
    }

    public NameRecord getNameRecord(int index) {
        return (NameRecord)this._definedNames.get(index);
    }

    public void addName(NameRecord name) {
        this._definedNames.add(name);
        int idx = this.findFirstRecordLocBySid((short)23);
        if (idx == -1) {
            idx = this.findFirstRecordLocBySid((short)430);
        }
        if (idx == -1) {
            idx = this.findFirstRecordLocBySid((short)140);
        }
        int countNames = this._definedNames.size();
        this._workbookRecordList.add(idx + countNames, name);
    }

    public void removeName(int namenum) {
        this._definedNames.remove(namenum);
    }

    public boolean nameAlreadyExists(NameRecord name) {
        for (int i = this.getNumNames() - 1; i >= 0; --i) {
            NameRecord rec = this.getNameRecord(i);
            if (rec == name || !LinkTable.isDuplicatedNames(name, rec)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDuplicatedNames(NameRecord firstName, NameRecord lastName) {
        return lastName.getNameText().equalsIgnoreCase(firstName.getNameText()) && LinkTable.isSameSheetNames(firstName, lastName);
    }

    private static boolean isSameSheetNames(NameRecord firstName, NameRecord lastName) {
        return lastName.getSheetNumber() == firstName.getSheetNumber();
    }

    public String[] getExternalBookAndSheetName(int extRefIndex) {
        int ebIx = this._externSheetRecord.getExtbookIndexFromRefIndex(extRefIndex);
        SupBookRecord ebr = this._externalBookBlocks[ebIx].getExternalBookRecord();
        if (!ebr.isExternalReferences()) {
            return null;
        }
        int shIx = this._externSheetRecord.getFirstSheetIndexFromRefIndex(extRefIndex);
        UnicodeString usSheetName = ebr.getSheetNames()[shIx];
        return new String[]{ebr.getURL(), usSheetName.getString()};
    }

    public int getExternalSheetIndex(String workbookName, String sheetName) {
        SupBookRecord ebrTarget = null;
        int externalBookIndex = -1;
        for (int i = 0; i < this._externalBookBlocks.length; ++i) {
            SupBookRecord ebr = this._externalBookBlocks[i].getExternalBookRecord();
            if (!ebr.isExternalReferences() || !workbookName.equals(ebr.getURL())) continue;
            ebrTarget = ebr;
            externalBookIndex = i;
            break;
        }
        if (ebrTarget == null) {
            throw new RuntimeException("No external workbook with name '" + workbookName + "'");
        }
        int sheetIndex = LinkTable.getSheetIndex(ebrTarget.getSheetNames(), sheetName);
        int result = this._externSheetRecord.getRefIxForSheet(externalBookIndex, sheetIndex);
        if (result < 0) {
            throw new RuntimeException("ExternSheetRecord does not contain combination (" + externalBookIndex + ", " + sheetIndex + ")");
        }
        return result;
    }

    private static int getSheetIndex(UnicodeString[] sheetNames, String sheetName) {
        for (int i = 0; i < sheetNames.length; ++i) {
            if (!sheetNames[i].getString().equals(sheetName)) continue;
            return i;
        }
        throw new RuntimeException("External workbook does not contain sheet '" + sheetName + "'");
    }

    public int getIndexToInternalSheet(int extRefIndex) {
        return this._externSheetRecord.getFirstSheetIndexFromRefIndex(extRefIndex);
    }

    public int getSheetIndexFromExternSheetIndex(int extRefIndex) {
        if (extRefIndex >= this._externSheetRecord.getNumOfRefs()) {
            return -1;
        }
        return this._externSheetRecord.getFirstSheetIndexFromRefIndex(extRefIndex);
    }

    public int checkExternSheet(int sheetIndex) {
        int i;
        int thisWbIndex = -1;
        for (i = 0; i < this._externalBookBlocks.length; ++i) {
            SupBookRecord ebr = this._externalBookBlocks[i].getExternalBookRecord();
            if (!ebr.isInternalReferences()) continue;
            thisWbIndex = i;
            break;
        }
        if (thisWbIndex < 0) {
            throw new RuntimeException("Could not find 'internal references' EXTERNALBOOK");
        }
        i = this._externSheetRecord.getRefIxForSheet(thisWbIndex, sheetIndex);
        if (i >= 0) {
            return i;
        }
        return this._externSheetRecord.addRef(thisWbIndex, sheetIndex, sheetIndex);
    }

    private int findFirstRecordLocBySid(short sid) {
        int index = 0;
        Iterator iterator = this._workbookRecordList.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() == sid) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String resolveNameXText(int refIndex, int definedNameIndex) {
        int extBookIndex = this._externSheetRecord.getExtbookIndexFromRefIndex(refIndex);
        return this._externalBookBlocks[extBookIndex].getNameText(definedNameIndex);
    }

    public NameXPtg getNameXPtg(String name) {
        for (int i = 0; i < this._externalBookBlocks.length; ++i) {
            int sheetRefIndex;
            int definedNameIndex = this._externalBookBlocks[i].getIndexOfName(name);
            if (definedNameIndex < 0 || (sheetRefIndex = this.findRefIndexFromExtBookIndex(i)) < 0) continue;
            return new NameXPtg(sheetRefIndex, definedNameIndex);
        }
        return null;
    }

    private int findRefIndexFromExtBookIndex(int extBookIndex) {
        return this._externSheetRecord.findRefIndexFromExtBookIndex(extBookIndex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ExternalBookBlock {
        private final SupBookRecord _externalBookRecord;
        private final ExternalNameRecord[] _externalNameRecords;
        private final CRNBlock[] _crnBlocks;

        public ExternalBookBlock(RecordStream rs) {
            this._externalBookRecord = (SupBookRecord)rs.getNext();
            ArrayList<Object> temp = new ArrayList<Object>();
            while (rs.peekNextClass() == (class$org$apache$poi$hssf$record$ExternalNameRecord == null ? LinkTable.class$("org.apache.poi.hssf.record.ExternalNameRecord") : class$org$apache$poi$hssf$record$ExternalNameRecord)) {
                temp.add(rs.getNext());
            }
            this._externalNameRecords = new ExternalNameRecord[temp.size()];
            temp.toArray(this._externalNameRecords);
            temp.clear();
            while (rs.peekNextClass() == (class$org$apache$poi$hssf$record$CRNCountRecord == null ? LinkTable.class$("org.apache.poi.hssf.record.CRNCountRecord") : class$org$apache$poi$hssf$record$CRNCountRecord)) {
                temp.add(new CRNBlock(rs));
            }
            this._crnBlocks = new CRNBlock[temp.size()];
            temp.toArray(this._crnBlocks);
        }

        public ExternalBookBlock(int numberOfSheets) {
            this._externalBookRecord = SupBookRecord.createInternalReferences((short)numberOfSheets);
            this._externalNameRecords = new ExternalNameRecord[0];
            this._crnBlocks = new CRNBlock[0];
        }

        public SupBookRecord getExternalBookRecord() {
            return this._externalBookRecord;
        }

        public String getNameText(int definedNameIndex) {
            return this._externalNameRecords[definedNameIndex].getText();
        }

        public int getIndexOfName(String name) {
            for (int i = 0; i < this._externalNameRecords.length; ++i) {
                if (!this._externalNameRecords[i].getText().equalsIgnoreCase(name)) continue;
                return i;
            }
            return -1;
        }
    }

    private static final class CRNBlock {
        private final CRNCountRecord _countRecord;
        private final CRNRecord[] _crns;

        public CRNBlock(RecordStream rs) {
            this._countRecord = (CRNCountRecord)rs.getNext();
            int nCRNs = this._countRecord.getNumberOfCRNs();
            CRNRecord[] crns = new CRNRecord[nCRNs];
            for (int i = 0; i < crns.length; ++i) {
                crns[i] = (CRNRecord)rs.getNext();
            }
            this._crns = crns;
        }

        public CRNRecord[] getCrns() {
            return (CRNRecord[])this._crns.clone();
        }
    }
}

