/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.properties;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.seasar.dbflute.exception.DfIllegalPropertyTypeException;
import org.seasar.dbflute.properties.DfAbstractHelperProperties;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DfOutsideSqlProperties
extends DfAbstractHelperProperties {
    public static final String KEY_outsideSqlDefinitionMap = "outsideSqlDefinitionMap";
    protected Map<String, Object> _outsideSqlDefinitionMap;
    protected List<String> _targetProcedureCatalogList;
    protected List<String> _targetProcedureSchemaList;
    protected List<String> _targetProcedureNameList;
    protected List<String> _executionMetaProcedureNameList;

    public DfOutsideSqlProperties(Properties prop) {
        super(prop);
    }

    protected Map<String, Object> getOutsideSqlDefinitionMap() {
        if (this._outsideSqlDefinitionMap == null) {
            this._outsideSqlDefinitionMap = this.mapProp("torque.outsideSqlDefinitionMap", DEFAULT_EMPTY_MAP);
        }
        return this._outsideSqlDefinitionMap;
    }

    public boolean isProperty(String key, boolean defaultValue) {
        return this.isProperty(key, defaultValue, this.getOutsideSqlDefinitionMap());
    }

    public boolean isGenerateProcedureParameterBean() {
        return this.isProperty("isGenerateProcedureParameterBean", false);
    }

    public boolean isGenerateProcedureCustomizeEntity() {
        return this.isProperty("isGenerateProcedureCustomizeEntity", false);
    }

    protected List<String> getTargetProcedureCatalogList() {
        if (this._targetProcedureCatalogList != null) {
            return this._targetProcedureCatalogList;
        }
        this._targetProcedureCatalogList = this.getOutsideSqlPropertyAsList("targetProcedureCatalogList");
        if (this._targetProcedureCatalogList == null) {
            this._targetProcedureCatalogList = DfCollectionUtil.emptyList();
        }
        return this._targetProcedureCatalogList;
    }

    public boolean isTargetProcedureCatalog(String procedureCatalog) {
        List<String> targetProcedureList = this.getTargetProcedureCatalogList();
        if (targetProcedureList == null || targetProcedureList.isEmpty()) {
            return true;
        }
        if (procedureCatalog == null || procedureCatalog.trim().length() == 0) {
            return targetProcedureList.contains("$$DEFAULT$$");
        }
        for (String catalogHint : targetProcedureList) {
            if (!this.isHitByTheHint(procedureCatalog, catalogHint)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getTargetProcedureSchemaList() {
        if (this._targetProcedureSchemaList != null) {
            return this._targetProcedureSchemaList;
        }
        this._targetProcedureSchemaList = this.getOutsideSqlPropertyAsList("targetProcedureSchemaList");
        if (this._targetProcedureSchemaList == null) {
            this._targetProcedureSchemaList = DfCollectionUtil.emptyList();
        }
        return this._targetProcedureSchemaList;
    }

    public boolean isTargetProcedureSchema(String procedureSchema) {
        List<String> targetProcedureList = this.getTargetProcedureSchemaList();
        if (targetProcedureList == null || targetProcedureList.isEmpty()) {
            return true;
        }
        if (procedureSchema == null || procedureSchema.trim().length() == 0) {
            return targetProcedureList.contains("$$DEFAULT$$");
        }
        for (String schemaHint : targetProcedureList) {
            if (!this.isHitByTheHint(procedureSchema, schemaHint)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getTargetProcedureNameList() {
        if (this._targetProcedureNameList != null) {
            return this._targetProcedureNameList;
        }
        this._targetProcedureNameList = this.getOutsideSqlPropertyAsList("targetProcedureNameList");
        if (this._targetProcedureNameList == null) {
            this._targetProcedureNameList = DfCollectionUtil.emptyList();
        }
        return this._targetProcedureNameList;
    }

    public boolean isTargetProcedureName(String procedureName) {
        List<String> targetProcedureList = this.getTargetProcedureNameList();
        if (targetProcedureList == null || targetProcedureList.isEmpty()) {
            return true;
        }
        for (String procedureNameHint : targetProcedureList) {
            if (!this.isHitByTheHint(procedureName, procedureNameHint)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getExecutionMetaProcedureNameList() {
        if (this._executionMetaProcedureNameList != null) {
            return this._executionMetaProcedureNameList;
        }
        this._executionMetaProcedureNameList = this.getOutsideSqlPropertyAsList("executionMetaProcedureNameList");
        if (this._executionMetaProcedureNameList == null) {
            this._executionMetaProcedureNameList = DfCollectionUtil.emptyList();
        }
        return this._executionMetaProcedureNameList;
    }

    public boolean hasSpecifiedExecutionMetaProcedure() {
        return !this.getExecutionMetaProcedureNameList().isEmpty();
    }

    public boolean isExecutionMetaProcedureName(String procedureName) {
        List<String> executionMetaProcedureList = this.getExecutionMetaProcedureNameList();
        if (executionMetaProcedureList == null || executionMetaProcedureList.isEmpty()) {
            return true;
        }
        for (String procedureNameHint : executionMetaProcedureList) {
            if (!this.isHitByTheHint(procedureName, procedureNameHint)) continue;
            return true;
        }
        return false;
    }

    public ProcedureSynonymHandlingType getProcedureSynonymHandlingType() {
        String key = "procedureSynonymHandlingType";
        String property = this.getProperty("procedureSynonymHandlingType", ProcedureSynonymHandlingType.NONE.name(), this.getOutsideSqlDefinitionMap());
        if (property.equalsIgnoreCase(ProcedureSynonymHandlingType.NONE.name())) {
            return ProcedureSynonymHandlingType.NONE;
        }
        if (property.equalsIgnoreCase(ProcedureSynonymHandlingType.INCLUDE.name())) {
            return ProcedureSynonymHandlingType.INCLUDE;
        }
        if (property.equalsIgnoreCase(ProcedureSynonymHandlingType.SWITCH.name())) {
            return ProcedureSynonymHandlingType.SWITCH;
        }
        String msg = "The property was out of scope for procedureSynonymHandlingType: value=" + property;
        throw new DfIllegalPropertyTypeException(msg);
    }

    public boolean isRequiredSqlTitle() {
        return this.isProperty("isRequiredSqlTitle", false);
    }

    public boolean isRequiredSqlDescription() {
        return this.isProperty("isRequiredSqlDescription", false);
    }

    public boolean isSuppressParameterCommentCheck() {
        return this.isProperty("isSuppressParameterCommentCheck", false);
    }

    public boolean hasSqlFileEncoding() {
        String encoding = this.getSqlFileEncoding();
        return encoding != null && encoding.trim().length() > 0 && !encoding.trim().equalsIgnoreCase("null");
    }

    public String getSqlFileEncoding() {
        String value = (String)this.getOutsideSqlDefinitionMap().get("sqlFileEncoding");
        if (value != null && value.trim().length() > 0 && !value.trim().equalsIgnoreCase("null")) {
            return value;
        }
        return "UTF-8";
    }

    public String getSqlDirectory() {
        String sqlDirectory = (String)this.getOutsideSqlDefinitionMap().get("sqlDirectory");
        if (sqlDirectory == null || sqlDirectory.trim().length() == 0) {
            sqlDirectory = this.getDefaultSqlDirectory();
        }
        sqlDirectory = this.removeEndSeparatorIfNeeds(sqlDirectory);
        String sqlPackage = this.getSqlPackage();
        if (sqlPackage != null && sqlPackage.trim().length() > 0) {
            String sqlPackageDirectory = this.resolveSqlPackageFileSeparator(sqlPackage);
            sqlDirectory = sqlDirectory + "/" + this.removeStartSeparatorIfNeeds(sqlPackageDirectory);
        }
        return sqlDirectory;
    }

    protected String removeStartSeparatorIfNeeds(String path) {
        if (path.startsWith("/")) {
            return path.substring("/".length());
        }
        return path;
    }

    protected String removeEndSeparatorIfNeeds(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected String getDefaultSqlDirectory() {
        return this.getBasicProperties().getGenerateOutputDirectory();
    }

    protected String resolveSqlPackageFileSeparator(String sqlPackage) {
        DfBasicProperties prop = this.getBasicProperties();
        if (!prop.isFlatDirectoryPackageValid()) {
            return this.replaceDotToSeparator(sqlPackage);
        }
        String flatDirectoryPackage = prop.getFlatDirectoryPackage();
        if (!sqlPackage.contains(flatDirectoryPackage)) {
            return this.replaceDotToSeparator(sqlPackage);
        }
        return this.resolveSqlPackageFileSeparatorWithFlatDirectory(sqlPackage, flatDirectoryPackage);
    }

    protected String resolveSqlPackageFileSeparatorWithFlatDirectory(String sqlPackage, String flatDirectoryPackage) {
        int startIndex = sqlPackage.indexOf(flatDirectoryPackage);
        String front = sqlPackage.substring(0, startIndex);
        String rear = sqlPackage.substring(startIndex + flatDirectoryPackage.length());
        front = this.replaceDotToSeparator(front);
        rear = this.replaceDotToSeparator(rear);
        return front + flatDirectoryPackage + rear;
    }

    protected String replaceDotToSeparator(String sqlPackage) {
        return DfStringUtil.replace((String)sqlPackage, (String)".", (String)"/");
    }

    public boolean isSqlPackageValid() {
        String sqlPackage = this.getSqlPackage();
        return sqlPackage != null && sqlPackage.trim().length() > 0 && !sqlPackage.trim().equalsIgnoreCase("null");
    }

    public String getSqlPackage() {
        String sqlPackage = (String)this.getOutsideSqlDefinitionMap().get("sqlPackage");
        if (sqlPackage == null || sqlPackage.trim().length() == 0) {
            sqlPackage = this.getDefaultSqlPackage();
        }
        return this.resolvePackageBaseMarkIfNeeds(sqlPackage);
    }

    protected String getDefaultSqlPackage() {
        return "";
    }

    protected String resolvePackageBaseMarkIfNeeds(String sqlPackage) {
        String packageBase = this.getBasicProperties().getPackageBase();
        return DfStringUtil.replace((String)sqlPackage, (String)"$$PACKAGE_BASE$$", (String)packageBase);
    }

    public String getSql2EntityOutputDirectory() {
        String value = (String)this.getOutsideSqlDefinitionMap().get("sql2EntityOutputDirectory");
        if (value == null || value.trim().length() == 0) {
            return this.getBasicProperties().getGenerateOutputDirectory();
        }
        return value;
    }

    protected String getSpecifiedBaseCustomizeEntityPackage() {
        String value = (String)this.getOutsideSqlDefinitionMap().get("baseCustomizeEntityPackage");
        return value != null && value.trim().length() > 0 ? value : null;
    }

    protected String getSpecifiedExtendedCustomizeEntityPackage() {
        String value = (String)this.getOutsideSqlDefinitionMap().get("extendedCustomizeEntityPackage");
        return value != null && value.trim().length() > 0 ? value : null;
    }

    protected String getSpecifiedBaseParameterBeanPackage() {
        String value = (String)this.getOutsideSqlDefinitionMap().get("baseParameterBeanPackage");
        return value != null && value.trim().length() > 0 ? value : null;
    }

    protected String getSpecifiedExtendedParameterBeanPackage() {
        String value = (String)this.getOutsideSqlDefinitionMap().get("extendedParameterBeanPackage");
        return value != null && value.trim().length() > 0 ? value : null;
    }

    public String getBaseEntityPackage() {
        String specifiedPackage = this.getSpecifiedBaseCustomizeEntityPackage();
        if (specifiedPackage != null && specifiedPackage.trim().length() != 0) {
            return specifiedPackage;
        }
        String defaultPackage = this.getBasicProperties().getBaseEntityPackage() + "." + this.getCustomizePackageName();
        if (defaultPackage != null && defaultPackage.trim().length() != 0) {
            return defaultPackage;
        }
        String msg = "Both packageString in sql2entity-property and baseEntityPackage are null.";
        throw new IllegalStateException(msg);
    }

    public String getDBMetaPackage() {
        String dbmetaPackage = "dbmeta";
        if (this.getBasicProperties().isTargetLanguageCSharp()) {
            dbmetaPackage = "Dbm";
        }
        return this.getBaseEntityPackage() + "." + dbmetaPackage;
    }

    public String getExtendedEntityPackage() {
        String specifiedPackage = this.getSpecifiedExtendedCustomizeEntityPackage();
        if (specifiedPackage != null && specifiedPackage.trim().length() != 0) {
            return specifiedPackage;
        }
        String defaultPackage = this.getBasicProperties().getExtendedEntityPackage() + "." + this.getCustomizePackageName();
        if (defaultPackage != null && defaultPackage.trim().length() != 0) {
            return defaultPackage;
        }
        String msg = "Both packageString in sql2entity-property and extendedEntityPackage are null.";
        throw new IllegalStateException(msg);
    }

    protected String getCustomizePackageName() {
        String customizePackage = "customize";
        if (this.getBasicProperties().isTargetLanguageCSharp()) {
            customizePackage = "Customize";
        }
        return customizePackage;
    }

    public String getBaseCursorPackage() {
        if (this.isMakeDaoInterface()) {
            return this.getBasicProperties().getBaseDaoPackage() + "." + this.getCursorPackageName();
        }
        return this.getBasicProperties().getBaseBehaviorPackage() + "." + this.getCursorPackageName();
    }

    public String getExtendedCursorPackage() {
        if (this.isMakeDaoInterface()) {
            return this.getBasicProperties().getExtendedDaoPackage() + "." + this.getCursorPackageName();
        }
        return this.getBasicProperties().getExtendedBehaviorPackage() + "." + this.getCursorPackageName();
    }

    protected String getCursorPackageName() {
        String pmbeanPackage = "cursor";
        if (this.getBasicProperties().isTargetLanguageCSharp()) {
            pmbeanPackage = "Cursor";
        }
        return pmbeanPackage;
    }

    public String getBaseParameterBeanPackage() {
        String specifiedPackage = this.getSpecifiedBaseParameterBeanPackage();
        if (specifiedPackage != null && specifiedPackage.trim().length() != 0) {
            return specifiedPackage;
        }
        String defaultPackage = this.isMakeDaoInterface() ? this.getBasicProperties().getBaseDaoPackage() + "." + this.getPmbeanPackageName() : this.getBasicProperties().getBaseBehaviorPackage() + "." + this.getPmbeanPackageName();
        if (defaultPackage != null && defaultPackage.trim().length() != 0) {
            return defaultPackage;
        }
        String msg = "Both packageString in sql2entity-property and baseEntityPackage are null.";
        throw new IllegalStateException(msg);
    }

    public String getExtendedParameterBeanPackage() {
        String specifiedPackage = this.getSpecifiedExtendedParameterBeanPackage();
        if (specifiedPackage != null && specifiedPackage.trim().length() != 0) {
            return specifiedPackage;
        }
        String defaultPackage = this.isMakeDaoInterface() ? this.getBasicProperties().getExtendedDaoPackage() + "." + this.getPmbeanPackageName() : this.getBasicProperties().getExtendedBehaviorPackage() + "." + this.getPmbeanPackageName();
        if (defaultPackage != null && defaultPackage.trim().length() != 0) {
            return defaultPackage;
        }
        String msg = "Both packageString in sql2entity-property and extendedEntityPackage are null.";
        throw new IllegalStateException(msg);
    }

    protected String getPmbeanPackageName() {
        String pmbeanPackage = "pmbean";
        if (this.getBasicProperties().isTargetLanguageCSharp()) {
            pmbeanPackage = "PmBean";
        }
        return pmbeanPackage;
    }

    protected boolean isMakeDaoInterface() {
        return this.getLittleAdjustmentProperties().isMakeDaoInterface();
    }

    public boolean isSuppressBehaviorQueryPath() {
        return this.isProperty("isSuppressBehaviorQueryPath", false);
    }

    public boolean isDefaultPackageValid() {
        return this.getDefaultPackage() != null && this.getDefaultPackage().trim().length() > 0 && !this.getDefaultPackage().trim().equalsIgnoreCase("null");
    }

    public String getDefaultPackage() {
        return (String)this.getOutsideSqlDefinitionMap().get("defaultPackage");
    }

    public boolean isOmitResourcePathPackageValid() {
        return this.getOmitResourcePathPackage() != null && this.getOmitResourcePathPackage().trim().length() > 0 && !this.getOmitResourcePathPackage().trim().equalsIgnoreCase("null");
    }

    public String getOmitResourcePathPackage() {
        return (String)this.getOutsideSqlDefinitionMap().get("omitResourcePathPackage");
    }

    public boolean isOmitFileSystemPathPackageValid() {
        return this.getOmitFileSystemPathPackage() != null && this.getOmitFileSystemPathPackage().trim().length() > 0 && !this.getOmitFileSystemPathPackage().trim().equalsIgnoreCase("null");
    }

    public String getOmitFileSystemPathPackage() {
        return (String)this.getOutsideSqlDefinitionMap().get("omitFileSystemPathPackage");
    }

    protected List<String> getOutsideSqlPropertyAsList(String key) {
        return (List)this.getOutsideSqlDefinitionMap().get(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProcedureSynonymHandlingType {
        NONE,
        INCLUDE,
        SWITCH;

    }
}

