/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.exception.thrower;

import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.exception.DangerousResultSizeException;
import org.seasar.dbflute.exception.EntityAlreadyDeletedException;
import org.seasar.dbflute.exception.EntityDuplicatedException;
import org.seasar.dbflute.exception.OptimisticLockColumnValueNullException;
import org.seasar.dbflute.exception.PagingCountSelectNotCountException;
import org.seasar.dbflute.exception.SelectEntityConditionNotFoundException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.jdbc.FetchBean;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BehaviorExceptionThrower {
    public void throwSelectEntityAlreadyDeletedException(Object searchKey) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The entity was NOT found! it has already been deleted.");
        br.addItem("Advice");
        br.addElement("Please confirm the existence of your target record on your database.");
        br.addElement("Does the target record really created before this operation?");
        br.addElement("Has the target record been deleted by other thread?");
        br.addElement("It is precondition that the record exists on your database.");
        this.setupSearchKeyElement(br, searchKey);
        String msg = br.buildExceptionMessage();
        throw new EntityAlreadyDeletedException(msg);
    }

    public void throwSelectEntityDuplicatedException(String resultCountExp, Object searchKey, Throwable cause) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The entity was duplicated! It should be the only one.");
        br.addItem("Advice");
        br.addElement("Confirm your search condition. Does it really select the only one?");
        br.addElement("And confirm your database. Does it really exist the only one?");
        br.addItem("Result Count");
        br.addElement(resultCountExp);
        this.setupSearchKeyElement(br, searchKey);
        String msg = br.buildExceptionMessage();
        if (cause != null) {
            throw new EntityDuplicatedException(msg, cause);
        }
        throw new EntityDuplicatedException(msg);
    }

    protected void setupSearchKeyElement(ExceptionMessageBuilder br, Object searchKey) {
        if (searchKey != null && searchKey instanceof ConditionBean) {
            ConditionBean cb = (ConditionBean)searchKey;
            this.setupInvalidQueryElement(br, cb);
            this.setupDisplaySqlElement(br, cb);
        } else {
            br.addItem("Search Condition");
            br.addElement(searchKey);
        }
    }

    public void throwSelectEntityConditionNotFoundException(ConditionBean cb) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The condition for selecting an entity was not found!");
        br.addItem("Advice");
        br.addElement("Confirm your search condition. Does it really select the only one?");
        br.addElement("You have to set a valid query or fetch-first as 1.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    MemberCB cb = MemberCB();");
        br.addElement("    ... = memberBhv.selectEntity(cb); // exception");
        br.addElement("  (x):");
        br.addElement("    MemberCB cb = MemberCB();");
        br.addElement("    cb.query().setMemberId_Equal(null);");
        br.addElement("    ... = memberBhv.selectEntity(cb); // exception");
        br.addElement("  (o):");
        br.addElement("    MemberCB cb = MemberCB();");
        br.addElement("    cb.query().setMemberId_Equal(3);");
        br.addElement("    ... = memberBhv.selectEntity(cb);");
        br.addElement("  (o):");
        br.addElement("    MemberCB cb = MemberCB();");
        br.addElement("    cb.fetchFirst(1);");
        br.addElement("    ... = memberBhv.selectEntity(cb);");
        this.setupInvalidQueryElement(br, cb);
        this.setupFetchSizeElement(br, cb);
        this.setupDisplaySqlElement(br, cb);
        String msg = br.buildExceptionMessage();
        throw new SelectEntityConditionNotFoundException(msg);
    }

    public void throwDangerousResultSizeException(FetchBean fetchBean, Throwable cause) {
        int safetyMaxResultSize = fetchBean.getSafetyMaxResultSize();
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("You've already been in DANGER ZONE. (check is working)");
        br.addItem("Advice");
        br.addElement("The selected size is over the specified safety size.");
        br.addElement("Confirm your conditions and table records.");
        br.addItem("Safety Max Result Size");
        br.addElement(safetyMaxResultSize);
        if (fetchBean instanceof ConditionBean) {
            ConditionBean cb = (ConditionBean)fetchBean;
            this.setupInvalidQueryElement(br, cb);
            this.setupFetchSizeElement(br, cb);
            this.setupDisplaySqlElement(br, cb);
        } else {
            br.addItem("Fetch Bean");
            br.addElement(fetchBean);
        }
        String msg = br.buildExceptionMessage();
        throw new DangerousResultSizeException(msg, cause, safetyMaxResultSize);
    }

    protected void setupInvalidQueryElement(ExceptionMessageBuilder br, ConditionBean cb) {
        br.addItem("Invalid Query");
        Map<ColumnRealName, ConditionKey> invalidQueryColumnMap = cb.getSqlClause().getInvalidQueryColumnMap();
        if (invalidQueryColumnMap != null && !invalidQueryColumnMap.isEmpty()) {
            Set<Map.Entry<ColumnRealName, ConditionKey>> entrySet = invalidQueryColumnMap.entrySet();
            for (Map.Entry<ColumnRealName, ConditionKey> entry : entrySet) {
                br.addElement(entry.getKey() + " : " + entry.getValue().getConditionKey());
            }
        } else {
            br.addElement("*no invalid");
        }
    }

    protected void setupFetchSizeElement(ExceptionMessageBuilder br, ConditionBean cb) {
        br.addItem("Fetch Size");
        br.addElement(cb.getFetchSize());
    }

    protected void setupDisplaySqlElement(ExceptionMessageBuilder br, ConditionBean cb) {
        br.addItem("Display SQL");
        br.addElement(cb.toDisplaySql());
    }

    public <ENTITY> void throwPagingCountSelectNotCountException(String tableDbName, String path, PagingBean pmb, Class<ENTITY> entityType, EntityDuplicatedException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The count select for paging could not get a count.");
        br.addItem("Advice");
        br.addElement("A select clause of OutsideSql paging should be switchable like this:");
        br.addElement("For example:");
        br.addElement("  /*IF pmb.isPaging()*/");
        br.addElement("  select member.MEMBER_ID");
        br.addElement("       , member.MEMBER_NAME");
        br.addElement("       , ...");
        br.addElement("  -- ELSE select count(*)");
        br.addElement("  /*END*/");
        br.addElement("    from ...");
        br.addElement("   where ...");
        br.addElement("");
        br.addElement("This specificaton is for both ManualPaging and AutoPaging.");
        br.addElement("(AutoPaging is only allowed to omit a paging condition)");
        br.addItem("Table");
        br.addElement(tableDbName);
        br.addItem("OutsideSql");
        br.addElement(path);
        br.addItem("ParameterBean");
        br.addElement(pmb);
        br.addItem("Entity Type");
        br.addElement(entityType);
        String msg = br.buildExceptionMessage();
        throw new PagingCountSelectNotCountException(msg, e);
    }

    public <ENTITY extends Entity> void throwUpdateEntityAlreadyDeletedException(ENTITY entity) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The entity was not found! it has already been deleted.");
        this.setupEntityElement(br, entity);
        String msg = br.buildExceptionMessage();
        throw new EntityAlreadyDeletedException(msg);
    }

    public <ENTITY extends Entity> void throwUpdateEntityDuplicatedException(ENTITY entity, int count) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The entity was duplicated. It should be the only one!");
        br.addItem("Count");
        br.addElement(count);
        this.setupEntityElement(br, entity);
        String msg = br.buildExceptionMessage();
        throw new EntityDuplicatedException(msg);
    }

    public void throwVersionNoValueNullException(Entity entity) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the value of 'version no' on the entity!");
        br.addItem("Advice");
        br.addElement("Please confirm the existence of the value of 'version no' on the entity.");
        br.addElement("You called the method in which the check for optimistic lock is indispensable.");
        br.addElement("So 'version no' is required on the entity. In addition, please confirm");
        br.addElement("the necessity of optimistic lock. It might possibly be unnecessary.");
        this.setupEntityElement(br, entity);
        String msg = br.buildExceptionMessage();
        throw new OptimisticLockColumnValueNullException(msg);
    }

    public void throwUpdateDateValueNullException(Entity entity) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the value of 'update date' on the entity!");
        br.addItem("Advice");
        br.addElement("Please confirm the existence of the value of 'update date' on the entity.");
        br.addElement("You called the method in which the check for optimistic lock is indispensable.");
        br.addElement("So 'update date' is required on the entity. In addition, please confirm");
        br.addElement("the necessity of optimistic lock. It might possibly be unnecessary.");
        this.setupEntityElement(br, entity);
        String msg = br.buildExceptionMessage();
        throw new OptimisticLockColumnValueNullException(msg);
    }

    protected void setupEntityElement(ExceptionMessageBuilder br, Entity entity) {
        br.addItem("Entity");
        br.addElement(entity.toString());
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected String initCap(String str) {
        return Srl.initCap(str);
    }

    protected String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected ExceptionMessageBuilder createExceptionMessageBuilder() {
        return new ExceptionMessageBuilder();
    }
}

