/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.command.dml.Query;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionInSelect
extends Condition {
    private Database database;
    private Expression left;
    private Query query;
    private boolean all;
    private int compareType;
    private int queryLevel;

    public ConditionInSelect(Database database, Expression expression, Query query, boolean bl, int n) {
        this.database = database;
        this.left = expression;
        this.query = query;
        this.all = bl;
        this.compareType = n;
    }

    public Value getValue(Session session) {
        this.query.setSession(session);
        ResultInterface resultInterface = this.query.query(0);
        session.addTemporaryResult(resultInterface);
        boolean bl = false;
        boolean bl2 = this.all;
        Value value = this.left.getValue(session);
        boolean bl3 = false;
        while (resultInterface.next()) {
            boolean bl4;
            Value value2;
            if (!bl3) {
                if (value == ValueNull.INSTANCE) {
                    return value;
                }
                bl3 = true;
            }
            if ((value2 = resultInterface.currentRow()[0]) == ValueNull.INSTANCE) {
                bl4 = false;
                bl = true;
            } else {
                bl4 = Comparison.compareNotNull(this.database, value, value2, this.compareType);
            }
            if (!bl4 && this.all) {
                bl2 = false;
                break;
            }
            if (!bl4 || this.all) continue;
            bl2 = true;
            break;
        }
        if (!bl3) {
            return ValueBoolean.get(false);
        }
        if (!bl2 && bl) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl2);
    }

    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.query.mapColumns(columnResolver, n + 1);
        this.queryLevel = Math.max(n, this.queryLevel);
    }

    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        this.query.setDistinct(true);
        this.query.prepare();
        if (this.query.getColumnCount() != 1) {
            throw DbException.get(90052);
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.query.setEvaluatable(tableFilter, bl);
    }

    public String getSQL() {
        return "(" + this.left.getSQL() + " IN(" + this.query.getPlanSQL() + "))";
    }

    public void updateAggregate(Session session) {
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.query.isEverything(expressionVisitor);
    }

    public int getCost() {
        return this.left.getCost() + 10 + (int)(10.0 * this.query.getCost());
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!SysProperties.OPTIMIZE_IN_LIST) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        ExpressionVisitor expressionVisitor = ExpressionVisitor.get(6);
        expressionVisitor.setResolver(tableFilter);
        if (!this.query.isEverything(expressionVisitor)) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getInQuery(expressionColumn, this.query));
    }
}

