/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task.replaceschema;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.helper.jdbc.DfRunnerInformation;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileFireMan;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunner;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerDispatcher;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerExecute;
import org.seasar.dbflute.helper.token.line.LineTokenizingOption;
import org.seasar.dbflute.helper.token.line.impl.LineTokenImpl;
import org.seasar.dbflute.logic.generate.dataassert.DfDataAssertHandler;
import org.seasar.dbflute.logic.generate.dataassert.DfDataAssertProvider;
import org.seasar.dbflute.logic.replaceschema.takefinally.sequence.DfSequenceHandler;
import org.seasar.dbflute.logic.replaceschema.takefinally.sequence.factory.DfSequenceHandlerFactory;
import org.seasar.dbflute.properties.DfReplaceSchemaProperties;
import org.seasar.dbflute.properties.DfSequenceIdentityProperties;
import org.seasar.dbflute.task.replaceschema.DfAbstractReplaceSchemaTask;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfTakeFinallyTask
extends DfAbstractReplaceSchemaTask {
    private static final Log _log = LogFactory.getLog(DfTakeFinallyTask.class);
    protected Timestamp beforeTimestamp;
    protected DfSqlFileFireMan.FireResult takeFinallyResult;

    @Override
    protected void doExecute() {
        DfRunnerInformation runInfo = this.createRunnerInformation();
        this.beforeTakeFinally();
        this.takeFinallyResult = this.takeFinally(runInfo);
        this.incrementSequenceToDataMax();
    }

    @Override
    protected long getTaskBeforeTimeMillis() {
        if (this.beforeTimestamp != null) {
            return this.beforeTimestamp.getTime();
        }
        return super.getTaskBeforeTimeMillis();
    }

    protected DfRunnerInformation createRunnerInformation() {
        DfRunnerInformation runInfo = new DfRunnerInformation();
        runInfo.setDriver(this._driver);
        runInfo.setUrl(this._url);
        runInfo.setUser(this._userId);
        runInfo.setPassword(this._password);
        runInfo.setEncoding(this.getReplaceSchemaSqlFileEncoding());
        runInfo.setAutoCommit(true);
        runInfo.setErrorContinue(this.getMyProperties().isErrorContinue());
        runInfo.setRollbackOnly(false);
        return runInfo;
    }

    protected String getReplaceSchemaSqlFileEncoding() {
        return this.getMyProperties().getSqlFileEncoding();
    }

    public boolean isLoggingInsertSql() {
        return this.getMyProperties().isLoggingInsertSql();
    }

    protected DfReplaceSchemaProperties getMyProperties() {
        return DfBuildProperties.getInstance().getReplaceSchemaProperties();
    }

    protected void beforeTakeFinally() {
        String processCommand = this.getMyProperties().getBeforeTakeFinally();
        if (processCommand == null) {
            return;
        }
        this.callbackProcess("beforeTakeFinally", processCommand);
    }

    protected DfSqlFileFireMan.FireResult takeFinally(DfRunnerInformation runInfo) {
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * **");
        _log.info((Object)"*              *");
        _log.info((Object)"* Take Finally *");
        _log.info((Object)"*              *");
        _log.info((Object)"* * * * * * * **");
        DfSqlFileFireMan fireMan = new DfSqlFileFireMan();
        fireMan.setExecutorName("Take Finally");
        return fireMan.execute(this.getSqlFileRunner4TakeFinally(runInfo), this.getTakeFinallySqlFileList());
    }

    protected DfSqlFileRunner getSqlFileRunner4TakeFinally(DfRunnerInformation runInfo) {
        final DfReplaceSchemaProperties prop = this.getMyProperties();
        DfSqlFileRunnerExecute runnerExecute = new DfSqlFileRunnerExecute(runInfo, this.getDataSource()){

            protected String filterSql(String sql) {
                sql = super.filterSql(sql);
                sql = prop.resolveFilterVariablesIfNeeds(sql);
                return sql;
            }

            protected boolean isSqlTrimAndRemoveLineSeparator() {
                return true;
            }

            protected boolean isHandlingCommentOnLineSeparator() {
                return true;
            }

            protected boolean isDbCommentLine(String line) {
                boolean commentLine = super.isDbCommentLine(line);
                if (commentLine) {
                    return commentLine;
                }
                return DfTakeFinallyTask.this.isDbCommentLineForIrregularPattern(line);
            }

            protected String getTerminater4Tool() {
                return DfTakeFinallyTask.this.resolveTerminater4Tool();
            }
        };
        runnerExecute.setDispatcher(new DfSqlFileRunnerDispatcher(){

            public boolean dispatch(File sqlFile, Statement st, String sql) throws SQLException {
                String dataLoadingType = DfTakeFinallyTask.this.getMyProperties().getDataLoadingType();
                DfDataAssertProvider dataAssertProvider = new DfDataAssertProvider(dataLoadingType);
                DfDataAssertHandler dataAssertHandler = dataAssertProvider.provideDataAssertHandler(sql);
                if (dataAssertHandler == null) {
                    return false;
                }
                dataAssertHandler.handle(sqlFile, st, sql);
                return true;
            }
        });
        return runnerExecute;
    }

    protected List<File> getTakeFinallySqlFileList() {
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.addAll(this.getTakeFinallyNextSqlFileList());
        fileList.addAll(this.getTakeFinallyNextSqlFileListAdditional());
        return fileList;
    }

    protected List<File> getTakeFinallyNextSqlFileList() {
        String path = this.getMyProperties().getReplaceSchemaPlaySqlDirectory();
        return this.doGetTakeFinallySqlFileList(path);
    }

    protected List<File> getTakeFinallyNextSqlFileListAdditional() {
        ArrayList<File> fileList = new ArrayList<File>();
        String path = this.getMyProperties().getApplicationPlaySqlDirectory();
        if (Srl.is_Null_or_TrimmedEmpty((String)path)) {
            return DfCollectionUtil.emptyList();
        }
        fileList.addAll(this.doGetTakeFinallySqlFileList(path));
        return fileList;
    }

    protected List<File> doGetTakeFinallySqlFileList(String directoryPath) {
        File baseDir = new File(directoryPath);
        final String fileNameWithoutExt = this.getTakeFinallySqlFileNameWithoutExt();
        final String sqlFileExt = this.getTakeFinallySqlFileExt();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(fileNameWithoutExt) && name.endsWith("." + sqlFileExt);
            }
        };
        Comparator<File> fileNameAscComparator = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        TreeSet<File> treeSet = new TreeSet<File>(fileNameAscComparator);
        String[] targetList = baseDir.list(filter);
        if (targetList == null) {
            return DfCollectionUtil.emptyList();
        }
        for (String targetFileName : targetList) {
            String targetFilePath = directoryPath + "/" + targetFileName;
            treeSet.add(new File(targetFilePath));
        }
        return new ArrayList<File>(treeSet);
    }

    protected String getTakeFinallySqlFileNameWithoutExt() {
        return this.getMyProperties().getTakeFinallySqlFileNameWithoutExt();
    }

    protected String getTakeFinallySqlFileExt() {
        return this.getMyProperties().getTakeFinallySqlFileExt();
    }

    protected void incrementSequenceToDataMax() {
        if (!this.getMyProperties().isIncrementSequenceToDataMax()) {
            return;
        }
        _log.info((Object)"");
        _log.info((Object)"* * * * * * * * * * **");
        _log.info((Object)"*                    *");
        _log.info((Object)"* Increment Sequence *");
        _log.info((Object)"*                    *");
        _log.info((Object)"* * * * * * * * * * **");
        DfSequenceIdentityProperties sequenceProp = this.getProperties().getSequenceIdentityProperties();
        Map<String, String> tableSequenceMap = sequenceProp.getTableSequenceMap();
        DfSequenceHandlerFactory factory = new DfSequenceHandlerFactory(this.getDataSource(), this.getBasicProperties(), this.getDatabaseProperties());
        DfSequenceHandler sequenceHandler = factory.createSequenceHandler();
        if (sequenceHandler == null) {
            String databaseType = this.getBasicProperties().getDatabaseType();
            String msg = "Unsupported isIncrementSequenceToDataMax at " + databaseType;
            throw new UnsupportedOperationException(msg);
        }
        sequenceHandler.incrementSequenceToDataMax(tableSequenceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void callbackProcess(String timing, String processCommand) {
        block18: {
            _log.info((Object)"");
            _log.info((Object)"* * * * * * * * * **");
            _log.info((Object)"*                  *");
            _log.info((Object)"* Process Callback *");
            _log.info((Object)"*                  *");
            _log.info((Object)"* * * * * * * * * **");
            _log.info((Object)("[" + timing + "]: begin --> " + processCommand));
            ProcessBuilder processBuilder = new ProcessBuilder(processCommand);
            InputStream stdIn = null;
            InputStream errIn = null;
            Process process = processBuilder.start();
            stdIn = process.getInputStream();
            errIn = process.getErrorStream();
            this.showConsole(stdIn);
            this.showConsole(errIn);
            int ret = process.waitFor();
            _log.info((Object)("[" + timing + "]: end(" + ret + ") --> " + processCommand));
            _log.info((Object)"");
            Object var10_10 = null;
            try {
                if (stdIn != null) {
                    stdIn.close();
                }
                if (errIn != null) {
                    errIn.close();
                }
                break block18;
            }
            catch (IOException ignored) {}
            break block18;
            {
                catch (IOException e) {
                    String msg = "Process Callback failed to execute: process=" + processCommand;
                    _log.warn((Object)(msg + " e.getMessage()=" + e.getMessage()));
                    Object var10_11 = null;
                    try {
                        if (stdIn != null) {
                            stdIn.close();
                        }
                        if (errIn != null) {
                            errIn.close();
                        }
                        break block18;
                    }
                    catch (IOException ignored) {}
                    break block18;
                }
                catch (InterruptedException e) {
                    String msg = "Process Callback failed to execute: process=" + processCommand;
                    _log.warn((Object)(msg + " e.getMessage()=" + e.getMessage()));
                    Object var10_12 = null;
                    try {
                        if (stdIn != null) {
                            stdIn.close();
                        }
                        if (errIn != null) {
                            errIn.close();
                        }
                        break block18;
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (stdIn != null) {
                        stdIn.close();
                    }
                    if (errIn != null) {
                        errIn.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void showConsole(InputStream ins) throws IOException {
        if (ins == null) {
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(ins));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + this.ln());
        }
        _log.info((Object)sb.toString().trim());
    }

    @Override
    protected String getFinalInformation() {
        return this.buildFinalInformation(this.takeFinallyResult);
    }

    protected String buildFinalInformation(DfSqlFileFireMan.FireResult result) {
        File file = new File("./log/create-schema.log");
        if (!file.exists()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean firstDone = false;
        boolean failure = false;
        CreateSchemaFinalInfo createSchemaFinalInfo = this.buildCreateSchemaFinalInfo();
        if (createSchemaFinalInfo != null) {
            if (firstDone) {
                sb.append(this.ln()).append(this.ln());
            } else {
                firstDone = true;
            }
            sb.append(createSchemaFinalInfo.getMessage());
            if (createSchemaFinalInfo.isFailure()) {
                failure = true;
            }
        }
        if (result != null) {
            if (firstDone) {
                sb.append(this.ln()).append(this.ln());
            } else {
                firstDone = true;
            }
            sb.append(" ").append(result.getResultMessage());
            String detailMessage = result.getDetailMessage();
            if (detailMessage != null && detailMessage.trim().length() > 0) {
                LineTokenImpl lineToken = new LineTokenImpl();
                LineTokenizingOption lineTokenizingOption = new LineTokenizingOption();
                lineTokenizingOption.setDelimiter(this.ln());
                List tokenizedList = lineToken.tokenize(detailMessage, lineTokenizingOption);
                for (String tokenizedElement : tokenizedList) {
                    sb.append(this.ln()).append("  ").append(tokenizedElement);
                }
            }
            if (result.isExistsError()) {
                failure = true;
            }
        } else {
            failure = true;
        }
        if (failure) {
            sb.append(this.ln()).append("    * * * * * *");
            sb.append(this.ln()).append("    * Failure *");
            sb.append(this.ln()).append("    * * * * * *");
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CreateSchemaFinalInfo buildCreateSchemaFinalInfo() {
        block22: {
            block20: {
                block18: {
                    block19: {
                        file = new File("./log/create-schema.log");
                        if (!file.exists()) {
                            return null;
                        }
                        br = null;
                        try {
                            try {
                                fis = new FileInputStream(file);
                                br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                                line = br.readLine();
                                if (line == null) {
                                    var5_8 = null;
                                    var11_10 = null;
                                    if (br == null) break block18;
                                    break block19;
                                }
                                line2 = br.readLine();
                                detailList = new ArrayList<String>();
                                if (line2 != null) {
                                    while ((line3 = br.readLine()) != null) {
                                        detailList.add(line3);
                                    }
                                }
                                sb = new StringBuilder();
                                sb.append(this.ln()).append(" ").append(line);
                                for (String detail : detailList) {
                                    sb.append(this.ln()).append("  ").append(detail);
                                }
                                info = new CreateSchemaFinalInfo();
                                info.setMessage(sb.toString());
                                info.setFailure(this.isLine2True(line2));
                                var9_22 = info;
                                break block20;
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new IllegalStateException(e);
                            }
                            catch (FileNotFoundException e) {
                                throw new IllegalStateException(e);
                            }
                            catch (IOException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                        catch (Throwable var10_23) {
                            var11_12 = null;
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException ignored) {
                                    // empty catch block
                                }
                            }
                            if (file.exists() == false) throw var10_23;
                            deleted = file.delete();
                            if (deleted != false) throw var10_23;
                            throw var10_23;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [9 : 282->289)] { 
lbl58:
                    // 1 sources

                    br.close();
                    break block18;
lbl60:
                    // 1 sources

                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                if (file.exists() == false) return var5_8;
                deleted = file.delete();
                if (deleted != false) return var5_8;
                return var5_8;
            }
            var11_11 = null;
            if (br != null) {
                ** try [egrp 2[TRYBLOCK] [9 : 282->289)] { 
lbl71:
                // 1 sources

                br.close();
                break block22;
lbl73:
                // 1 sources

                catch (IOException ignored) {
                    // empty catch block
                }
            }
        }
        if (file.exists() == false) return var9_22;
        deleted = file.delete();
        if (deleted != false) return var9_22;
        return var9_22;
    }

    protected boolean isLine2True(String line2) {
        return line2 != null && line2.trim().equalsIgnoreCase("true");
    }

    public void setBeforeTimestamp(String beforeTimestamp) {
        try {
            this.beforeTimestamp = Timestamp.valueOf(beforeTimestamp);
        }
        catch (RuntimeException ignored) {
            _log.warn((Object)("Wrong beforeTimestampExpression: " + beforeTimestamp), (Throwable)ignored);
        }
    }

    protected static class CreateSchemaFinalInfo {
        protected String _message;
        protected boolean _failure;

        protected CreateSchemaFinalInfo() {
        }

        public String getMessage() {
            return this._message;
        }

        public void setMessage(String message) {
            this._message = message;
        }

        public boolean isFailure() {
            return this._failure;
        }

        public void setFailure(boolean failure) {
            this._failure = failure;
        }
    }

    public static class DfReplaceSchemaProcessCallbackException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DfReplaceSchemaProcessCallbackException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

