/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task.bs;

import java.io.File;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.Task;
import org.apache.torque.engine.database.model.UnifiedSchema;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.DfBuildProperties;
import org.seasar.dbflute.config.DfEnvironmentType;
import org.seasar.dbflute.helper.jdbc.connection.DfConnectionMetaInfo;
import org.seasar.dbflute.helper.jdbc.connection.DfDataSourceHandler;
import org.seasar.dbflute.helper.jdbc.context.DfDataSourceContext;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.logic.DfDBFluteTaskUtil;
import org.seasar.dbflute.logic.jdbc.connection.DfCurrentSchemaConnector;
import org.seasar.dbflute.logic.sql2entity.outsidesql.DfSqlFileCollector;
import org.seasar.dbflute.properties.DfBasicProperties;
import org.seasar.dbflute.properties.DfDatabaseProperties;
import org.seasar.dbflute.properties.DfRefreshProperties;
import org.seasar.dbflute.properties.DfReplaceSchemaProperties;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DfAbstractTask
extends Task {
    private static final Log _log = LogFactory.getLog(DfAbstractTask.class);
    protected String _driver;
    protected String _url;
    protected UnifiedSchema _mainSchema;
    protected String _userId;
    protected String _password;
    protected Properties _connectionProperties;
    protected final DfDataSourceHandler _dataSourceHandler = new DfDataSourceHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void execute() {
        long before;
        Throwable cause;
        block45: {
            cause = null;
            before = this.getTaskBeforeTimeMillis();
            this.initializeDatabaseInfo();
            if (this.isUseDataSource()) {
                this.setupDataSource();
            }
            this.initializeVariousEnvironment();
            this.doExecute();
            Object var7_3 = null;
            if (!this.isUseDataSource()) break block45;
            this.commitDataSource();
            Object var10_7 = null;
            try {
                this.destroyDataSource();
            }
            catch (Exception ignored2) {
                _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
            }
            break block45;
            {
                catch (Exception ignored) {
                    Object var10_8 = null;
                    try {
                        this.destroyDataSource();
                    }
                    catch (Exception ignored2) {
                        _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                    }
                    break block45;
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                try {
                    this.destroyDataSource();
                    throw throwable;
                }
                catch (Exception ignored2) {
                    _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                }
                throw throwable;
            }
        }
        if (this.isValidTaskEndInformation() || cause != null) {
            try {
                long after = this.getTaskAfterTimeMillis();
                this.showFinalMessage(before, after, cause != null);
            }
            catch (RuntimeException e2) {
                _log.info((Object)"*Failed to show final message!", (Throwable)e2);
            }
        }
        if (cause == null) return;
        this.throwTaskFailure();
        {
            return;
            catch (Exception e) {
                block47: {
                    cause = e;
                    try {
                        this.logException(e);
                    }
                    catch (Throwable ignored) {
                        _log.warn((Object)"*Ignored exception occured!", ignored);
                        _log.error((Object)"*Failed to execute DBFlute Task!", (Throwable)e);
                    }
                    Object var7_4 = null;
                    if (this.isUseDataSource()) {
                        this.commitDataSource();
                        Object var10_10 = null;
                        try {
                            this.destroyDataSource();
                        }
                        catch (Exception ignored2) {
                            _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                        }
                        break block47;
                        {
                            catch (Exception ignored) {
                                Object var10_11 = null;
                                try {
                                    this.destroyDataSource();
                                }
                                catch (Exception ignored2) {
                                    _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                                }
                                break block47;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_12 = null;
                            try {
                                this.destroyDataSource();
                                throw throwable;
                            }
                            catch (Exception ignored2) {
                                _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                            }
                            throw throwable;
                        }
                    }
                }
                if (this.isValidTaskEndInformation() || cause != null) {
                    try {
                        long after = this.getTaskAfterTimeMillis();
                        this.showFinalMessage(before, after, cause != null);
                    }
                    catch (RuntimeException e2) {
                        _log.info((Object)"*Failed to show final message!", (Throwable)e2);
                    }
                }
                if (cause == null) return;
                this.throwTaskFailure();
                return;
            }
            catch (Error e) {
                block49: {
                    cause = e;
                    try {
                        this.logError(e);
                    }
                    catch (Throwable ignored) {
                        _log.warn((Object)"*Ignored exception occured!", ignored);
                        _log.error((Object)"*Failed to execute DBFlute Task!", (Throwable)e);
                    }
                    Object var7_5 = null;
                    if (this.isUseDataSource()) {
                        this.commitDataSource();
                        Object var10_13 = null;
                        try {
                            this.destroyDataSource();
                        }
                        catch (Exception ignored2) {
                            _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                        }
                        break block49;
                        {
                            catch (Exception ignored) {
                                Object var10_14 = null;
                                try {
                                    this.destroyDataSource();
                                }
                                catch (Exception ignored2) {
                                    _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                                }
                                break block49;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_15 = null;
                            try {
                                this.destroyDataSource();
                                throw throwable;
                            }
                            catch (Exception ignored2) {
                                _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                            }
                            throw throwable;
                        }
                    }
                }
                if (this.isValidTaskEndInformation() || cause != null) {
                    try {
                        long after = this.getTaskAfterTimeMillis();
                        this.showFinalMessage(before, after, cause != null);
                    }
                    catch (RuntimeException e2) {
                        _log.info((Object)"*Failed to show final message!", (Throwable)e2);
                    }
                }
                if (cause == null) return;
                this.throwTaskFailure();
                return;
            }
        }
        catch (Throwable throwable) {
            block51: {
                Object var7_6 = null;
                if (this.isUseDataSource()) {
                    this.commitDataSource();
                    Object var10_16 = null;
                    try {
                        this.destroyDataSource();
                    }
                    catch (Exception ignored2) {
                        _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                    }
                    break block51;
                    {
                        catch (Exception ignored) {
                            Object var10_17 = null;
                            try {
                                this.destroyDataSource();
                            }
                            catch (Exception ignored2) {
                                _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        Object var10_18 = null;
                        try {
                            this.destroyDataSource();
                            throw throwable2;
                        }
                        catch (Exception ignored2) {
                            _log.warn((Object)("*Failed to destroy data source: " + ignored2.getMessage()));
                        }
                        throw throwable2;
                    }
                }
            }
            if (this.isValidTaskEndInformation() || cause != null) {
                try {
                    long after = this.getTaskAfterTimeMillis();
                    this.showFinalMessage(before, after, cause != null);
                }
                catch (RuntimeException e2) {
                    _log.info((Object)"*Failed to show final message!", (Throwable)e2);
                }
            }
            if (cause == null) throw throwable;
            this.throwTaskFailure();
            throw throwable;
        }
    }

    protected long getTaskBeforeTimeMillis() {
        return System.currentTimeMillis();
    }

    protected long getTaskAfterTimeMillis() {
        return System.currentTimeMillis();
    }

    protected void logException(Exception e) {
        DfDBFluteTaskUtil.logException(e, this.getDisplayTaskName(), this.getConnectionMetaInfo());
    }

    protected void logError(Error e) {
        DfDBFluteTaskUtil.logError(e, this.getDisplayTaskName(), this.getConnectionMetaInfo());
    }

    protected boolean isValidTaskEndInformation() {
        return true;
    }

    protected void showFinalMessage(long before, long after, boolean abort) {
        String environmentType = DfEnvironmentType.getInstance().getEnvironmentType();
        StringBuilder sb = new StringBuilder();
        String ln = this.ln();
        sb.append(ln);
        sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
        sb.append(ln).append("[Task End]: ").append(this.getPerformanceView(after - before));
        if (abort) {
            sb.append(" *Abort");
        }
        sb.append(ln);
        DfConnectionMetaInfo metaInfo = this.getConnectionMetaInfo();
        String productDisp = metaInfo != null ? " (" + metaInfo.getProductDisp() + ")" : "";
        String databaseType = this.getBasicProperties().getDatabaseType() + productDisp;
        sb.append(ln).append("  DBFLUTE_CLIENT: {" + this.getBasicProperties().getProjectName() + "}");
        sb.append(ln).append("    database  = " + databaseType);
        sb.append(ln).append("    language  = " + this.getBasicProperties().getTargetLanguage());
        sb.append(ln).append("    container = " + this.getBasicProperties().getTargetContainerName());
        sb.append(ln).append("    package   = " + this.getBasicProperties().getPackageBase());
        sb.append(ln);
        sb.append(ln).append("  DBFLUTE_ENVIRONMENT_TYPE: {" + environmentType + "}");
        sb.append(ln).append("    driver = " + this._driver);
        sb.append(ln).append("    url    = " + this._url);
        sb.append(ln).append("    schema = " + this._mainSchema);
        sb.append(ln).append("    user   = " + this._userId);
        sb.append(ln).append("    props  = " + this._connectionProperties);
        String additionalSchemaDisp = this.buildAdditionalSchemaDisp();
        sb.append(ln).append("    additionalSchema = " + additionalSchemaDisp);
        DfReplaceSchemaProperties replaceSchemaProp = this.getProperties().getReplaceSchemaProperties();
        sb.append(ln).append("    dataLoadingType  = " + replaceSchemaProp.getDataLoadingType());
        String refreshProjectDisp = this.buildRefreshProjectDisp();
        sb.append(ln).append("    refreshProject   = " + refreshProjectDisp);
        String finalInformation = this.getFinalInformation();
        if (finalInformation != null) {
            sb.append(ln);
            sb.append(finalInformation);
        }
        sb.append(ln).append("_/_/_/_/_/_/_/_/_/_/ {" + this.getDisplayTaskName() + "}");
        _log.info((Object)sb.toString());
    }

    private String buildAdditionalSchemaDisp() {
        String disp;
        DfDatabaseProperties databaseProp = this.getDatabaseProperties();
        List<UnifiedSchema> additionalSchemaList = databaseProp.getAdditionalSchemaList();
        if (additionalSchemaList.size() == 1) {
            String identifiedSchema;
            UnifiedSchema unifiedSchema = additionalSchemaList.get(0);
            disp = identifiedSchema = unifiedSchema.getIdentifiedSchema();
            if (unifiedSchema.isCatalogAdditionalSchema()) {
                disp = disp + "(catalog)";
            } else if (unifiedSchema.isMainSchema()) {
                disp = disp + "(main)";
            } else if (unifiedSchema.isUnknownSchema()) {
                disp = disp + "(unknown)";
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (UnifiedSchema unifiedSchema : additionalSchemaList) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                String identifiedSchema = unifiedSchema.getIdentifiedSchema();
                sb.append(identifiedSchema);
                if (unifiedSchema.isCatalogAdditionalSchema()) {
                    sb.append("(catalog)");
                    continue;
                }
                if (unifiedSchema.isMainSchema()) {
                    sb.append("(main)");
                    continue;
                }
                if (!unifiedSchema.isUnknownSchema()) continue;
                sb.append("(unknown)");
            }
            disp = sb.toString();
        }
        return disp;
    }

    private String buildRefreshProjectDisp() {
        String disp;
        DfRefreshProperties refreshProp = this.getProperties().getRefreshProperties();
        if (!refreshProp.hasRefreshDefinition()) {
            return "";
        }
        List<String> refreshProjectList = refreshProp.getProjectNameList();
        if (refreshProjectList.size() == 1) {
            disp = refreshProjectList.get(0);
        } else {
            StringBuilder sb = new StringBuilder();
            for (String refreshProject : refreshProjectList) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(refreshProject);
            }
            disp = sb.toString();
        }
        return disp;
    }

    protected String getDisplayTaskName() {
        String taskName = this.getTaskName();
        return DfDBFluteTaskUtil.getDisplayTaskName(taskName);
    }

    protected String getFinalInformation() {
        return null;
    }

    protected void throwTaskFailure() {
        DfDBFluteTaskUtil.throwTaskFailure(this.getDisplayTaskName());
    }

    protected void initializeDatabaseInfo() {
        this._driver = this.getDatabaseProperties().getDatabaseDriver();
        this._url = this.getDatabaseProperties().getDatabaseUrl();
        this._userId = this.getDatabaseProperties().getDatabaseUser();
        this._mainSchema = this.getDatabaseProperties().getDatabaseSchema();
        this._password = this.getDatabaseProperties().getDatabasePassword();
        this._connectionProperties = this.getDatabaseProperties().getDatabaseConnectionProperties();
    }

    protected void initializeVariousEnvironment() {
        if (this.getBasicProperties().isDatabaseOracle()) {
            DBDef currentDBDef = ResourceContext.currentDBDef();
            TnValueTypes.registerBasicValueType((DBDef)currentDBDef, Date.class, (ValueType)TnValueTypes.UTILDATE_AS_TIMESTAMP);
        }
    }

    protected abstract void doExecute();

    protected String getPerformanceView(long mil) {
        if (mil < 0L) {
            return String.valueOf(mil);
        }
        long sec = mil / 1000L;
        long min = sec / 60L;
        sec %= 60L;
        mil %= 1000L;
        StringBuffer sb = new StringBuffer();
        if (min >= 10L) {
            sb.append(min).append("m");
        } else if (min < 10L && min >= 0L) {
            sb.append("0").append(min).append("m");
        }
        if (sec >= 10L) {
            sb.append(sec).append("s");
        } else if (sec < 10L && sec >= 0L) {
            sb.append("0").append(sec).append("s");
        }
        if (mil >= 100L) {
            sb.append(mil).append("ms");
        } else if (mil < 100L && mil >= 10L) {
            sb.append("0").append(mil).append("ms");
        } else if (mil < 10L && mil >= 0L) {
            sb.append("00").append(mil).append("ms");
        }
        return sb.toString();
    }

    protected abstract boolean isUseDataSource();

    protected void setupDataSource() throws SQLException {
        this._dataSourceHandler.setUserId(this._userId);
        this._dataSourceHandler.setPassword(this._password);
        this._dataSourceHandler.setDriver(this._driver);
        this._dataSourceHandler.setUrl(this._url);
        this._dataSourceHandler.setConnectionProperties(this._connectionProperties);
        this._dataSourceHandler.setAutoCommit(true);
        this._dataSourceHandler.create();
        this.connectSchema();
    }

    protected void commitDataSource() throws SQLException {
        this._dataSourceHandler.commit();
    }

    protected void destroyDataSource() throws SQLException {
        this._dataSourceHandler.destroy();
        if (this.getBasicProperties().isDatabaseDerby()) {
            DfDBFluteTaskUtil.shutdownIfDerbyEmbedded(this._driver);
        }
    }

    protected DataSource getDataSource() {
        return DfDataSourceContext.getDataSource();
    }

    protected void connectSchema() throws SQLException {
        DfCurrentSchemaConnector connector = new DfCurrentSchemaConnector(this._mainSchema, this.getBasicProperties());
        connector.connectSchema(this.getDataSource());
    }

    protected DfConnectionMetaInfo getConnectionMetaInfo() {
        return this._dataSourceHandler.getConnectionMetaInfo();
    }

    public void setContextProperties(String file) {
        try {
            Properties prop = DfDBFluteTaskUtil.getBuildProperties(file, this.getProject());
            DfBuildProperties.getInstance().setProperties(prop);
        }
        catch (RuntimeException e) {
            String msg = "Failed to set context properties:";
            msg = msg + " file=" + file;
            _log.warn((Object)msg, (Throwable)e);
            throw e;
        }
    }

    protected DfBuildProperties getProperties() {
        return DfBuildProperties.getInstance();
    }

    protected DfBasicProperties getBasicProperties() {
        return this.getProperties().getBasicProperties();
    }

    protected DfDatabaseProperties getDatabaseProperties() {
        return this.getProperties().getDatabaseProperties();
    }

    protected List<File> collectSqlFileList() {
        String sqlDirectory = this.getProperties().getOutsideSqlProperties().getSqlDirectory();
        DfSqlFileCollector sqlFileCollector = new DfSqlFileCollector(sqlDirectory, this.getBasicProperties());
        return sqlFileCollector.collectSqlFileList();
    }

    protected String ln() {
        return "\n";
    }

    public void setEnvironmentType(String environmentType) {
        DfEnvironmentType.getInstance().setEnvironmentType(environmentType);
    }
}

