/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.mapping;

import java.util.Map;
import org.apache.torque.engine.database.model.TypeMap;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfJdbcTypeMapper {
    protected Map<String, String> _nameToJdbcTypeMap;
    protected Resource _resource;

    public DfJdbcTypeMapper(Map<String, String> nameToJdbcTypeMap, Resource resource) {
        this._nameToJdbcTypeMap = nameToJdbcTypeMap;
        this._resource = resource;
    }

    public String getColumnJdbcType(int jdbcDefType, String dbTypeName) {
        String jdbcType = this.doGetColumnJdbcType(jdbcDefType, dbTypeName);
        if (jdbcType == null) {
            return this.getVarcharJdbcType();
        }
        return jdbcType;
    }

    public boolean hasMappingJdbcType(int jdbcDefType, String dbTypeName) {
        return this.doGetColumnJdbcType(jdbcDefType, dbTypeName) != null;
    }

    public String doGetColumnJdbcType(int jdbcDefType, String dbTypeName) {
        String jdbcType;
        String torqueType;
        if (dbTypeName != null && this._nameToJdbcTypeMap != null && !this._nameToJdbcTypeMap.isEmpty() && (torqueType = this._nameToJdbcTypeMap.get(dbTypeName)) != null) {
            return torqueType;
        }
        String adjustment = this.processForcedAdjustment(jdbcDefType, dbTypeName);
        if (adjustment != null) {
            return adjustment;
        }
        if (!this.isOtherType(jdbcDefType) && Srl.is_NotNull_and_NotEmpty((String)(jdbcType = this.getJdbcType(jdbcDefType)))) {
            return jdbcType;
        }
        if (this.containsIgnoreCase(dbTypeName, "varchar")) {
            return this.getVarcharJdbcType();
        }
        if (this.containsIgnoreCase(dbTypeName, "char")) {
            return this.getCharJdbcType();
        }
        if (this.containsIgnoreCase(dbTypeName, "numeric", "number", "decimal")) {
            return this.getNumericJdbcType();
        }
        if (this.containsIgnoreCase(dbTypeName, "timestamp", "datetime")) {
            return this.getTimestampJdbcType();
        }
        if (this.containsIgnoreCase(dbTypeName, "date")) {
            return this.getDateJdbcType();
        }
        if (this.containsIgnoreCase(dbTypeName, "time")) {
            return this.getTimeJdbcType();
        }
        if (this.containsIgnoreCase(dbTypeName, "clob")) {
            return this.getClobJdbcType();
        }
        return null;
    }

    protected String processForcedAdjustment(int jdbcDefValue, String dbTypeName) {
        if (this.isConceptTypeUUID(dbTypeName) && this._resource.isLangJava()) {
            return "UUID";
        }
        if (this.isConceptTypeBytesOid(dbTypeName)) {
            return this.getBlobJdbcType();
        }
        if (this.isPostgreSQLInterval(dbTypeName)) {
            return this.getTimeJdbcType();
        }
        if (this.isOracleCompatibleDate(jdbcDefValue, dbTypeName)) {
            return this.getDateJdbcType();
        }
        return null;
    }

    public boolean isConceptTypeUUID(String dbTypeName) {
        if (this.isPostgreSQLUuid(dbTypeName)) {
            return true;
        }
        return this.isSQLServerUniqueIdentifier(dbTypeName);
    }

    public boolean isConceptTypeStringClob(String dbTypeName) {
        return this.isOracleClob(dbTypeName);
    }

    public boolean isConceptTypeBytesOid(String dbTypeName) {
        return this.isPostgreSQLOid(dbTypeName);
    }

    public boolean isConceptTypeFixedLengthString(String dbTypeName) {
        return this.isPostgreSQLBpChar(dbTypeName);
    }

    public boolean isConceptTypeObjectBindingBigDecimal(String dbTypeName) {
        return this.isPostgreSQLNumeric(dbTypeName);
    }

    public boolean isPostgreSQLBpChar(String dbTypeName) {
        return this._resource.isDbmsPostgreSQL() && this.matchIgnoreCase(dbTypeName, "bpchar");
    }

    public boolean isPostgreSQLNumeric(String dbTypeName) {
        return this._resource.isDbmsPostgreSQL() && this.matchIgnoreCase(dbTypeName, "numeric");
    }

    public boolean isPostgreSQLUuid(String dbTypeName) {
        return this._resource.isDbmsPostgreSQL() && this.matchIgnoreCase(dbTypeName, "uuid");
    }

    public boolean isPostgreSQLOid(String dbTypeName) {
        return this._resource.isDbmsPostgreSQL() && this.matchIgnoreCase(dbTypeName, "oid");
    }

    public boolean isPostgreSQLInterval(String dbTypeName) {
        return this._resource.isDbmsPostgreSQL() && this.matchIgnoreCase(dbTypeName, "interval");
    }

    public boolean isPostgreSQLCursor(String dbTypeName) {
        return this._resource.isDbmsPostgreSQL() && this.containsIgnoreCase(dbTypeName, "cursor");
    }

    public boolean isOracleClob(String dbTypeName) {
        return this._resource.isDbmsOracle() && this.containsIgnoreCase(dbTypeName, "clob");
    }

    public boolean isOracleNCharOrNVarchar(String dbTypeName) {
        return this._resource.isDbmsOracle() && this.containsIgnoreCase(dbTypeName, "nchar", "nvarchar");
    }

    public boolean isOracleNCharOrNVarcharOrNClob(String dbTypeName) {
        return this._resource.isDbmsOracle() && this.containsIgnoreCase(dbTypeName, "nchar", "nvarchar", "nclob");
    }

    public boolean isOracleNumber(String dbTypeName) {
        return this._resource.isDbmsOracle() && this.matchIgnoreCase(dbTypeName, "number");
    }

    public boolean isOracleDate(String dbTypeName) {
        return this._resource.isDbmsOracle() && this.matchIgnoreCase(dbTypeName, "date");
    }

    public boolean isOracleCompatibleDate(int jdbcType, String dbTypeName) {
        return this._resource.isDbmsOracle() && 93 == jdbcType && this.matchIgnoreCase(dbTypeName, "date");
    }

    public boolean isOracleBinaryFloatDouble(String dbTypeName) {
        return this._resource.isDbmsOracle() && this.matchIgnoreCase(dbTypeName, "binary_float", "binary_double");
    }

    public boolean isOracleCursor(String dbTypeName) {
        return this._resource.isDbmsOracle() && this.containsIgnoreCase(dbTypeName, "cursor");
    }

    public boolean isOracleTable(String dbTypeName) {
        return this._resource.isDbmsOracle() && this.containsIgnoreCase(dbTypeName, "table");
    }

    public boolean isOracleVArray(String dbTypeName) {
        return this._resource.isDbmsOracle() && this.containsIgnoreCase(dbTypeName, "varray");
    }

    public boolean isSQLServerUniqueIdentifier(String dbTypeName) {
        return this._resource.isDbmsSQLServer() && this.matchIgnoreCase(dbTypeName, "uniqueidentifier");
    }

    protected boolean isOtherType(int jdbcDefValue) {
        return 1111 == jdbcDefValue;
    }

    protected String getJdbcType(int jdbcDefValue) {
        return TypeMap.findJdbcTypeByJdbcDefValue(jdbcDefValue);
    }

    protected String getVarcharJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(12);
    }

    protected String getCharJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(1);
    }

    protected String getNumericJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(2);
    }

    protected String getTimestampJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(93);
    }

    protected String getTimeJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(92);
    }

    protected String getDateJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(91);
    }

    protected String getClobJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(2005);
    }

    protected String getBlobJdbcType() {
        return TypeMap.findJdbcTypeByJdbcDefValue(2004);
    }

    protected boolean matchIgnoreCase(String dbTypeName, String ... types) {
        if (dbTypeName == null) {
            return false;
        }
        for (String type : types) {
            if (!dbTypeName.trim().equalsIgnoreCase(type.trim())) continue;
            return true;
        }
        return false;
    }

    protected boolean containsIgnoreCase(String dbTypeName, String ... types) {
        if (dbTypeName == null) {
            return false;
        }
        String trimmedLowerName = dbTypeName.toLowerCase().trim();
        for (String type : types) {
            if (!trimmedLowerName.contains(type.toLowerCase().trim())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this._nameToJdbcTypeMap + ":" + this._resource;
    }

    public static interface Resource {
        public boolean isLangJava();

        public boolean isDbmsPostgreSQL();

        public boolean isDbmsOracle();

        public boolean isDbmsSQLServer();
    }
}

