/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.jdbc.facade;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.jdbc.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfJdbcFacade {
    private static final Log _log = LogFactory.getLog(DfJdbcFacade.class);
    protected final DataSource _dataSource;
    protected final Connection _conn;
    protected final boolean _closeConnection;

    public DfJdbcFacade(DataSource dataSource) {
        this._dataSource = dataSource;
        this._conn = null;
        this._closeConnection = true;
    }

    public DfJdbcFacade(Connection conn) {
        this(conn, false);
    }

    public DfJdbcFacade(Connection conn, boolean closeConnection) {
        this._dataSource = null;
        this._conn = conn;
        this._closeConnection = closeConnection;
    }

    public List<Map<String, Object>> selectList(String sql, Map<String, ValueType> columnValueTypeMap) {
        return this.selectList(sql, columnValueTypeMap, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> selectList(String sql, Map<String, ValueType> columnValueTypeMap, int limit) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            try {
                conn = this.getConnection();
                st = conn.createStatement();
                rs = st.executeQuery(sql);
                for (int count = 0; rs.next() && (limit < 0 || limit > count); ++count) {
                    StringKeyMap recordMap = StringKeyMap.createAsFlexibleOrdered();
                    Set<Map.Entry<String, ValueType>> entrySet = columnValueTypeMap.entrySet();
                    for (Map.Entry<String, ValueType> entry : entrySet) {
                        String columnName = entry.getKey();
                        ValueType valueType = entry.getValue();
                        recordMap.put(columnName, valueType.getValue(rs, columnName));
                    }
                    resultList.add((Map<String, Object>)recordMap);
                }
                Object var16_17 = null;
                this.closeResultSet(rs);
                this.closeStatement(st);
                this.closeConnection(conn);
            }
            catch (SQLException e) {
                this.handleSQLException(sql, e);
                List<Map<String, Object>> list = null;
                Object var16_18 = null;
                this.closeResultSet(rs);
                this.closeStatement(st);
                this.closeConnection(conn);
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            this.closeResultSet(rs);
            this.closeStatement(st);
            this.closeConnection(conn);
            throw throwable;
        }
        return resultList;
    }

    public List<Map<String, String>> selectStringList(String sql, List<String> columnList) {
        return this.selectStringList(sql, columnList, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> selectStringList(String sql, List<String> columnList, int limit) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            try {
                conn = this.getConnection();
                st = conn.createStatement();
                rs = st.executeQuery(sql);
                for (int count = 0; rs.next() && (limit < 0 || limit > count); ++count) {
                    LinkedHashMap<String, String> recordMap = new LinkedHashMap<String, String>();
                    for (String columnName : columnList) {
                        recordMap.put(columnName, rs.getString(columnName));
                    }
                    resultList.add(recordMap);
                }
                Object var13_14 = null;
                this.closeResultSet(rs);
                this.closeStatement(st);
                this.closeConnection(conn);
            }
            catch (SQLException e) {
                this.handleSQLException(sql, e);
                List<Map<String, String>> list = null;
                Object var13_15 = null;
                this.closeResultSet(rs);
                this.closeStatement(st);
                this.closeConnection(conn);
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.closeResultSet(rs);
            this.closeStatement(st);
            this.closeConnection(conn);
            throw throwable;
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) {
        Connection conn = null;
        Statement st = null;
        try {
            conn = this.getConnection();
            st = conn.createStatement();
            boolean bl = st.execute(sql);
            Object var7_6 = null;
            this.closeStatement(st);
            this.closeConnection(conn);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.handleSQLException(sql, e);
                boolean bl = false;
                Object var7_7 = null;
                this.closeStatement(st);
                this.closeConnection(conn);
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.closeStatement(st);
                this.closeConnection(conn);
                throw throwable;
            }
        }
    }

    protected Connection getConnection() throws SQLException {
        if (this._dataSource != null) {
            return this._dataSource.getConnection();
        }
        return this._conn;
    }

    protected void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ignored) {
                _log.info((Object)"ResultSet.close() threw the exception!", (Throwable)ignored);
            }
        }
    }

    protected void closeStatement(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException ignored) {
                _log.info((Object)"Statement.close() threw the exception!", (Throwable)ignored);
            }
        }
    }

    protected void closeConnection(Connection conn) {
        if (conn != null && this._closeConnection) {
            try {
                conn.close();
            }
            catch (SQLException ignored) {
                _log.info((Object)"Connection.close() threw the exception!", (Throwable)ignored);
            }
        }
    }

    protected void handleSQLException(String sql, SQLException e) {
        String msg = "Failed to execute the SQL:" + this.ln();
        msg = msg + "/- - - - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "[SQL]" + this.ln() + sql + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Exception]" + this.ln();
        msg = msg + e.getClass() + this.ln();
        msg = msg + e.getMessage() + this.ln();
        msg = msg + "- - - - - - - - - -/";
        throw new SQLFailureException(msg, e);
    }

    protected String ln() {
        return "\n";
    }
}

