/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.task;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.config.DfSpecifiedSqlFile;
import org.seasar.dbflute.helper.jdbc.DfRunnerInformation;
import org.seasar.dbflute.helper.jdbc.sqlfile.DfSqlFileRunnerExecute;
import org.seasar.dbflute.logic.sql2entity.outsidesql.DfOutsideSqlChecker;
import org.seasar.dbflute.properties.DfOutsideSqlProperties;
import org.seasar.dbflute.task.bs.DfAbstractSqlExecutionTask;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfOutsideSqlTestTask
extends DfAbstractSqlExecutionTask {
    private static final Log _log = LogFactory.getLog(DfOutsideSqlTestTask.class);
    protected int _nonTargetSqlCount;

    @Override
    protected void doExecute() {
        super.doExecute();
    }

    @Override
    protected List<File> getTargetSqlFileList() {
        List<File> sqlFileList = this.collectSqlFileList();
        String specifiedSqlFile = DfSpecifiedSqlFile.getInstance().getSpecifiedSqlFile();
        if (specifiedSqlFile != null) {
            ArrayList<File> filteredList = new ArrayList<File>();
            for (File sqlFile : sqlFileList) {
                String fileName = sqlFile.getName();
                if (!specifiedSqlFile.equals(fileName)) continue;
                filteredList.add(sqlFile);
            }
            return filteredList;
        }
        return sqlFileList;
    }

    @Override
    protected DfSqlFileRunnerExecute getSqlFileRunner(DfRunnerInformation runInfo) {
        final DBDef currentDBDef = this.getBasicProperties().getCurrentDBDef();
        return new DfSqlFileRunnerExecute(runInfo, this.getDataSource()){

            @Override
            protected String filterSql(String sql) {
                DfOutsideSqlTestTask.this.checkParameterComment(this._sqlFile, sql);
                if (!currentDBDef.dbway().isBlockCommentSupported()) {
                    sql = this.removeBlockComment(sql);
                }
                if (!currentDBDef.dbway().isLineCommentSupported()) {
                    sql = this.removeLineComment(sql);
                }
                return super.filterSql(sql);
            }

            protected String removeBlockComment(String sql) {
                return Srl.removeBlockComment((String)sql);
            }

            protected String removeLineComment(String sql) {
                return Srl.removeLineComment((String)sql);
            }

            @Override
            protected boolean isTargetSql(String sql) {
                String entityName = this.getEntityName(sql);
                if (entityName != null && "df:x".equalsIgnoreCase(entityName)) {
                    ++DfOutsideSqlTestTask.this._nonTargetSqlCount;
                    return false;
                }
                return super.isTargetSql(sql);
            }

            @Override
            protected void traceSql(String sql) {
                String msg = this.ln() + "";
                msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * " + this.ln();
                msg = msg + sql + this.ln();
                msg = msg + "* * * * * * * * * */";
                _log.info((Object)msg);
            }

            @Override
            protected void traceResult(int goodSqlCount, int totalSqlCount) {
                _log.info((Object)("  --> success=" + goodSqlCount + " failure=" + (totalSqlCount - goodSqlCount) + this.ln()));
            }

            @Override
            protected boolean isSqlTrimAndRemoveLineSeparator() {
                return false;
            }

            protected String getEntityName(String sql) {
                return this.getTargetString(sql, "#");
            }

            protected String getTargetString(String sql, String mark) {
                List<String> targetList = this.getTargetList(sql, mark);
                return !targetList.isEmpty() ? targetList.get(0) : null;
            }

            protected List<String> getTargetList(String sql, String mark) {
                if (sql == null || sql.trim().length() == 0) {
                    String msg = "The sql is invalid: " + sql;
                    throw new IllegalArgumentException(msg);
                }
                List<String> betweenBeginEndMarkList = this.getListBetweenBeginEndMark(sql, "--" + mark, mark);
                if (!betweenBeginEndMarkList.isEmpty()) {
                    return betweenBeginEndMarkList;
                }
                return this.getListBetweenBeginEndMark(sql, "-- " + mark, mark);
            }

            protected List<String> getListBetweenBeginEndMark(String targetStr, String beginMark, String endMark) {
                List scopeList = Srl.extractScopeList((String)targetStr, (String)beginMark, (String)endMark);
                List resultList = DfCollectionUtil.newArrayList();
                for (Srl.ScopeInfo scope : scopeList) {
                    resultList.add(scope.getContent());
                }
                return resultList;
            }
        };
    }

    protected void checkParameterComment(File sqlFile, String sql) {
        if (this.getOutsideSqlProperties().isSuppressParameterCommentCheck()) {
            return;
        }
        DfOutsideSqlChecker checker = new DfOutsideSqlChecker();
        if (this.getBasicProperties().isTargetLanguageJava()) {
            checker.enableIfCommentExpressionCheck();
        }
        if (this.getOutsideSqlProperties().isRequiredSqlTitle()) {
            checker.enableRequiredTitleCheck();
        }
        if (this.getOutsideSqlProperties().isRequiredSqlDescription()) {
            checker.enableRequiredDescriptionCheck();
        }
        checker.check(sqlFile.getName(), sql);
    }

    @Override
    protected String getSqlDirectory() {
        return this.getOutsideSqlProperties().getSqlDirectory();
    }

    @Override
    protected boolean isAutoCommit() {
        return false;
    }

    @Override
    protected boolean isErrorContinue() {
        return false;
    }

    @Override
    protected boolean isRollbackOnly() {
        return true;
    }

    @Override
    protected void customizeRunnerInformation(DfRunnerInformation runInfo) {
        runInfo.setEncoding(this.getOutsideSqlProperties().getSqlFileEncoding());
    }

    @Override
    protected void showTargetSqlFileInformation(List<File> sqlFileList) {
        String specifiedSqlFile;
        super.showTargetSqlFileInformation(sqlFileList);
        if (this._nonTargetSqlCount > 0) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
            _log.info((Object)("Non target SQL count: " + this._nonTargetSqlCount));
            _log.info((Object)"- - - - - - - - - -/");
            _log.info((Object)" ");
        }
        if ((specifiedSqlFile = DfSpecifiedSqlFile.getInstance().getSpecifiedSqlFile()) != null) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - -");
            _log.info((Object)("Specified SQL file: " + specifiedSqlFile));
            _log.info((Object)"- - - - - - - - - -/");
            _log.info((Object)" ");
        }
    }

    protected DfOutsideSqlProperties getOutsideSqlProperties() {
        return this.getProperties().getOutsideSqlProperties();
    }

    public void setSpecifiedSqlFile(String specifiedSqlFile) {
        DfSpecifiedSqlFile.getInstance().setSpecifiedSqlFile(specifiedSqlFile);
    }
}

