/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.replaceschema.loaddata.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.exception.DfTableDataRegistrationFailureException;
import org.seasar.dbflute.exception.DfTableNotFoundException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.helper.dataset.DfDataColumn;
import org.seasar.dbflute.helper.dataset.DfDataRow;
import org.seasar.dbflute.helper.dataset.DfDataSet;
import org.seasar.dbflute.helper.dataset.DfDataTable;
import org.seasar.dbflute.helper.dataset.states.DfDtsCreatedState;
import org.seasar.dbflute.helper.dataset.states.DfDtsSqlContext;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnType;
import org.seasar.dbflute.helper.dataset.types.DfDtsColumnTypes;
import org.seasar.dbflute.helper.io.xls.DfXlsReader;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfColumnMetaInfo;
import org.seasar.dbflute.logic.replaceschema.loaddata.DfXlsDataHandler;
import org.seasar.dbflute.logic.replaceschema.loaddata.impl.DfAbsractDataWriter;
import org.seasar.dbflute.properties.filereader.DfMapStringFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfXlsDataHandlerImpl
extends DfAbsractDataWriter
implements DfXlsDataHandler {
    private static final Log _log = LogFactory.getLog(DfXlsDataHandlerImpl.class);
    protected Pattern _skipSheetPattern;

    public DfXlsDataHandlerImpl(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public List<DfDataSet> readSeveralData(String dataDirectoryName) {
        List<File> xlsList = this.getXlsList(dataDirectoryName);
        ArrayList<DfDataSet> ls = new ArrayList<DfDataSet>();
        for (File file : xlsList) {
            DfXlsReader xlsReader = this.createXlsReader(dataDirectoryName, file);
            ls.add(xlsReader.read());
        }
        return ls;
    }

    @Override
    public void writeSeveralData(String dataDirectoryName) {
        List<File> xlsList = this.getXlsList(dataDirectoryName);
        for (File file : xlsList) {
            _log.info((Object)"");
            _log.info((Object)"/= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ");
            _log.info((Object)("writeData(" + file + ")"));
            _log.info((Object)"= = = = = = =/");
            DfXlsReader xlsReader = this.createXlsReader(dataDirectoryName, file);
            DfDataSet dataSet = xlsReader.read();
            this.filterValidColumn(dataSet);
            this.setupDefaultValue(dataDirectoryName, dataSet);
            this.doWriteDataSet(file, dataSet);
        }
    }

    protected void doWriteDataSet(File file, DfDataSet dataSet) {
        for (int i = 0; i < dataSet.getTableSize(); ++i) {
            DfDataTable dataTable = dataSet.getTable(i);
            this.doWriteDataTable(file, dataTable);
        }
    }

    /*
     * Loose catch block
     */
    protected void doWriteDataTable(File file, DfDataTable dataTable) {
        block20: {
            SQLException ignored22;
            Statement ps;
            Connection conn;
            String tableName;
            block19: {
                block18: {
                    tableName = dataTable.getTableName();
                    if (dataTable.getRowSize() == 0) {
                        _log.info((Object)("*Not found row at the table: " + tableName));
                        return;
                    }
                    Map<String, DfColumnMetaInfo> columnMetaInfoMap = this.getColumnMetaInfo(tableName);
                    this.beforeHandlingTable(dataTable);
                    ArrayList<String> columnNameList = new ArrayList<String>();
                    for (int j = 0; j < dataTable.getColumnSize(); ++j) {
                        DfDataColumn dataColumn = dataTable.getColumn(j);
                        String columnName = dataColumn.getColumnName();
                        columnNameList.add(columnName);
                    }
                    conn = null;
                    ps = null;
                    conn = this._dataSource.getConnection();
                    for (int j = 0; j < dataTable.getRowSize(); ++j) {
                        DfDataRow dataRow = dataTable.getRow(j);
                        if (ps == null) {
                            MyCreatedState myCreatedState = new MyCreatedState();
                            String preparedSql = myCreatedState.buildPreparedSql(dataRow);
                            ps = conn.prepareStatement(preparedSql);
                        }
                        this.doWriteDataRow(file, dataTable, dataRow, columnMetaInfoMap, columnNameList, conn, (PreparedStatement)ps);
                    }
                    if (this._suppressBatchUpdate) break block18;
                    ps.executeBatch();
                }
                Object var13_18 = null;
                if (ps == null) break block19;
                try {
                    ps.close();
                }
                catch (SQLException ignored22) {
                    _log.info((Object)"Statement#close() threw the exception!", (Throwable)ignored22);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                    break block20;
                }
                catch (SQLException ignored22) {
                    _log.info((Object)"Connection#close() threw the exception!", (Throwable)ignored22);
                }
                {
                }
            }
            break block20;
            {
                catch (SQLException e) {
                    SQLException nextEx = e.getNextException();
                    if (nextEx != null && !e.equals(nextEx)) {
                        _log.warn((Object)("*Failed to register: " + e.getMessage()));
                        String msg = this.buildExceptionMessage(file, tableName, nextEx);
                        throw new DfTableDataRegistrationFailureException(msg, nextEx);
                    }
                    String msg = this.buildExceptionMessage(file, tableName, e);
                    throw new DfTableDataRegistrationFailureException(msg, e);
                }
            }
            catch (Throwable throwable) {
                SQLException ignored22;
                Object var13_19 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignored22) {
                        _log.info((Object)"Statement#close() threw the exception!", (Throwable)ignored22);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ignored22) {
                        _log.info((Object)"Connection#close() threw the exception!", (Throwable)ignored22);
                    }
                }
                this.finallyHandlingTable(dataTable);
                throw throwable;
            }
        }
        this.finallyHandlingTable(dataTable);
    }

    protected String buildExceptionMessage(File file, String tableName, Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to register the table data.");
        br.addItem("Xls File");
        br.addElement((Object)file);
        br.addItem("Table");
        br.addElement((Object)tableName);
        br.addItem("Message");
        br.addElement((Object)e.getMessage());
        Map bindTypeCacheMap = (Map)this._bindTypeCacheMap.get(tableName);
        if (bindTypeCacheMap != null) {
            br.addItem("Bind Type");
            Set entrySet = bindTypeCacheMap.entrySet();
            for (Map.Entry entry : entrySet) {
                br.addElement((Object)((String)entry.getKey() + " = " + entry.getValue()));
            }
        }
        Map stringProcessorCacheMap = (Map)this._stringProcessorCacheMap.get(tableName);
        if (bindTypeCacheMap != null) {
            br.addItem("String Processor");
            Set entrySet = stringProcessorCacheMap.entrySet();
            for (Map.Entry entry : entrySet) {
                br.addElement((Object)((String)entry.getKey() + " = " + entry.getValue()));
            }
        }
        return br.buildExceptionMessage();
    }

    protected void beforeHandlingTable(DfDataTable dataTable) {
    }

    protected void finallyHandlingTable(DfDataTable dataTable) {
    }

    protected void doWriteDataRow(File file, DfDataTable dataTable, DfDataRow dataRow, Map<String, DfColumnMetaInfo> columnMetaInfoMap, List<String> columnNameList, Connection conn, PreparedStatement ps) throws SQLException {
        String tableName = dataTable.getTableName();
        ColumnContainer columnContainer = this.createColumnContainer(dataTable, dataRow);
        Map<String, Object> columnValueMap = columnContainer.getColumnValueMap();
        if (columnValueMap.isEmpty()) {
            String msg = "The table was not found in the file:";
            msg = msg + " tableName=" + tableName + " file=" + file;
            throw new DfTableNotFoundException(msg);
        }
        if (this._loggingInsertSql) {
            ArrayList<Object> valueList = new ArrayList<Object>(columnValueMap.values());
            _log.info((Object)this.getSql4Log(tableName, columnNameList, valueList));
        }
        int bindCount = 1;
        Set<Map.Entry<String, Object>> entrySet = columnValueMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            Object obj;
            String columnName = entry.getKey();
            if (this.processNull(tableName, columnName, obj = entry.getValue(), ps, bindCount, columnMetaInfoMap)) {
                ++bindCount;
                continue;
            }
            if (this.processNotNullNotString(tableName, columnName, obj, conn, ps, bindCount, columnMetaInfoMap)) {
                ++bindCount;
                continue;
            }
            String value = (String)obj;
            this.processNotNullString(tableName, columnName, value, conn, ps, bindCount, columnMetaInfoMap);
            ++bindCount;
        }
        if (this._suppressBatchUpdate) {
            ps.execute();
        } else {
            ps.addBatch();
        }
    }

    protected DfXlsReader createXlsReader(String dataDirectoryName, File file) {
        Map<String, String> tableNameMap = this.getTableNameMap(dataDirectoryName);
        Map<String, List<String>> notTrimTableColumnMap = this.getNotTrimTableColumnMap(dataDirectoryName);
        Map<String, List<String>> emptyStringTableColumnMap = this.getEmptyStringTableColumnMap(dataDirectoryName);
        DfXlsReader xlsReader = new DfXlsReader(file, tableNameMap, notTrimTableColumnMap, emptyStringTableColumnMap, this._skipSheetPattern);
        if (tableNameMap != null && !tableNameMap.isEmpty()) {
            _log.info((Object)"/- - - - - - - - - - - - - - - - - - - - - - - - - - - - ");
            _log.info((Object)("tableNameMap = " + tableNameMap));
            _log.info((Object)"- - - - - - - - - -/");
        }
        return xlsReader;
    }

    @Override
    public List<File> getXlsList(String dataDirectoryName) {
        Comparator<File> fileNameAscComparator = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        TreeSet<File> sortedFileSet = new TreeSet<File>(fileNameAscComparator);
        File dir = new File(dataDirectoryName);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xls");
            }
        };
        File[] listFiles = dir.listFiles(filter);
        if (listFiles == null) {
            return new ArrayList<File>();
        }
        for (File file : listFiles) {
            sortedFileSet.add(file);
        }
        return new ArrayList<File>(sortedFileSet);
    }

    protected void filterValidColumn(DfDataSet dataSet) {
        for (int i = 0; i < dataSet.getTableSize(); ++i) {
            DfDataTable table = dataSet.getTable(i);
            String tableName = table.getTableName();
            Map<String, DfColumnMetaInfo> metaInfoMap = this.getColumnMetaInfo(tableName);
            for (int j = 0; j < table.getColumnSize(); ++j) {
                DfDataColumn dataColumn = table.getColumn(j);
                if (metaInfoMap.containsKey(dataColumn.getColumnName())) continue;
                dataColumn.setWritable(false);
            }
        }
    }

    protected void setupDefaultValue(String dataDirectoryName, DfDataSet dataSet) {
        Map<String, String> defaultValueMap = this.getDefaultValueMap(dataDirectoryName);
        for (int i = 0; i < dataSet.getTableSize(); ++i) {
            DfDataTable table = dataSet.getTable(i);
            Set<String> defaultValueMapKeySet = defaultValueMap.keySet();
            String tableName = table.getTableName();
            Map<String, DfColumnMetaInfo> metaInfoMap = this.getColumnMetaInfo(tableName);
            for (String defaultTargetColumnName : defaultValueMapKeySet) {
                Object value;
                DfDtsColumnType columnType;
                String defaultValue = defaultValueMap.get(defaultTargetColumnName);
                if (!metaInfoMap.containsKey(defaultTargetColumnName) || table.hasColumn(defaultTargetColumnName)) continue;
                if (defaultValue.equalsIgnoreCase("sysdate")) {
                    columnType = DfDtsColumnTypes.TIMESTAMP;
                    value = new Timestamp(System.currentTimeMillis());
                } else {
                    columnType = DfDtsColumnTypes.STRING;
                    value = defaultValue;
                }
                table.addColumn(defaultTargetColumnName, columnType);
                int rowSize = table.getRowSize();
                for (int j = 0; j < table.getRowSize(); ++j) {
                    DfDataRow row = table.getRow(j);
                    row.addValue(defaultTargetColumnName, value);
                    ++rowSize;
                }
            }
        }
    }

    private Map<String, String> getDefaultValueMap(String dataDirectoryName) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = dataDirectoryName + "/defaultValueMap.dataprop";
        Map<String, String> resultMap = reader.readMapAsStringValue(path);
        if (resultMap != null && !resultMap.isEmpty()) {
            return resultMap;
        }
        path = dataDirectoryName + "/default-value.txt";
        resultMap = reader.readMapAsStringValue(path);
        return resultMap;
    }

    private Map<String, String> getTableNameMap(String dataDirectoryName) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = dataDirectoryName + "/tableNameMap.dataprop";
        Map<String, String> resultMap = reader.readMapAsStringValue(path);
        if (resultMap == null || resultMap.isEmpty()) {
            path = dataDirectoryName + "/table-name.txt";
            resultMap = reader.readMapAsStringValue(path);
        }
        StringKeyMap flmap = StringKeyMap.createAsFlexible();
        flmap.putAll(resultMap);
        return flmap;
    }

    private Map<String, List<String>> getNotTrimTableColumnMap(String dataDirectoryName) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = dataDirectoryName + "/notTrimColumnMap.dataprop";
        Map<String, List<String>> resultMap = reader.readMapAsStringListValue(path);
        if (resultMap == null || resultMap.isEmpty()) {
            path = dataDirectoryName + "/not-trim-column.txt";
            resultMap = reader.readMapAsStringListValue(path);
        }
        Set<Map.Entry<String, List<String>>> entrySet = resultMap.entrySet();
        StringKeyMap stringKeyMap = StringKeyMap.createAsFlexible();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            stringKeyMap.put(entry.getKey(), entry.getValue());
        }
        return stringKeyMap;
    }

    private Map<String, List<String>> getEmptyStringTableColumnMap(String dataDirectoryName) {
        DfMapStringFileReader reader = new DfMapStringFileReader();
        String path = dataDirectoryName + "/emptyStringColumnMap.dataprop";
        Map<String, List<String>> resultMap = reader.readMapAsStringListValue(path);
        if (resultMap == null || resultMap.isEmpty()) {
            path = dataDirectoryName + "/empty-string-column.txt";
            resultMap = reader.readMapAsStringListValue(path);
        }
        Set<Map.Entry<String, List<String>>> entrySet = resultMap.entrySet();
        StringKeyMap stringKeyMap = StringKeyMap.createAsFlexible();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            stringKeyMap.put(entry.getKey(), entry.getValue());
        }
        return stringKeyMap;
    }

    protected String getSql4Log(String tableName, List<String> columnNameList, List<? extends Object> bindParameters) {
        String bindParameterString = bindParameters.toString();
        bindParameterString = bindParameterString.substring(1, bindParameterString.length() - 1);
        return tableName + ":{" + bindParameterString + "}";
    }

    protected ColumnContainer createColumnContainer(DfDataTable dataTable, DfDataRow dataRow) {
        ColumnContainer container = new ColumnContainer();
        for (int i = 0; i < dataTable.getColumnSize(); ++i) {
            DfDataColumn dataColumn = dataTable.getColumn(i);
            if (!dataColumn.isWritable()) continue;
            Object value = dataRow.getValue(i);
            String columnName = dataColumn.getColumnName();
            container.addColumnValue(columnName, value);
            container.addColumnObject(columnName, dataColumn);
        }
        return container;
    }

    public void setSkipSheet(String skipSheet) {
        if (skipSheet == null || skipSheet.trim().length() == 0) {
            return;
        }
        try {
            this._skipSheetPattern = Pattern.compile(skipSheet);
        }
        catch (PatternSyntaxException e) {
            String msg = "The pattern syntax for skip-sheet was wrong: " + skipSheet;
            throw new IllegalStateException(msg, e);
        }
    }

    protected static class MyCreatedState {
        protected MyCreatedState() {
        }

        public String buildPreparedSql(final DfDataRow row) {
            DfDtsCreatedState createdState = new DfDtsCreatedState(){

                public String toString() {
                    DfDtsSqlContext sqlContext = this.getSqlContext(row);
                    return sqlContext.getSql();
                }
            };
            return createdState.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ColumnContainer {
        protected Map<String, Object> columnValueMap = new LinkedHashMap<String, Object>();
        protected Map<String, DfDataColumn> columnObjectMap = new LinkedHashMap<String, DfDataColumn>();

        protected ColumnContainer() {
        }

        public Map<String, Object> getColumnValueMap() {
            return this.columnValueMap;
        }

        public void addColumnValue(String columnName, Object columnValue) {
            this.columnValueMap.put(columnName, columnValue);
        }

        public Map<String, DfDataColumn> getColumnObjectMap() {
            return this.columnObjectMap;
        }

        public void addColumnObject(String columnName, DfDataColumn columnObject) {
            this.columnObjectMap.put(columnName, columnObject);
        }
    }
}

