/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql;

import org.seasar.dbflute.exception.CommentTerminatorNotFoundException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.util.DfSystemUtil;

public class SqlTokenizer {
    public static final int SQL = 1;
    public static final int COMMENT = 2;
    public static final int ELSE = 3;
    public static final int BIND_VARIABLE = 4;
    public static final int EOF = 99;
    protected final String sql;
    protected int position = 0;
    protected String token;
    protected int tokenType = 1;
    protected int nextTokenType = 1;
    protected int bindVariableNum = 0;

    public SqlTokenizer(String sql) {
        this.sql = sql;
    }

    public int next() {
        if (this.position >= this.sql.length()) {
            this.token = null;
            this.tokenType = 99;
            this.nextTokenType = 99;
            return this.tokenType;
        }
        switch (this.nextTokenType) {
            case 1: {
                this.parseSql();
                break;
            }
            case 2: {
                this.parseComment();
                break;
            }
            case 3: {
                this.parseElse();
                break;
            }
            case 4: {
                this.parseBindVariable();
                break;
            }
            default: {
                this.parseEof();
            }
        }
        return this.tokenType;
    }

    protected void parseSql() {
        int nextStartPos;
        int skipPos;
        int commentStartPos = this.sql.indexOf("/*", this.position);
        int commentStartPos2 = this.sql.indexOf("#*", this.position);
        if (0 < commentStartPos2 && commentStartPos2 < commentStartPos) {
            commentStartPos = commentStartPos2;
        }
        int lineCommentStartPos = this.sql.indexOf("--", this.position);
        int bindVariableStartPos = this.sql.indexOf("?", this.position);
        int elseCommentStartPos = -1;
        int elseCommentLength = -1;
        if (lineCommentStartPos >= 0 && (skipPos = this.skipWhitespace(lineCommentStartPos + 2)) + 4 < this.sql.length() && "ELSE".equals(this.sql.substring(skipPos, skipPos + 4))) {
            elseCommentStartPos = lineCommentStartPos;
            elseCommentLength = skipPos + 4 - lineCommentStartPos;
        }
        if ((nextStartPos = this.getNextStartPos(commentStartPos, elseCommentStartPos, bindVariableStartPos)) < 0) {
            this.token = this.sql.substring(this.position);
            this.nextTokenType = 99;
            this.position = this.sql.length();
            this.tokenType = 1;
        } else {
            boolean needNext;
            this.token = this.sql.substring(this.position, nextStartPos);
            this.tokenType = 1;
            boolean bl = needNext = nextStartPos == this.position;
            if (nextStartPos == commentStartPos) {
                this.nextTokenType = 2;
                this.position = commentStartPos + 2;
            } else if (nextStartPos == elseCommentStartPos) {
                this.nextTokenType = 3;
                this.position = elseCommentStartPos + elseCommentLength;
            } else if (nextStartPos == bindVariableStartPos) {
                this.nextTokenType = 4;
                this.position = bindVariableStartPos;
            }
            if (needNext) {
                this.next();
            }
        }
    }

    protected int getNextStartPos(int commentStartPos, int elseCommentStartPos, int bindVariableStartPos) {
        int nextStartPos = -1;
        if (commentStartPos >= 0) {
            nextStartPos = commentStartPos;
        }
        if (elseCommentStartPos >= 0 && (nextStartPos < 0 || elseCommentStartPos < nextStartPos)) {
            nextStartPos = elseCommentStartPos;
        }
        if (bindVariableStartPos >= 0 && (nextStartPos < 0 || bindVariableStartPos < nextStartPos)) {
            nextStartPos = bindVariableStartPos;
        }
        return nextStartPos;
    }

    protected String nextBindVariableName() {
        return "$" + ++this.bindVariableNum;
    }

    protected void parseComment() {
        int commentEndPos = this.sql.indexOf("*/", this.position);
        int commentEndPos2 = this.sql.indexOf("*#", this.position);
        if (0 < commentEndPos2 && commentEndPos2 < commentEndPos) {
            commentEndPos = commentEndPos2;
        }
        if (commentEndPos < 0) {
            this.throwCommentTerminatorNotFoundException(this.sql.substring(this.position));
        }
        this.token = this.sql.substring(this.position, commentEndPos);
        this.nextTokenType = 1;
        this.position = commentEndPos + 2;
        this.tokenType = 2;
    }

    protected void throwCommentTerminatorNotFoundException(String expression) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The comment end was NOT found!");
        br.addItem("Advice");
        br.addElement("Please confirm the SQL comment writing.");
        br.addElement("Any comments DOESN'T have a comment end.");
        br.addElement("For example:");
        br.addElement("  (x) -- /*pmb.xxxId3");
        br.addElement("  (o) -- /*pmb.xxxId*/3");
        br.addItem("Specified SQL");
        br.addElement(expression);
        br.addItem("Comment Expression");
        br.addElement(this.sql);
        String msg = br.buildExceptionMessage();
        throw new CommentTerminatorNotFoundException(msg);
    }

    protected void parseBindVariable() {
        this.token = this.nextBindVariableName();
        this.nextTokenType = 1;
        ++this.position;
        this.tokenType = 4;
    }

    protected void parseElse() {
        this.token = null;
        this.nextTokenType = 1;
        this.tokenType = 3;
    }

    protected void parseEof() {
        this.token = null;
        this.tokenType = 99;
        this.nextTokenType = 99;
    }

    public String skipToken() {
        return this.skipToken(false);
    }

    public String skipToken(boolean testValue) {
        int i;
        int index = this.sql.length();
        String dateLiteralPrefix = this.extractDateLiteralPrefix(testValue, this.sql, this.position);
        if (dateLiteralPrefix != null) {
            this.position += dateLiteralPrefix.length();
        }
        char firstChar = this.position < this.sql.length() ? this.sql.charAt(this.position) : (char)'\u0000';
        char quote = firstChar == '(' ? (char)')' : (char)firstChar;
        boolean quoting = quote == '\'' || quote == ')';
        int n = i = quoting ? this.position + 1 : this.position;
        while (i < this.sql.length()) {
            char c = this.sql.charAt(i);
            if (this.isNotQuoteEndPoint(quoting, c)) {
                index = i;
                break;
            }
            if (this.isBlockCommentBeginPoint(this.sql, c, i)) {
                index = i;
                break;
            }
            if (this.isLineCommentBeginPoint(this.sql, c, i)) {
                index = i;
                break;
            }
            if (quoting && this.isSingleQuoteEndPoint(this.sql, quote, c, i)) {
                index = i + 1;
                break;
            }
            if (quoting && this.isQuoteEndPoint(this.sql, quote, c, i)) {
                index = i + 1;
                break;
            }
            ++i;
        }
        this.token = this.sql.substring(this.position, index);
        if (dateLiteralPrefix != null) {
            this.token = dateLiteralPrefix + this.token;
        }
        this.tokenType = 1;
        this.nextTokenType = 1;
        this.position = index;
        return this.token;
    }

    protected String extractDateLiteralPrefix(boolean testValue, String currentSql, int position) {
        if (!testValue) {
            return null;
        }
        if (position >= currentSql.length()) {
            return null;
        }
        char firstChar = currentSql.charAt(position);
        if (firstChar != 'd' && firstChar != 'D' && firstChar != 't' && firstChar != 'T') {
            return null;
        }
        String tmpRear = currentSql.substring(position);
        int maxlength = "timestamp '".length();
        String rear = tmpRear.length() > maxlength ? tmpRear.substring(0, maxlength) : tmpRear;
        String lowerRear = rear.toLowerCase();
        String literalPrefix = null;
        if (lowerRear.startsWith("date '")) {
            literalPrefix = rear.substring(0, "date ".length());
        } else if (lowerRear.startsWith("date'")) {
            literalPrefix = rear.substring(0, "date".length());
        } else if (lowerRear.startsWith("timestamp '")) {
            literalPrefix = rear.substring(0, "timestamp ".length());
        } else if (lowerRear.startsWith("timestamp'")) {
            literalPrefix = rear.substring(0, "timestamp".length());
        }
        return literalPrefix;
    }

    protected boolean isNotQuoteEndPoint(boolean quoting, char c) {
        return !quoting && (Character.isWhitespace(c) || c == ',' || c == ')' || c == '(');
    }

    protected boolean isBlockCommentBeginPoint(String currentSql, char c, int i) {
        return c == '/' && this.isNextCharacter(currentSql, i, '*');
    }

    protected boolean isLineCommentBeginPoint(String currentSql, char c, int i) {
        return c == '-' && this.isNextCharacter(currentSql, i, '-');
    }

    protected boolean isSingleQuoteEndPoint(String currentSql, char quote, char c, int i) {
        int sqlLen = currentSql.length();
        boolean endSqlOrNotEscapeQuote = i + 1 >= sqlLen || currentSql.charAt(i + 1) != '\'';
        return quote == '\'' && c == '\'' && endSqlOrNotEscapeQuote;
    }

    protected boolean isQuoteEndPoint(String currentSql, char quote, char c, int i) {
        return c == quote;
    }

    protected boolean isNextCharacter(String currentSql, int i, char targetChar) {
        return i + 1 < currentSql.length() && currentSql.charAt(i + 1) == targetChar;
    }

    public String skipWhitespace() {
        int index = this.skipWhitespace(this.position);
        this.token = this.sql.substring(this.position, index);
        this.position = index;
        return this.token;
    }

    protected int skipWhitespace(int position) {
        int index = this.sql.length();
        for (int i = position; i < this.sql.length(); ++i) {
            char c = this.sql.charAt(i);
            if (Character.isWhitespace(c)) continue;
            index = i;
            break;
        }
        return index;
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public int getPosition() {
        return this.position;
    }

    public String getToken() {
        return this.token;
    }

    public String getBefore() {
        return this.sql.substring(0, this.position);
    }

    public String getAfter() {
        return this.sql.substring(this.position);
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public int getNextTokenType() {
        return this.nextTokenType;
    }
}

