/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.logic.jdbc.handler;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.logic.jdbc.handler.DfAbstractMetaDataHandler;
import org.seasar.dbflute.logic.jdbc.metadata.info.DfTableMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfIndexHandler
extends DfAbstractMetaDataHandler {
    private static final Log _log = LogFactory.getLog(DfIndexHandler.class);

    public Map<String, Map<Integer, String>> getIndexMap(DatabaseMetaData dbMeta, String schemaName, DfTableMetaInfo tableMetaInfo, Map<String, Map<Integer, String>> uniqueKeyMap) throws SQLException {
        schemaName = this.filterSchemaName(schemaName);
        schemaName = tableMetaInfo.selectMetaExtractingSchemaName(schemaName);
        String tableName = tableMetaInfo.getTableName();
        if (tableMetaInfo.isTableTypeView()) {
            return new LinkedHashMap<String, Map<Integer, String>>();
        }
        return this.getIndexMap(dbMeta, schemaName, tableName, uniqueKeyMap);
    }

    public Map<String, Map<Integer, String>> getIndexMap(DatabaseMetaData dbMeta, String schemaName, String tableName, Map<String, Map<Integer, String>> uniqueKeyMap) throws SQLException {
        Map<String, Map<Integer, String>> resultMap = this.doGetIndexMap(dbMeta, schemaName, tableName, uniqueKeyMap);
        if (resultMap.isEmpty()) {
            resultMap = this.doGetIndexMap(dbMeta, schemaName, tableName.toLowerCase(), uniqueKeyMap);
        }
        if (resultMap.isEmpty()) {
            resultMap = this.doGetIndexMap(dbMeta, schemaName, tableName.toUpperCase(), uniqueKeyMap);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Map<String, Map<Integer, String>> doGetIndexMap(DatabaseMetaData dbMeta, String schemaName, String tableName, Map<String, Map<Integer, String>> uniqueKeyMap) throws SQLException {
        LinkedHashMap<String, Map<Integer, String>> indexMap = new LinkedHashMap<String, Map<Integer, String>>();
        ResultSet parts = null;
        try {
            boolean uniqueKeyOnly = false;
            parts = dbMeta.getIndexInfo(null, schemaName, tableName, false, true);
            while (parts.next()) {
                Map<Integer, String> uniqueElementMap;
                Integer ordinalPosition;
                String indexName = parts.getString(6);
                String nonUnique = parts.getString(4);
                boolean isNonUnique = nonUnique != null && nonUnique.equalsIgnoreCase("true");
                if (!isNonUnique || uniqueKeyMap != null && uniqueKeyMap.containsKey(indexName)) continue;
                String indexType = parts.getString(7);
                String columnName = parts.getString(9);
                if (columnName == null || columnName.trim().length() == 0 || this.isColumnExcept(schemaName, tableName, columnName)) continue;
                String ordinalPositionString = parts.getString(8);
                if (ordinalPositionString == null) {
                    String msg = "The unique columnName should have ordinal-position but null: ";
                    msg = msg + " columnName=" + columnName + " indexType=" + indexType;
                    _log.warn((Object)msg);
                    continue;
                }
                try {
                    ordinalPosition = Integer.parseInt(ordinalPositionString);
                }
                catch (NumberFormatException e) {
                    String msg = "The unique column should have ordinal-position as number but: ";
                    msg = msg + ordinalPositionString + " columnName=" + columnName + " indexType=" + indexType;
                    _log.warn((Object)msg);
                    continue;
                }
                if (indexMap.containsKey(indexName)) {
                    uniqueElementMap = (Map)indexMap.get(indexName);
                    uniqueElementMap.put(ordinalPosition, columnName);
                    continue;
                }
                uniqueElementMap = new LinkedHashMap();
                uniqueElementMap.put(ordinalPosition, columnName);
                indexMap.put(indexName, uniqueElementMap);
            }
            Object var17_17 = null;
            if (parts == null) return indexMap;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            if (parts == null) throw throwable;
            parts.close();
            throw throwable;
        }
        parts.close();
        return indexMap;
    }
}

