/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.rowcreator.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnDtoMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.rowcreator.TnRowCreator;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnRowCreatorImpl
implements TnRowCreator {
    protected Object newBean(Class<?> beanClass) {
        return DfReflectionUtil.newInstance(beanClass);
    }

    @Override
    public Map<String, TnPropertyType> createPropertyCache(Set<String> columnNames, TnBeanMetaData beanMetaData) throws SQLException {
        Map<String, TnPropertyType> proprertyCache = this.newPropertyCache();
        this.setupPropertyCache(proprertyCache, columnNames, beanMetaData);
        return proprertyCache;
    }

    protected void setupPropertyCache(Map<String, TnPropertyType> proprertyCache, Set<String> columnNames, TnBeanMetaData beanMetaData) throws SQLException {
        List<TnPropertyType> ptList = beanMetaData.getPropertyTypeList();
        for (TnPropertyType pt : ptList) {
            if (!this.isTargetProperty(pt)) continue;
            this.setupPropertyCacheElement(proprertyCache, columnNames, pt);
        }
    }

    protected void setupPropertyCacheElement(Map<String, TnPropertyType> proprertyCache, Set<String> columnNames, TnPropertyType pt) throws SQLException {
        if (columnNames.contains(pt.getColumnName())) {
            proprertyCache.put(pt.getColumnName(), pt);
        } else if (columnNames.contains(pt.getPropertyName())) {
            proprertyCache.put(pt.getPropertyName(), pt);
        } else if (!pt.isPersistent()) {
            this.setupPropertyCacheNotPersistentElement(proprertyCache, columnNames, pt);
        }
    }

    protected void setupPropertyCacheNotPersistentElement(Map<String, TnPropertyType> proprertyCache, Set<String> columnNames, TnPropertyType pt) throws SQLException {
        for (String columnName : columnNames) {
            String columnName2 = DfStringUtil.replace(columnName, "_", "");
            if (!columnName2.equalsIgnoreCase(pt.getColumnName())) continue;
            proprertyCache.put(columnName, pt);
            break;
        }
    }

    @Override
    public Map<String, TnPropertyType> createPropertyCache(Set<String> columnNames, TnDtoMetaData dtoMetaData) throws SQLException {
        Map<String, TnPropertyType> proprertyCache = this.newPropertyCache();
        this.setupPropertyCache(proprertyCache, columnNames, dtoMetaData);
        return proprertyCache;
    }

    protected void setupPropertyCache(Map<String, TnPropertyType> proprertyCache, Set<String> columnNames, TnDtoMetaData dtoMetaData) throws SQLException {
        List<TnPropertyType> ptList = dtoMetaData.getPropertyTypeList();
        for (TnPropertyType pt : ptList) {
            if (!this.isTargetProperty(pt)) continue;
            if (columnNames.contains(pt.getColumnName())) {
                proprertyCache.put(pt.getColumnName(), pt);
                continue;
            }
            if (columnNames.contains(pt.getPropertyName())) {
                proprertyCache.put(pt.getPropertyName(), pt);
                continue;
            }
            String possibleName = DfStringUtil.decamelizePropertyName(pt.getPropertyName());
            if (!columnNames.contains(possibleName)) continue;
            proprertyCache.put(possibleName, pt);
        }
    }

    protected Map<String, TnPropertyType> newPropertyCache() {
        return StringKeyMap.createAsCaseInsensitive();
    }

    protected boolean isTargetProperty(TnPropertyType pt) throws SQLException {
        return pt.getPropertyDesc().isWritable();
    }
}

